/****************************************************************************

    PROGRAM: ATEZDLL.c
                          
    BY     : Ronnie Yazma, Copyright 1993 GEOTEST Inc.   
                          
    PURPOSE: Demonstarte ATEasy type DLL functions
    
    TO COMPILE:
             Use ATEZDLL.MAK when using Visual C/C++ v1.0 or MS-C 7.0
             Use ATEZDLL.PRJ when using Borland C/C++ v3.1     
             This file compiled in large memory model.
    
    VERSION: 2.00 (Jul-26-93)

    FUNCTIONS/SUBROUTINES:

         - MaxSub() : finds the max between 2 floats
         - MaxLongFunc() : return the max between 2 floats
         - AverageArray() : find the avarage of float array
         - NoSpaces() : delete leading & trailing spaces in a string
         - UCase2Dim() : convert 2 dim string to upper case
         
****************************************************************************/

#include <windows.h>
#include "ateasydl.h"   // contains ATEasy VAL, VAR parameters definitions 
#include <string.h>     // for memmove 
#include <ctype.h>      // for isspace, toupper

/****************************************************************************
   FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)

   PURPOSE:  Is called by LibEntry.  LibEntry is called by Windows when
             the DLL is loaded.  The LibEntry routine is provided in
             the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
             source LIBENTRY.ASM is also provided.)

             LibEntry initializes the DLL's heap, if a HEAPSIZE value is
             specified in the DLL's DEF file.  Then LibEntry calls
             LibMain.  The LibMain function below satisfies that call.

             The LibMain function should perform additional initialization
             tasks required by the DLL.  In this example, no initialization
             tasks are required.  LibMain should return a value of 1 if
             the initialization is successful.                 
             
             Some compilers vendors provides LibMain in their static libraries
             so you're allowed not to include this function.

****************************************************************************/
int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
    return(1);
}


/****************************************************************************

    FUNCTION: WEP(int)

    PURPOSE:  Performs cleanup tasks when the DLL is unloaded.  WEP() is
              called automatically by Windows when the DLL is unloaded (no
              remaining tasks still have the DLL loaded). Some compilers vendors
              provides WEP in their static libraries so you're allowed not to
              include this function (if you don't need cleanup). If you're 
              using MS-C it is much safer to use _WEP instead of WEP               .
              The WEP should return 1.
              
****************************************************************************/
int FAR PASCAL WEP(int nExitType)
{
    return(1);
}

/****************************************************************************

    FUNCTION: MaxSub(hWnd, dX1, dX2, lpdResult)

    PURPOSE:  Finds the max of 2 floats (dX1 & dX2) into lpdResult.

       This subroutine defined in ATEasy as:
       Max(fX1: VAL FLOAT, fX2: VAL FLOAT, fResult: VAR FLOAT): SUB DLL

****************************************************************************/
VOID _CALLBACK MaxSub(HWND hWnd, VAL_FLOAT dX1, VAL_FLOAT dX2, VAR_FLOAT lpdResult)
{
    *lpdResult=dX1 > dX2 ? dX1 : dX2;
}

/****************************************************************************

    FUNCTION: MaxLongFunc(hWnd, lX1, lX2)

    PURPOSE:  Returns the max of 2 longs (lX1 & lX2).
              Note that this is a function. 

       This function defined in ATEasy as:
       Long Max(lX1: VAL LONG, lX2: VAL LONG): Function DLL

****************************************************************************/
long _CALLBACK MaxLongFunc(HWND hWnd, VAL_LONG lX1, VAL_LONG lX2)
{
    return lX1 > lX2 ? lX1 : lX2;
}

/****************************************************************************

    FUNCTION: AverageArray(hWnd, vafNumbers, lpdResult)

    PURPOSE:  Calculate the mean value of vafNumbers array into lpdResult.

        This function defined in ATEasy as:
        AverageArray(afNumbers : VAL FLOAT[], dResult : VAR FLOAT) : SUB DLL

****************************************************************************/
VOID _CALLBACK AverageArray(HWND hWnd, VAL_AFLOAT vafNumbers, VAR_FLOAT lpdResult)
{
    double      dResult=0.0;
    short       i;

    for (i=0; i < vafNumbers->nDim2; i++)
        dResult+=(vafNumbers->Ptr.lpFloat)[i];
    if (vafNumbers->nDim2)
        dResult/=vafNumbers->nDim2;
    *lpdResult=dResult;
}

/****************************************************************************

    FUNCTION: NoSpaces(hWnd, vsString)

    PURPOSE:  Delete leading & trailing spaces in a string

        This function defined in ATEasy as:
        NoSpaces(s : VAR String)

****************************************************************************/
VOID _CALLBACK NoSpaces(HWND hWnd, VAR_ASTRING vsString)
{
    short       i, j;

    for (i=StrLen(vsString); i > 0; i--)            // delete trailing spaces 
        if (!isspace(Str(vsString)[i-1])) break;
    StrLen(vsString)=i;
    for (j=0; j < i; j++)                           // delete leading spaces 
        if (!isspace(Str(vsString)[j])) break;
    if (j)                                          // move to start 
    {   StrLen(vsString)-=j;
        memmove(Str(vsString), &Str(vsString)[j], StrLen(vsString));
    }
}

/****************************************************************************

    FUNCTION: UCase2Dim(hWnd, vasStrings)

    PURPOSE:  convert 2 dim string to upper case

        This function defined in ATEasy as:
        UCase2Dim(as : VAR String[,])

****************************************************************************/
VOID _CALLBACK UCase2Dim(HWND hWnd, VAR_ASTRING vasStrings)
{
    short       i, j, nLen;
    LPSTR       lp;

    for (i=0; i < vasStrings->nDim1; i++)
    {   lp=Str2D(vasStrings, i);                    // get the i string
        nLen=Str2DLen(vasStrings, i);               // get the string length
        for (j=0; j < nLen; j++)
            lp[j]=toupper(lp[j]);                   // convert to upper case
    }     
}

/****************************************************************************
                    E - O - F
****************************************************************************/
