{****************************************************************************

    PROGRAM: ATEZDLL.pas
                          
    BY     : Ronnie Yazma, Copyright 1993 GEOTEST Inc.   
                          
    PURPOSE: Demonstarte ATEasy type DLL functions using TPW 
    
    TO COMPILE:
             Use Turbo pascal for window. 

    VERSION: 2.00 (Jul-26-93)

    FUNCTIONS/SUBROUTINES:

         - MaxSub() : finds the max between 2 floats
         - MaxLongFunc() : return the max between 2 floats
         - AverageArray() : find the avarage of float array
         - NoSpaces() : delete leading & trailing spaces in a string
         - UCase2Dim() : convert 2 dim string to upper case
         
****************************************************************************}
{$N+}                       { Must be on for ATEasy Types }
{$M 2048, 2048}

library ATEZDLL;
uses wintypes;              { Must be included for windows types }

{$I ateasydl}               { Contains ATEasy VAL, VAR parameters definitions

{****************************************************************************

    FUNCTION: MaxSub(hWnd, dX1, dX2, lpdResult)

    PURPOSE:  Finds the max of 2 floats (dX1 & dX2) into lpdResult.

       This subroutine defined in ATEasy as:
       Max(fX1: VAL FLOAT, fX2: VAL FLOAT, fResult: VAR FLOAT): SUB DLL

****************************************************************************}
procedure MaxSub(hWnd : HWND; dX1, dX2 : VAL_FLOAT; lpdResult : VAR_FLOAT); export;
begin
    if dX1 < dX2 then
        lpdResult^:=dX2
    else
        lpdResult^:=dX1;
end;

{****************************************************************************

    FUNCTION: MaxLongFunc(hWnd, lX1, lX2)

    PURPOSE:  Returns the max of 2 longs (lX1 & lX2).
              Note that this is a function. 

       This function defined in ATEasy as:
       Long Max(lX1: VAL LONG, lX2: VAL LONG): Function DLL

****************************************************************************}
function MaxLongFunc(hWnd : HWND; lX1, lX2 : VAL_LONG):longint; export; 
begin   
    if lX1 < lX2 then
        MaxLongFunc:=lX2
    else
        MaxLongFunc:=lX1;
end;

{****************************************************************************

    FUNCTION: AverageArray(hWnd, vafNumbers, lpdResult)

    PURPOSE:  Calculate the mean value of vafNumbers array into lpdResult.

        This function defined in ATEasy as:
        AverageArray(afNumbers : VAL FLOAT[], dResult : VAR FLOAT) : SUB DLL

****************************************************************************}
procedure AverageArray(hWnd : HWND; vafNumbers : VAL_AFLOAT; lpdResult : VAR_FLOAT); export;
var
    dTResult : double;
    i : integer;
begin
    dTResult:=0.0;
    for i:=1 to vafNumbers^.nDim2 do
	dTResult:=dTResult+vafNumbers^.lpFloat^[i];
    if vafNumbers^.nDim2 <> 0 then
	dTResult:=dTResult / vafNumbers^.nDim2;
    lpdResult^:=dTResult;
end;

{****************************************************************************

    FUNCTION: NoSpaces(hWnd, vsString)

    PURPOSE:  Delete leading & trailing spaces in a string

        This function defined in ATEasy as:
        NoSpaces(s : VAR String)

****************************************************************************}
procedure NoSpaces(hWnd : HWND; vsString : VAR_ASTRING); export;
var
    i, j : integer;
begin
    i:=vsString^.lpString^.nLen;
    while (i > 0) and (vsString^.lpString^.lp[i] = ' ') do
	dec(i);
    vsString^.lpString^.nLen:=i;   { delete trailing spaces }
    j:=1;
    while (j <= i) and (vsString^.lpString^.lp[j] = ' ') do
    	inc(j);
    if (j > 1) then                { move to start }
    begin
     	dec(vsString^.lpString^.nLen, j-1);
	move(vsString^.lpString^.lp[j], vsString^.lpString^.lp, vsString^.lpString^.nLen);
    end;
end;

{****************************************************************************

    FUNCTION: UCase2Dim(hWnd, vasStrings)

    PURPOSE:  convert 2 dim string to upper case

        This function defined in ATEasy as:
        UCase2Dim(as : VAR String[,])

    COMMENT : You can use the strings unit and the PChar type
              when dealling with strings in a much more elegant way.    

****************************************************************************}
procedure UCase2Dim(hWnd : HWND; vasStrings : VAR_ASTRING); export;
type
    CHARARRAY = array[1..32767] of char; 
var
    i, j   : integer;
    lpnLen : ^integer;
    lp     : ^CHARARRAY;

begin
    for i:=1 to vasStrings^.nDim1 do
    begin
        { get the i string }
        lp:=@vasStrings^.lpString^.lp[(i-1)*(vasStrings^.nDim2+2)+1];
                     
        { get the string length }
{$IFOPT R+}
        { if range checking is on the array index must be positive }   
        if (i=1) then              
            lpnLen:=@vasStrings^.lpString^.nLen
        else
{$ENDIF}
            lpnLen:=@vasStrings^.lpString^.lp[(i-1)*(vasStrings^.nDim2+2)-1];     
        for j:=1 to lpnLen^ do
            lp^[j]:=UpCase(lp^[j]);      { convert to upper case }
    end;     
end;

{****************************************************************************
			Exports definition for the DLL
****************************************************************************}

exports  MaxSub        	index 100;
exports  MaxLongFunc   	index 101;
exports  AverageArray  	index 102;
exports  NoSpaces   	index 103;
exports  UCase2Dim   	index 104;

begin
    { Note:You can place here initialization code for your dll }
end.

{****************************************************************************
		    E - O - F
****************************************************************************}
