/****************************************************************************

    PROGRAM: CDLL.c
    
    BY     : Ronnie Yazma, Copyright 1993 GEOTEST Inc.   

    PURPOSE: Demonstarte None ATEasy type DLL functions.
             Demonstrates ATEasy Interface Sub.
    
    TO COMPILE:
             Use CDLL.MAK when using Visual C/C++ v1.0 or MS-C 7.0
             Use CDLL.PRJ when using Borland C/C++ v3.1     
             This file compiled in large memory model.

    VERSION: 2.00 (Jul-26-93)

    FUNCTIONS/SUBROUTINES:

         - MaxSub() : finds the max between 2 floats
         - MaxLongFunc() : return the max between 2 floats
         - AverageArray() : find the avarage of float array
         - NoSpaces() : delete leading & trailing spaces in a string
         - UCase2Dim() : convert 2 dim string to upper case
         - CommandInterface() : command interface sub 
         - CommandInterfaceDlg() : display a dialog box for the interface sub                
         
    COMMENTS:
           When using None ATEasy type DLL the parameters are passed from ATEasy
           in the following way:
           
           ATEasy                   DLL                     Remarks
           --------------------------------------------------------------------------
           VAL Byte                 char                    BYTE also applicable
           VAR Byte                 char FAR *
           VAL Int                  short                   WORD also applicable (int and UINT in 16 bit DLLs)
           VAR Int                  short FAR *
           VAL Long                 long                    DWORD also applicable 
           VAR Long                 long FAR *
           VAL Float                double
           VAR Float                double FAR *
           VAL/VAR String[]         char FAR * or LPSTR     null terminated string
           VAL/VAR String[,]        char FAR * FAR *        (array of pointers to strings)
           VAL/VAR xxx [] or [,]    xxx FAR *               (xxx is Byte/Int/Long/Float)
                      
        Note that the calling convention is PASCAL.
                      
****************************************************************************/

#include <windows.h>
#include <string.h>         // for memmove 
#include <ctype.h>          // for isspace, toupper 
#define  _NONATEASYDLL      // no need VAL/VAR definition
#include "ateasydl.h"       // for the LPINTERFACESUB and for _CALLBACK definition
#include "cdll.h"           // resorces ID's for CommandInterfaceDlg Dialog
                            
LPINTERFACEINFO lpGIInfo;   // gloabal varaible for AboutInterface
HINSTANCE       hGInstance; // global varaible remebers the current instance

BOOL _CALLBACK CommandInterfaceDlg(HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam);

/****************************************************************************
   FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)

   PURPOSE:  Is called by LibEntry.  LibEntry is called by Windows when
             the DLL is loaded.  The LibEntry routine is provided in
             the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
             source LIBENTRY.ASM is also provided.)

             LibEntry initializes the DLL's heap, if a HEAPSIZE value is
             specified in the DLL's DEF file.  Then LibEntry calls
             LibMain.  The LibMain function below satisfies that call.

             The LibMain function should perform additional initialization
             tasks required by the DLL.  In this example, no initialization
             tasks are required.  LibMain should return a value of 1 if
             the initialization is successful.                 
             
             Some compilers vendors provides LibMain in their static libraries
             so you're allowed not to include this function.

****************************************************************************/
int CALLBACK LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
    hGInstance=hInstance;
    return(1);
}


/****************************************************************************

    FUNCTION: WEP(int)

    PURPOSE:  Performs cleanup tasks when the DLL is unloaded.  WEP() is
              called automatically by Windows when the DLL is unloaded (no
              remaining tasks still have the DLL loaded). Some compilers vendors
              provides WEP in their static libraries so you're allowed not to
              include this function (if you don't need cleanup). If you're 
              using MS-C it is much safer to use _WEP instead of WEP               .
              The WEP should return 1.
              
****************************************************************************/
int _CALLBACK WEP(int nExitType)
{
    return(1);
}

/****************************************************************************

    FUNCTION: MaxSub(dX1, dX2, lpdResult)

    PURPOSE:  Finds the max of 2 floats (dX1 & dX2) into lpdResult.

       This subroutine defined in ATEasy as:
       Max(fX1: VAL FLOAT, fX2: VAL FLOAT, fResult: VAR FLOAT): SUB DLL

****************************************************************************/
void _CALLBACK MaxSub(double dX1, double dX2, double FAR * lpdResult)
{
    *lpdResult=dX1 > dX2 ? dX1 : dX2;
}

/****************************************************************************

    FUNCTION: MaxLongFunc(dX1, dX2)

    PURPOSE:  Returns the max of 2 longs (lX1 & lX2).
              Note that this is a function. 

       This function defined in ATEasy as:
       Long Max(lX1: VAL LONG, lX2: VAL LONG): Function DLL

****************************************************************************/
long _CALLBACK MaxLongFunc(long lX1, long lX2)
{
    return lX1 > lX2 ? lX1 : lX2;
}

/****************************************************************************

    FUNCTION: AverageArray(lpdNumbers, nCount, lpdResult)

    PURPOSE:  Calculate the mean value of lpdNumbers array into lpdResult.

        This function defined in ATEasy as:
        AverageArray(afNumbers : VAL FLOAT[], iCount : VAL Int, dResult : VAR FLOAT) : SUB DLL

****************************************************************************/
VOID _CALLBACK AverageArray(double FAR * lpdNumbers, short nCount, double FAR * lpdResult)
{
    double      dResult=0.0;
    short       i;

    for (i=0; i < nCount; i++)
        dResult+=lpdNumbers[i];
    if (nCount)
        dResult/=nCount;
    *lpdResult=dResult;
}

/****************************************************************************

    FUNCTION: NoSpaces(lpsz)

    PURPOSE:  Delete leading & trailing spaces in a string

        This function defined in ATEasy as:
        NoSpaces(s : VAR String)

****************************************************************************/
VOID _CALLBACK NoSpaces(LPSTR lpsz)
{
    short       i, j;

    for (i=strlen(lpsz); i > 0; i--)           // delete trailing spaces
        if (!isspace(lpsz[i-1])) break;
    lpsz[i]=0;
    for (j=0; j < i; j++)                      // delete leading spaces 
        if (!isspace(lpsz[j])) break;
    if (j)                                     // move to start 
        memmove(lpsz, lpsz+j, strlen(lpsz));
}

/****************************************************************************

    FUNCTION: UCase2Dim(lppsz, nCount)

    PURPOSE:  convert 2 dim string to upper case
              nCount hold number of strings.

        This function defined in ATEasy as:
        UCase2Dim(asStrings : VAR String[,], iCount VAL Int)

****************************************************************************/
VOID _CALLBACK UCase2Dim(char FAR * FAR * lppsz, short nCount)
{
    short       i, j, nLen;
    LPSTR       lp;

    for (i=0; i < nCount; i++)
    {   lp=lppsz[i];                              // get the i string
        nLen=strlen(lp);                          // get the string length
        for (j=0; j < nLen; j++)
            lp[j]=toupper(lp[j]);                 // convert to upper case
    }     
}           


/******************************************************************************

    FUNCTION: CommandInterface()

    PURPOSE:  demonstrates how to use an interface subroutine 
              
    COMMENTS: This function defined in ATEasy as an interface subroutine
              if this sub returns TRUE than ATEasy will add the text in lpIInfo.
        
******************************************************************************/
BOOL _CALLBACK CommandInterface(LPINTERFACEINFO lpIInfo)
{
    lpGIInfo=lpIInfo;             // save to global variable                  
    // The return value is TRUE - write command or false not to write a command
    return DialogBox(hGInstance, MAKEINTRESOURCE(IDD_COMMAND_INTERFACE), GetActiveWindow(), CommandInterfaceDlg);
}

/******************************************************************************

    FUNCTION: CommandInterfaceDlg()

    PURPOSE:  demonstrates how to use an interface subroutine 
              
    COMMENTS: This function is the dialog procedure for CommandInterface
        
******************************************************************************/
BOOL _CALLBACK CommandInterfaceDlg(HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam)
{
    switch (uMsg)
    {   case WM_COMMAND:
            switch (wparam)
            {   case IDOK:
                    GetDlgItemText(hdlg, ID_COMMAND, lpGIInfo->szCommand, sizeof lpGIInfo->szCommand);
                    EndDialog(hdlg, TRUE);      // return TRUE to CommandInterface
                    break;
                case IDCANCEL:
                    EndDialog(hdlg, FALSE);     // return TRUE to CommandInterface
                    break;
            }
            break;
        case WM_INITDIALOG:
        {   char    sz[32];
    
            SetDlgItemText(hdlg, ID_DRVNAME, lpGIInfo->szDRVName);
            SetDlgItemInt(hdlg, ID_DRVTYPE, lpGIInfo->nDRVType, TRUE);
            wsprintf(sz, "0x%lX", lpGIInfo->lDRVAddress);
            SetDlgItemText(hdlg, ID_DRVADDR, sz);
            SetDlgItemText(hdlg, ID_COMMAND, lpGIInfo->szCommand);
            return (TRUE);
        }    
    }
    return(FALSE);
}

/****************************************************************************
                    E - O - F
****************************************************************************/
