{****************************************************************************

    PROGRAM: CDLL.pas
    
    BY     : Ronnie Yazma, Copyright 1993 GEOTEST Inc.   

    PURPOSE: Demonstarte None ATEasy type DLL functions.
    
    TO COMPILE:
             Use Turbo pascal for window v1.5 or above.

    VERSION: 2.00 (Jul-26-93)

    FUNCTIONS/SUBROUTINES:

         - MaxSub() : finds the max between 2 floats
         - MaxLongFunc() : return the max between 2 floats
         - AverageArray() : find the avarage of float array
         - NoSpaces() : delete leading & trailing spaces in a string
         - UCase2Dim() : convert 2 dim string to upper case
         - CommandInterface() : command interface sub
         - CommandInterfaceDlg() : display a dialog box for the interface sub                

    COMMENTS:
           When using None ATEasy type DLL the parameters are passed from ATEasy
           in the following way:
           
           ATEasy                   DLL                     Remarks
           --------------------------------------------------------------------------
           VAL Byte                 shortint                byte and char also applicable
           VAR Byte                 var x:shortint or ^shortint
           VAL Int                  integer                 word also applicable
           VAR Int                  var x:integer or ^integer
           VAL Long                 longint
           VAR Long                 var x:longint or longint
           VAL Float                double                  $N+ must be inside
           VAR Float                var x:double or ^double
           VAL/VAR String[]         pchar or var x:array[1..32767] of char
                                                            null terminated string
                                                            when using pchar and the strings unit -
                                                            $X+ must be inside                                            
           VAL/VAR String[,]        var x:ppchar            array of pointers to strings
                                                            declare type ppchar = array[1..32767] of pchar
           VAL/VAR xxx [] or [,]    var x:array[range] of xxx
                                                            xxx is Byte/Int/Long/Float
                                                            range is normally 1..32767 but can be any other
                                                            2 dim range also applicable if known

****************************************************************************}

{$N+}                       { Must be on for ATEasy Types }
{$M 2048, 2048}
{$R CDLL.RES}               { resorce file for the CommandInterface sub } 
{$X+}                       { Must be on when using the strings unit }

library CDLL;
uses wintypes,              { Must be included for windows types }
     winprocs,              { for the dialog box }
     strings;               { Must be included when using strings from ateasy }


{$I ateasydl}               { Only when using Interface sub definition }

type
    doublearray = array [1..8091] of double; { for AverageArray }
    ppchar = array [1..16383] of pchar;      { for UCase2Dim }

const
   idd_CommandInterface  = 1000;             { for the interface sub dialog }
   id_DrvName            = 200; 
   id_DrvType            = 201;
   id_DrvAddr            = 202;
   id_Command            = 203;

var
   lpGIInfo : LPINTERFACEINFO;               { global variable for the interface sub dialog }
      
{****************************************************************************

    FUNCTION: MaxSub(dX1, dX2, dResult)

    PURPOSE:  Finds the max of 2 floats (dX1 & dX2) into lpdResult.

       This subroutine defined in ATEasy as:
       Max(fX1: VAL FLOAT, fX2: VAL FLOAT, fResult: VAR FLOAT): SUB DLL

****************************************************************************}
procedure MaxSub(dX1, dX2 : double; var dResult : double); export;
begin
    if dX1 < dX2 then
        dResult:=dX2
    else
        dResult:=dX1;
end;

{****************************************************************************

    FUNCTION: MaxLongFunc(lX1, lX2)

    PURPOSE:  Returns the max of 2 longs (lX1 & lX2).
              Note that this is a function. 

       This function defined in ATEasy as:
       Long Max(lX1: VAL LONG, lX2: VAL LONG): Function DLL

****************************************************************************}
function MaxLongFunc(lX1, lX2 : longint):longint; export; 
begin   
    if lX1 < lX2 then
        MaxLongFunc:=lX2
    else
        MaxLongFunc:=lX1;
end;

{****************************************************************************

    FUNCTION: AverageArray(adNumbers, iCount, dResult)

    PURPOSE:  Calculate the mean value of adNumbers array into dResult.

        This function defined in ATEasy as:
        AverageArray(afNumbers : VAL FLOAT[], dResult : VAR FLOAT) : SUB DLL

****************************************************************************}
procedure AverageArray(var adNumbers : doublearray; iCount : integer; var dResult : double); export;
var
    i : integer;
begin
    dResult:=0.0;
    for i:=1 to iCount do
	dResult:=dResult+adNumbers[i];
    if iCount <> 0 then
	dResult:=dResult / iCount;
end;

{****************************************************************************

    FUNCTION: NoSpaces(pcString)

    PURPOSE:  Delete leading & trailing spaces in a string

        This function defined in ATEasy as:
        NoSpaces(s : VAR String)

****************************************************************************}
procedure NoSpaces(pcString : pchar); export;
var
    i, j : integer;
begin
    i:=StrLen(pcString);
    while (i > 0) and (pcString[i-1] = ' ') do
	dec(i);
    pcString[i]:=#0;               { delete trailing spaces }
    j:=0;
    while (j <= i) and (pcString[j] = ' ') do
    	inc(j);
    if (j > 0) then                { move to start }
	move(pcString[j], pcString[0], i+1-j);
end;

{****************************************************************************

    FUNCTION: UCase2Dim(ppcStrings)

    PURPOSE:  convert 2 dim string to upper case

        This function defined in ATEasy as:
        UCase2Dim(as : VAR String[,])

    COMMENT : You can use the strings unit and the PChar type
              when dealling with strings in a much more elegant way.    

****************************************************************************}
procedure UCase2Dim(var ppcStrings : ppchar; iCount : integer); export;
var
    i : integer;
begin
    for i:=1 to iCount do
        StrUpper(ppcStrings[i]);
end;

{******************************************************************************

    FUNCTION: CommandInterfaceDlg()

    PURPOSE:  demonstrates how to use an interface subroutine 
              
    COMMENTS: This function is the dialog procedure for CommandInterface
        
******************************************************************************}
function CommandInterfaceDlg(hdlg: hwnd; uMsg, wparam: word;  lparam: longint): bool; export;
var
   sz : array [0..31] of char;
begin
  CommandInterfaceDlg:=True;
  case uMsg of
    wm_InitDialog:
    begin
      SetDlgItemText(hdlg, id_DrvName, @lpGIInfo^.szDRVName);
      SetDlgItemInt(hdlg, id_DrvType, lpGIInfo^.nDRVType, TRUE);
      wvsprintf(sz, '0x%lX', lpGIInfo^.lDRVAddress);
      SetDlgItemText(hdlg, ID_DrvAddr, @sz);
      SetDlgItemText(hdlg, ID_Command, @lpGIInfo^.szCommand);
      Exit;
    end;
    wm_Command:
      case wparam of
        id_Ok:
        begin
          GetDlgItemText(hdlg, id_Command, @lpGIInfo^.szCommand, SizeOf(lpGIInfo^.szCommand));
          EndDialog(hdlg, 1);
          Exit;
        end;      
        id_Cancel:
        begin
          EndDialog(hdlg, 0);
          Exit;
        end;
      end;
  end;
  CommandInterfaceDlg:=False;
end;

{******************************************************************************

    FUNCTION: CommandInterface()

    PURPOSE:  demonstrates how to use an interface subroutine 
              
    COMMENTS: This function defined in ATEasy as an interface subroutine
              if this sub returns TRUE than ATEasy will add the text in lpIInfo.
        
******************************************************************************}
function CommandInterface(lpIInfo : LPINTERFACEINFO) : integer; export;
begin
    lpGIInfo:=lpIInfo;             { save to global variable }                  
    { The return value is TRUE - write command or false not to write a command }
    CommandInterface:=DialogBox(hInstance, MakeIntResource(idd_CommandInterface), GetActiveWindow, @CommandInterfaceDlg);
end;

{****************************************************************************
			Exports definition for the DLL
****************************************************************************}

exports  MaxSub        	      index 100;
exports  MaxLongFunc   	      index 101;
exports  AverageArray  	      index 102;
exports  NoSpaces   	      index 103;
exports  UCase2Dim   	      index 104;
exports  CommandInterface     index 105;
exports  CommandInterfaceDlg  index 106;

begin
    { Note:You can place here initialization code for your dll }
end.

{****************************************************************************
		    E - O - F
****************************************************************************}
