/****************************************************************************

    PROGRAM    : FL8840A.DLL

    MODULE     : ateasy.c

    PROGRAMMER : Ronnie Yazma, Copyright 1991-1993 GEOTEST Inc.   

    PURPOSE    : Provoides a front pannel to a F8840A MdwTimeter via ATEasy's
                 interface subroutine.

    FUNCTIONS  : Panel() - F8840Panel - ateasy interface function

    COMMENTS   : This file demonstrate how to use of ATEasy's device drivers 
                 for gpib (GPIBxxx.DLL).
                 The DLL exports one Interface subroutine to ATEasy Panel()
                 
    COMPILE    :                 
                 The file compiled in small memory model.
                 Use the FL8840A.MAK to build for MS-C/Visual C/C++
                 Use the FL8840A.PRJ to build for Borland C/C++

****************************************************************************/

/***************************************************************************/

#define  WM_PAINTICON 0x26    // for windows 3.0 compat.

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ateasydl.h"         // ATEasy DLLs types
#include "gpibdrv.h"          // GPIBDRV.DLL functions prototypes
#include "fl8840a.h"

/***************************************************************************/

HINSTANCE           hinstG;                             // Instance handle
LPINTERFACEINFO     lpiinfoG;                           // Interface Info pointer
HFONT               hfontG;                             // Font handle for display measure
HICON               hiconG;                             // Icon handle when the panel is icon
CHAR                lpGEos[5]={2, 0, '\r', '\n', 0};    // terminator
CHAR                szGBuf[MAX_BUF];                    // global buffer
INT                 nGCurrDrv;                          // current active panel
DRV                 adrvG[MAX_DRV];                     // each driver has a panel

/****************************************************************************

    FUNCTION :  LibMain
                    
    PURPOSE   : Called by Windows upon loading of the DLL.
                The function loads the panel Icon and creates a font
                
****************************************************************************/
INT CALLBACK LibMain(HINSTANCE hinst, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
    hinstG=hinst;
    if (!(hfontG=CreateFont(26, 0, 0, 0, 700, 0, 0, 0, ANSI_CHARSET, 0, 0, 0, 0, "Helv"))) return(0);
    if (!(hiconG=LoadIcon(hinst, MAKEINTRESOURCE(IDI_DRV)))) return(0);
    return(1);
}

/****************************************************************************

    FUNCTION :  WEP
                    
    PURPOSE   : Called by Windows upon termination of the DLL.
                The function destroys all windows and delete the mesure font.
                
****************************************************************************/
INT _CALLBACK WEP(INT nExitType)
{        
    SHORT   nDrv;      
    
    for (nDrv=0; nDrv < MAX_DRV; nDrv++) 
    {   nGCurrDrv=nDrv;
        if (DrvDlg) DestroyWindow(DrvDlg);
    }    
    if (hfontG) DeleteObject(hfontG);
    return(1);
}

/******************************************************************************

    FUNCTION :  Panel
                    
    PURPOSE   : This function provides fron panel for the f8840a DMM instrument.
                Up to MAX_DRV panels can be open at the same time.
                Each can have diffrent address and name.
                The adrv[i] hold the status of the i Panel.
    
******************************************************************************/
BOOL _CALLBACK Panel(LPINTERFACEINFO lpiinfo)
{
    for (nGCurrDrv=0; nGCurrDrv < MAX_DRV; nGCurrDrv++)
        if (!DrvDlg) break;
    if (nGCurrDrv == MAX_DRV) return(0);            // No free panel avaiable
    lpiinfoG=lpiinfo;                               // Save it for WM_INITDIALOG
    CreateDialog(hinstG, MAKEINTRESOURCE(IDD_PANEL), GetParent(GetActiveWindow()), PanelDlg);
    return(0);
}

/******************************************************************************

    FUNCTION :  PanelDlg

    PURPOSE  :  Dialog procedure for the instrument panel.
    
******************************************************************************/
BOOL _CALLBACK PanelDlg(HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam)
{
    SHORT    i;
    HMENU    hmenu;

    switch (uMsg)
    {   case WM_COMMAND:
            for (nGCurrDrv=0; DrvDlg != hdlg && nGCurrDrv < MAX_DRV; nGCurrDrv++);
            if (nGCurrDrv == MAX_DRV) break;            
            if (InCloseRange(wparam, IDB_VDC, IDB_RESET))
            {   Send(wparam-IDB_VDC+IDS_VDC);
                break;
            }
            switch (wparam)
            {   case IDB_OFFSET:
                    Send(IDS_OFFSET_OFF+((DrvOffset+1) % 2));
                    break;

                case IDB_RATE:
                    Send(IDS_RATE_S+((DrvRate+1) % 3));
                    break;
            }
            break;

        case WM_SYSCOMMAND:
            if (wparam == IDM_ABOUT)
                DialogBox(hinstG, MAKEINTRESOURCE(IDD_ABOUT), hdlg, AboutDlg);
            break;

        case WM_CLOSE:
            DestroyWindow(hdlg);
            return(TRUE);

        case WM_DESTROY:
            for (nGCurrDrv=0; DrvDlg != hdlg && nGCurrDrv < MAX_DRV; nGCurrDrv++);
            if (nGCurrDrv == MAX_DRV) break;
            if (DrvTimerID) KillTimer(hdlg, DrvTimerID);
            DrvDlg=NULL;
            break;

        case WM_INITDIALOG:
            DrvDlg=hdlg;                         // save the information into adrv[]
            DrvAddress=lpiinfoG->lDRVAddress;
            DrvRate=DrvInput=DrvRange=DrvFunc=0;
            DrvOffset=DrvOver=1;
            SendDlgItemMessage(hdlg, IDT_RESULT, WM_SETFONT, hfontG, 1L);
            GetWindowText(hdlg, szGBuf, MAX_BUF);
            strcat(szGBuf, " - ");
            lstrcat(szGBuf, lpiinfoG->szDRVName);
            SetWindowText(hdlg, szGBuf);         
            
            // create a timer 
            DrvTimerID=SetTimer(hdlg, IDOK, TIMER_TMO, TimerProc);
            hmenu=GetSystemMenu(hdlg, FALSE);
            AppendMenu(hmenu, MF_SEPARATOR, 0, NULL);
            AppendMenu(hmenu, MF_STRING, IDM_ABOUT, GetString(IDS_ABOUT));
            return (TRUE);
        
        case WM_CTLCOLOR:
            SetBkMode(wparam, TRANSPARENT);
            return(GetStockObject(LTGRAY_BRUSH));
                        
        case WM_PAINTICON:                  // Icon paintings messages
            wparam=1; lparam=0x10000;
        case WM_ACTIVATE:
            i=(SHORT) GetVersion();
            if (LOBYTE(i) <=  0x3 && HIBYTE(i) < 10)
                if (wparam && HIWORD(lparam))
                    SetClassWord(hdlg, GCW_HICON, hiconG);
                else
                    SetClassWord(hdlg, GCW_HICON, NULL);
            break;
            
        case WM_ERASEBKGND:
            return(IsIconic(hdlg));
            
        case WM_PAINT:
        {
            PAINTSTRUCT     ps;

            BeginPaint(hdlg, &ps);
            if (IsIconic(hdlg))
            {   DefWindowProc(hdlg, WM_ICONERASEBKGND, ps.hdc, 0L);
                DrawIcon(ps.hdc, 0, 0, hiconG);
            }
	    EndPaint(hdlg, &ps);
            return(TRUE);
        }
        case WM_QUERYDRAGICON:   // doesn't work in 3.0 when you drag you dont see the icon 
            return(hiconG);
                  
    }
    return (FALSE);
}

/******************************************************************************

    FUNCTION :  TimerProc
    
    PURPOSE  :  This function is Timer Procedure that is called by windows every
                TIMER_TMO.
                The function reads current instrument setup and displays it
                in the dialog.
                
******************************************************************************/
INT _CALLBACK TimerProc(HWND hdlg, UINT uMsg, UINT uIDTimer, DWORD dwTime)
{
    SHORT           i, nTOffset, nAuto;
    DOUBLE          d;
       
    if (IsIconic(hdlg)) return(0);
    for (nGCurrDrv=0; DrvDlg != hdlg && nGCurrDrv < MAX_DRV; nGCurrDrv++);
    if (nGCurrDrv == MAX_DRV) return(0);
    
    if (Send(IDS_GET_IAB))
    {   SetDlgItemText(hdlg, IDT_RESULT, "");
        return(0);
    }
    if (Receive()) return(0);
    if (DrvInput != (i=szGBuf[3]-'0'))
        SetDlgItemText(hdlg, IDT_INPUT, GetString(IDS_INPUT_FRONT+(DrvInput=i)));
    nAuto=szGBuf[4] == '0';
    nTOffset=szGBuf[5]-'0';

    if (Send(IDS_GET_FRST)) return(0);
    if (Receive()) return(0);
    if (DrvFunc != (i=szGBuf[2]-'1'))
        SetDlgItemText(hdlg, IDT_FUNC, GetString(IDS_FUNC_VDC+(DrvFunc=i)));
    if (nAuto) szGBuf[3]='0';
    if (DrvRange != (i=szGBuf[3]-'0'))
        SetDlgItemText(hdlg, IDT_RANGE, GetString(IDS_RANGE_AUTO+(DrvRange=i)));
    if (DrvRate != (i=szGBuf[4]-'0'))
        SetDlgItemText(hdlg, IDT_RATE, GetString(IDS_RATE_SLOW+(DrvRate=i)));

    if (Receive()) return(0);
    SetDlgItemText(hdlg, IDT_RESULT, szGBuf+2);
    d=atof(szGBuf+2);

    if (DrvOver != (i=!InCloseRange(d, -9e+9, +9e+9)))
    {	DrvOver=i;
	ShowWindow(GetDlgItem(hdlg, IDT_OVER), DrvOver ? SW_SHOW : SW_HIDE);
    }
    if (DrvOffset != nTOffset)
    {	DrvOffset=nTOffset;
	ShowWindow(GetDlgItem(hdlg, IDT_OFFSET), DrvOffset ? SW_SHOW : SW_HIDE);
    }
    return(0);
}

/******************************************************************************

    FUNCTION :  Send
    
    PURPOSE  :  Sends a stringtable string to the current instrument
    
******************************************************************************/
BOOL Send(UINT uIDS)
{
    SHORT    i;
    
    strcpy(szGBuf+2, GetString(uIDS));
    SHORTVAR(szGBuf)=strlen(szGBuf+2);
    return(!_GPIBSend(DrvAddress, lpGEos, EOI, DRV_TMO, szGBuf, &i));
}

/******************************************************************************

    FUNCTION :  Receive
    
    PURPOSE  :  Receives a string from the current instrument into szGBuf
    
******************************************************************************/
BOOL Receive(VOID)
{
    return(!_GPIBReceive(DrvAddress, lpGEos, EOI, DRV_TMO, 0, szGBuf, MAX_BUF));
}

/******************************************************************************

    FUNCTION :  GetString
    
    PURPOSE  :  Loads a string from the resource stringtable and returns a pointer
                to a static varaiable.
                    
******************************************************************************/
PSTR GetString(UINT uIDS)
{
   static CHAR szStr[MAX_BUF];

   szStr[0]=0;
   LoadString(hinstG, uIDS, szStr, sizeof szStr);
   return(szStr);
}

/******************************************************************************

    FUNCTION :  AboutDlg
    
    PURPOSE  :  Dialog procedure for the About menu item.
                
******************************************************************************/
BOOL _CALLBACK AboutDlg(HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam)
{
    switch (uMsg)
    {   case WM_COMMAND:
            EndDialog(hdlg, TRUE);
            break;

        case WM_INITDIALOG:
            return(TRUE);
    }
    return (FALSE);
}

/****************************************************************************
                    E - O - F
****************************************************************************/
