/****************************************************************************

    FILE : CDLL.h
    
    PURPOSE : ID's and prototypes for the F8840A example
                    
****************************************************************************/

#define IDI_DRV                     1000

#define IDD_PANEL                   1001
#define IDD_ABOUT                   1002

/******************************************************************************
                    Resource ID's
******************************************************************************/
#define IDB_VDC                     110
#define IDB_VAC                     111
#define IDB_KOHM2W                  112
#define IDB_KOHM4W                  113
#define IDB_MADC                    114
#define IDB_MAAC                    115
#define IDB_AUTO                    116
#define IDB_02                      117
#define IDB_2                       118
#define IDB_20                      119
#define IDB_200                     120
#define IDB_2000                    121
#define IDB_20M                     122
#define IDB_TRIG                    123
#define IDB_RESET                   124

#define IDB_RATE                    130
#define IDB_OFFSET                  131

#define IDT_FUNC                    140
#define IDT_OFFSET                  141
#define IDT_RANGE                   142
#define IDT_OVER                    143
#define IDT_RATE                    144
#define IDT_INPUT                   145

#define IDT_RESULT                  160

#define IDM_ABOUT                   200

/******************************************************************************
                    IDS's - string ID's
******************************************************************************/

#define IDS_VDC                     210
#define IDS_VAC                     211
#define IDS_KOHM2W                  212
#define IDS_KOHM4W                  213
#define IDS_MADC                    214
#define IDS_MAAC                    215
#define IDS_AUTO                    216
#define IDS_02                      217
#define IDS_2                       218
#define IDS_20                      219
#define IDS_200                     220
#define IDS_2000                    221
#define IDS_20M                     222
#define IDS_TRIG                    223
#define IDS_RESET                   224

#define IDS_RATE_S                  230
#define IDS_RATE_M                  231
#define IDS_RATE_F                  232

#define IDS_OFFSET_OFF              240
#define IDS_OFFSET_ON               241

#define IDS_GET_FRST                250
#define IDS_GET_IAB                 251
#define IDS_GET_ERROR               252
#define IDS_CLEAR_ERROR             253

#define IDS_FUNC_VDC                260
#define IDS_FUNC_VAC                261
#define IDS_FUNC_KOHM2W             262
#define IDS_FUNC_KOHM4W             263
#define IDS_FUNC_ADC                264
#define IDS_FUNC_AAC                265

#define IDS_RANGE_AUTO              270
#define IDS_RANGE_02                271
#define IDS_RANGE_2                 272
#define IDS_RANGE_20                273
#define IDS_RANGE_200               274
#define IDS_RANGE_2000              275
#define IDS_RANGE_20M               276

#define IDS_RATE_SLOW               280
#define IDS_RATE_MEDIUM             281
#define IDS_RATE_FAST               282

#define IDS_INPUT_FRONT             290
#define IDS_INPUT_REAR              291

#define IDS_ABOUT                   300

/******************************************************************************
                    Types
******************************************************************************/

#define InCloseRange(x,min,max)     (((x)>=(min)) && ((x)<=(max)))

#define MAX_DRV     5
#define MAX_BUF     128
#define DRV_TMO     1000
#define TIMER_TMO   1000
#define EOI         1

typedef struct
{   HWND                hdlg;
    DWORD               dwAddress;
    SHORT               nTimerID, nFunc, nRange, nRate, nOffset, nInput, nOver;
} DRV;

#define DrvDlg          (adrvG[nGCurrDrv].hdlg)
#define DrvAddress      (adrvG[nGCurrDrv].dwAddress)
#define DrvTimerID      (adrvG[nGCurrDrv].nTimerID)
#define DrvFunc         (adrvG[nGCurrDrv].nFunc)
#define DrvRange        (adrvG[nGCurrDrv].nRange)
#define DrvRate         (adrvG[nGCurrDrv].nRate)
#define DrvOffset       (adrvG[nGCurrDrv].nOffset)
#define DrvInput        (adrvG[nGCurrDrv].nInput)
#define DrvOver         (adrvG[nGCurrDrv].nOver)

/******************************************************************************
                    Functions prototypes
******************************************************************************/

BOOL _CALLBACK Panel    (LPINTERFACEINFO lpIInfo);     

BOOL _CALLBACK PanelDlg (HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam);
INT  _CALLBACK TimerProc(HWND hdlg, UINT uMsg, UINT uIDTimer, DWORD dwTime);
BOOL           Send     (UINT uIDS);                              
BOOL           Receive  (VOID);
PSTR           GetString(UINT uIDS);
BOOL _CALLBACK AboutDlg (HWND hdlg, UINT uMsg, WPARAM wparam, LPARAM lparam);

/******************************************************************************
                   E - O - F
******************************************************************************/
