/******************************************************************************

    PROGRAM    : GPIBxxxx.DLL

    FILE       : GPIBDRV.h

    PURPOSE    : Provides functions prototypes and typedef declaration for
                 GPIBxxxx.C files

    PROGRAMMER : Ronnie Yazma, Copyright 1991-1993 GEOTEST Inc.

    VERSION    : 2.0

******************************************************************************/


/******************************************************************************
                    general typedef & macro's
******************************************************************************/

#ifndef ATEASY

#ifndef _CALLBACK
#define _CALLBACK  __export _far _pascal
#endif
#define _FUNCTION  _far _pascal

typedef char                      CHAR;
typedef short                     SHORT;
typedef int                       INT;
typedef float                     FLOAT;
typedef double                    DOUBLE;

typedef SHORT FAR *               LPSHORT;
typedef BOOL FAR *                LPBOOL;
typedef INT FAR *                 LPINT;
typedef WORD FAR *                LPWORD;
typedef LONG FAR *                LPLONG;
typedef DWORD FAR *               LPDWORD;
typedef FLOAT FAR *               LPFLOAT;
typedef DOUBLE FAR*               LPDOUBLE;

#define CHARVAR(lp)               (*(LPCHAR)(lp))
#define BYTEVAR(lp)               (*(LPBYTE)(lp))
#define SHORTVAR(lp)              (*(LPSHORT)(lp))
#define INTVAR(lp)                (*(LPINT)(lp))
#define WORDVAR(lp)               (*(LPWORD)(lp))
#define LONGVAR(lp)               (*(LPLONG)(lp))
#define DWORDVAR(lp)              (*(LPDWORD)(lp))
#define FLOATVAR(lp)              (*(LPFLOAT)(lp))
#define DOUBLEVAR(lp)             (*(LPDOUBLE)(lp))

#define InCloseRange(x,min,max)   (((x)>=(min)) && ((x)<=(max)))

/******************************************************************************
                    internal gpibXXX types & macros
******************************************************************************/

#define  ADDR_BRD 1                 // return by GPIBCheckBrdDev */
#define  ADDR_DEV -1
#define  ADDR_ERR 0

typedef struct tagBRD
{   SHORT    nHandle;               // HP or NI handle
    SHORT    nSelectCode;           // HP select code
    SHORT    nPort;
    SHORT    nIrq;
    BOOL     bIntEnable;
    DWORD    ulIntEvents;
    HWND     hwndInt;
    WORD     nIntOldSeg;
    WORD     nIntOldOff;
    WORD     nIntOldMask;
} BRD;

#endif

/******************************************************************************
                    external functions prototype
******************************************************************************/

// nBrdDev:HIWORD = brd # (1 | 2), HIBYTE(LOWORD) = pad 1..31, LOBYTE(LOWORD) = sad 0..31 (0=none)

BOOL _CALLBACK _GPIBGetDrvName        (LPSTR szName);

BOOL _CALLBACK _GPIBInitBrd           (DWORD ulBrd);
BOOL _CALLBACK _GPIBInitDev           (DWORD ulDev);

BOOL _CALLBACK _GPIBClear             (DWORD ulBrdDev);
BOOL _CALLBACK _GPIBCommands          (DWORD ulBrd, LPSTR lpStr, LPSHORT lpnSent);
BOOL _CALLBACK _GPIBIFC               (DWORD ulBrd);
BOOL _CALLBACK _GPIBLLockOut          (DWORD ulBrd);
BOOL _CALLBACK _GPIBLocal             (DWORD ulBrdDev);
BOOL _CALLBACK _GPIBPPoll             (DWORD ulBrd, LPSHORT lpnPPL);
BOOL _CALLBACK _GPIBPPollC            (DWORD ulDev, SHORT nData, SHORT nSense); //nData 1-8, nSense 0-1
BOOL _CALLBACK _GPIBPPollU            (DWORD ulBrdDev);
BOOL _CALLBACK _GPIBReceive           (DWORD ulDev, LPSTR lpEOS, SHORT nEOI, SHORT nTimeoutmSec, SHORT nMode, LPSTR lpStr, SHORT nMaxLen); // nMode:0-immediate, 1-srq, 2-srq|immediate
BOOL _CALLBACK _GPIBRemote            (DWORD ulBrdDev);
BOOL _CALLBACK _GPIBSend              (DWORD ulDev, LPSTR lpEOS, SHORT nEOI, SHORT nTimeoutmSec, LPSTR lpStr, LPSHORT lpnSent);
BOOL _CALLBACK _GPIBSpl               (DWORD ulDev, LPSHORT lpnSpl);
BOOL _CALLBACK _GPIBStatus            (DWORD ulBrd, LPSHORT lpnStatus);
BOOL _CALLBACK _GPIBTrig              (DWORD ulBrdDev);

// version 1.2 - interrupt extentions

#define GPIB_EVENT_SRQ  1l
#define GPIB_EVENT_ERR  2l

SHORT _CALLBACK _GPIBEnableInterrupt   (DWORD ulBrd, DWORD dwEvents, HWND hWnd);
BOOL  _CALLBACK _GPIBDisableInterrupt  (DWORD ulBrd);
BOOL  _CALLBACK _GPIBSimulateInterrupt (DWORD ulBrd);

/******************************************************************************
                    E - O - F
******************************************************************************/
