/****************************************************************************

    PROGRAM    : MMTimer

    MODULE     : MMTIMER.C

    BY         : Ronnie Yazma, Copyright 1993 GEOTEST Inc.   
    
    TO COMPILE :
                 Use CDLL.MAK when using Visual C/C++ v1.0 or MS-C 7.0
                 Use CDLL.PRJ when using Borland C/C++ v3.1     
                 This file compiled in large memory model.

    PURPOSE    : Demonstrates None ATEasy DLL type that uses MMSYSTEM.DLL timers.
                 This DLL provides up to 4 timers which are accurate up to 1ms.
                 The DLL contains a CALLBACK sub that is called at interrupt time.
                 You can use this DLL as a template if you need to do something in the background periodicly.
                 For more information see Multimedia reference manual/help that comes with MS-WIN SDK 3.1.
                 
    FUNCTIONS  : TimerCreate, TimerKill, TimerGetCounter

    COMMENTS   : Requires Windows 3.1 or above.

****************************************************************************/

/***************************************************************************/

#include <windows.h>
#include <mmsystem.h>                               // multimedia prototypes

/****************************************************************************
                    globals 
****************************************************************************/
#define     MAX_TIMERS  4                           // can be changed to any number

UINT        auGTimerID[MAX_TIMERS];                 // array of timers ID's
DWORD       adwGCounter[MAX_TIMERS];                // array of timers counters

/****************************************************************************
                    prototypes
****************************************************************************/
#define _CALLBACK   FAR PASCAL __export             // no need for exports entry in the DEF file

void _CALLBACK TimerCallback(UINT uTimerID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2);

/****************************************************************************
                    LibMain
****************************************************************************/
int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
    return(1);
}

/****************************************************************************
                    WEP
****************************************************************************/
int FAR PASCAL WEP(int iCmd)
{
    int     i;
    
    for (i=0; i<MAX_TIMERS; i++)                    // close all timers
        if (auGTimerID[i]) timeKillEvent(auGTimerID[i]);
    return 1;
}

/******************************************************************************
                    TimerCreate - create and start a timer
******************************************************************************/
void _CALLBACK TimerCreate(DWORD dwInterval, LPDWORD lpdwTimerID)           
{        
    int     i;

    *lpdwTimerID=0;             
    for (i=0; i<MAX_TIMERS; i++)                    // search for avaialble timer
        if (!auGTimerID[i]) break;
    if (i==MAX_TIMERS) return;
    adwGCounter[i]=0;                               // resets the timer counter
    *lpdwTimerID=auGTimerID[i]=timeSetEvent((UINT) dwInterval, (UINT) dwInterval, TimerCallback, i, TIME_PERIODIC);
}
    
/******************************************************************************
                    TimerCallback - called by Windows at interrupt time   
                                    this handler must be in a fixed segment
******************************************************************************/
void _CALLBACK TimerCallback(UINT uTimerID, UINT wMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{                                                      
    // Place your code here - see multimedia reference for what you're allowed to call here 

    adwGCounter[dwUser]++;                          // increment the counter
}
    
/******************************************************************************
                    TimerKill - stop and kill the timer
******************************************************************************/
void _CALLBACK TimerKill(DWORD dwTimerID, LPDWORD lpdwStatus)           
{   
    int     i;

    *lpdwStatus=0;    
    for (i=0; i<MAX_TIMERS; i++)                    // search for the ID
        if (auGTimerID[i]==(UINT) dwTimerID) break;
    if (i==MAX_TIMERS) return; 
    auGTimerID[i]=0;    
    *lpdwStatus=timeKillEvent((UINT) dwTimerID);             // kill the timer
}

/******************************************************************************
                    TimerGetCounter - get current timer
******************************************************************************/
void _CALLBACK TimerGetCounter(DWORD dwTimerID, LPDWORD lpdwCounter)           
{
    int     i;

    *lpdwCounter=0;    
    for (i=0; i<MAX_TIMERS; i++)                     // search for the ID
        if (auGTimerID[i]==(UINT) dwTimerID) break;
    if (i==MAX_TIMERS) return; 
    *lpdwCounter=adwGCounter[i];                     // return the counter
}

/******************************************************************************
                    E - O - F
******************************************************************************/
