         TITLE    'NetCOS2.ASM: 
                   COMMAND.COM im Netzfenster in OS/2 laden'
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS:CodeSeg,ES:CodeSeg
         ORG      100h
Begin:   JMP      Start
EnvSeg   DW       0    ; Segmentadresse des Master-Environments
EnvOfs   DW       0    ; Offset aktueller Position im Environment, ab hier
                       ; kann etwas im Environment gespeichert werden
CommStr  DB       "COMSPEC="
CommPath DB       64 DUP (0)
StackOfs DW       0
StackSeg DW       0           ; zum Sichern des Stacks
ParBlock DW       0           ; Environment vom Parent-Proze bernehmen
         DW       80h         ; Befehlszeile im PSP, Offset
         DW       0           ;   Segmentadresse
         DW       4 DUP (-1)  ; Zeiger auf Standard-FCBs (hier unntig)
Start:   CALL     SuchEnv     ; Segmentadresse des Master-Environment in ES
         LEA      DX,CommStr
         CALL     SuchCommStr ; "COMSPEC=" suchen; ES:DI zeigt auf Pfad
         CALL     ZKKopieren  ; Pfad nach CommPath kopieren
         LEA      BX,Ende     ; Offset Programmende
         MOV      CL,4
         SHR      BX,CL       ; durch 16 dividieren, wird Segmentdifferenz
         INC      BX          ; zur Sicherheit +1
         PUSH     CS
         POP      ES
         MOV      AH,4Ah      ; Funktion Speicherblock ndern
         INT      21h         ; ausfhren
         MOV      CS:StackOfs,SP
         MOV      CS:StackSeg,SS ; Stack gesichert
         MOV      AX,4B00h    ; Funktion EXEC, Laden und Ausfhren
         LEA      DX,CommPath ; Lademodulname COMMAND.COM samt Pfad
         PUSH     CS
         POP      ES
         LEA      BX,ParBlock ; Parameterblock adressiert ber ES:BX
         PUSH     CS
         POP      ParBlock+4  ; CS des Parent-Prozesses in ParBlock eintragen
         INT      21h
         MOV      SP,CS:StackOfs
         MOV      SS,CS:StackSeg
         MOV      AH,4Ch
         INT      21h
;
SuchEnv: MOV      AH,52h   ; nicht dokumentierte DOS-Funktion (internal use)
         INT      21h      ; ES:BX weist auf DOS Information Block
         MOV      AX,ES
         DEC      AX
         MOV      ES,AX    ; Segmentadresse um 1 verringert
         ADD      BX,16    ; BX dementsprechend um 16 erhht, damit Adress-
                           ; rechnung im nchsten Befehl sicher funktioniert
         MOV      AX,ES:[BX-2] ; Segmentadresse des ersten MCB
SuPSP:   MOV      ES,AX    ; Segmentadresse des MCB jetzt in ES
         MOV      BP,ES:[1] ; Segmentadresse des zugehrigen PSP
         MOV      DI,ES:[3] ; Speichergre
         MOV      ES,BP     ; Segmentadresse des zugehrigen PSP
         CMP      WORD PTR ES:[0],20CDh ; steht hier INT 20h ?
         JNE      SuWeiter ; nein: ist kein PSP
         MOV      BX,ES:[2Ch] ; ja
         CMP      BX,0     ; freier Block?
         JE       SuWeiter ; ja: weitersuchen
         MOV      ES,BX    ; nein: Environment-Segmentadresse gefunden
         MOV      EnvSeg,BX
         RET
SuWeiter:ADD      AX,DI    ; Speichergre (in Paragraphen) addieren
         INC      AX       ; Segmentadresse des nchsten MCB
         JMP      SuPSP
;
SuchCommStr:                 ; "COMSPEC=" suchen
         XOR      DI,DI      ; Beginn des Environments
         CLD                 ; Verarbeitung von links nach rechts
         MOV      CX,1000    ; Suchen ber 1000 Bytes ermglichen
         PUSH     CX
SCSuch:  POP      CX
         MOV      BX,DX      ; Adresse des Sucharguments "COMSPEC="
         MOV      AL,[BX]    ; erstes Zeichen suchen
         REPNE SCASB         ;
         CMP      CX,0       ; 1000 Bytes schon abgesucht ?
         JZ       Exit       ; erfolglose Suche
         PUSH     CX         ; erstes Zeichen gefunden
         MOV      CX,7       ; noch 7 weitere Zeichen prfen
SESCont: INC      BX         ; nchstes Zeichen
         MOV      AL,BYTE PTR [BX]
         CMP      BYTE PTR ES:[DI],AL  ; nchstes Zeichen aus EnvStrg ?
         JNE      SCSuch     ; nein: nach Anfang des EnvStrg weitersuchen
         INC      DI         ; nchstes Zeichen im EnvStrg
         LOOP     SESCont    ; ja: EnvStrg indentifizieren
         POP      CX         ; identifiziert: Stack wieder richtigstellen
         MOV      SI,DI
         RET                 ; jetzt zeigt ES:SI auf den Pfad des COMMAND.COM
;
ZKKopieren:
         LEA      DI,CommPath
ZKKopL:  MOV      AL,ES:[SI] ; ASCIIZ-String ab ES:[SI] nach DS:[DI] kopieren
         CMP      AL,0       ; Ende des Pfads ?
         JE       ZKRet      ; ja: beenden
         MOV      DS:[DI],AL ; nein: abspeichern
         INC      SI
         INC      DI
         JMP      ZKKopL
ZKRet:   MOV      DS:[DI],AL ; 0 noch ans Ende setzen
         RET
;
Exit:    MOV      AH,4Ch
         INT      21h
;
Ende     EQU      $
CodeSeg  ENDS
         END      Begin

