           TITLE    "SerAsm.ASM: Terminalprogramm, COM1, Standardparameter"
CodeSeg    SEGMENT  PARA PUBLIC 'Code'
           ASSUME   CS:CodeSeg,SS:CodeSeg
           ASSUME   DS: CodeSeg,ES:CodeSeg
ESCP       EQU      1Bh
LF         EQU      0Ah
CR         EQU      0Dh
           ORG      100h
Begin:     JMP      Start
ESCEmpfMsg DB       LF,CR,"Programmlauf durch Empfang von ESC beendet.",'$'
EscEingMsg DB       LF,CR,"Programmlauf durch Eingabe von ESC beendet.",'$'
Start:     CALL     ClrScr      ; Bildschirm lschen
           CALL     SetModReg   ; Modem-Kontrollregister setzen
; Horchschleife: solange kein Tastendruck, Leseversuch vom COMx
HorchSchl: MOV      AH,1        ; nein: BIOS-Tastaturabfrage
           INT      16h         ; erfolgte Tastendruck ?
           JZ       HSHorch     ; nein: Horchen, ob Zeichen auf COMx
           CALL     TastLes     ; ja: eingegebenes Zeichen lesen und ausgeben
           CALL     Senden      ;     Zeichen ber COMx senden
           JMP      HorchSchl
HSHorch:   CALL     Horchen
           CMP      AL,0        ; Zeichen da ?
           JE       HorchSchl   ; nein
           CMP      AL,ESCP     ; ja: ESC empfangen ?
           JE       HSExit      ;     ja: Programm beenden
           CALL     ALAusgeb    ;     nein: ausgeben
           JMP      HorchSchl
HSExit:    LEA      DX,EscEmpfMsg
Exit:      MOV      AH,9        ; Zeichenkette ausgeben
           INT      21h
           MOV      AH,4Ch      ; Exit
           INT      21h
;
Horchen:   MOV      DX,3FDh     ; Leitungs-Statusregister
           IN       AL,DX       ; Status lesen
           TEST     AL,1        ; Bit 0 testen: Zeichen da ?
           JZ       HRetN       ; nein
           MOV      DX,3F8h     ; ja: Kanaladresse von COM1
           IN       AL,DX       ;     Zeichen lesen
           RET
HRetN:     MOV      AL,0        ; Kennung: kein Zeichen da
           RET
;
Senden:    MOV      DX,3F8h     ; Kanaladresse von COM1
           OUT      DX,AL       ; Zeichen schreiben
           RET
;
; TastLes: Zeichen von Tastatur lesen, 
; am Bildschirm ausgeben (auer wenn ESC)
;          Wenn CR, dann LF zustzlich ausgeben.
;          Letztes Zeichen in AL bergeben.
TastLes:   MOV      AH,0        ; BIOS-Tastatureingabe lesen
           INT      16h         ; eingegebenes Zeichen nach AL
           CMP      AL,ESCP     ; ESC gelesen ?
           JNE      TL1         ; nein
           CALL     Senden      ; ja
           LEA      DX,EscEingMsg
           JMP      Exit
TL1:       CALL     ALAusgeb    ; nein: 
                                ; Zeichen aus AL am Bildschirm ausgeben
           CMP      AL,CR       ; war das Zeichen Carriage Return ?
           JNE      TLRet       ; nein: Zeichen bergeben
           CALL     Senden
           MOV      AL,LF       ; ja: zustzlich LF ausgeben
           CALL     ALAusgeb
TLRet:     RET
;
ALAusgeb:  MOV      AH,2        ; Zeichen auf Bildschirm ausgeben
           MOV      DL,AL       ; auszugebendes Zeichen
           INT      21h
           RET
;
SetModReg: MOV      DX,3FCh     ; Modem-Kontrollregister
           MOV      AL,3        ; DTR und RTS setzen
           OUT      DX,AL
           RET
;
ClrScr:    MOV      AH,0        ; Bildschirm-Modus einstellen
           MOV      AL,3        ; 25x80 Textmodus
           INT      10h         ; BIOS-Video-IO
           RET
;
CodeSeg    ENDS
           END      Begin


