/* SerTerm1.C: Terminal-Programm mittels COM1 */
#include <stdlib.h>
#include <bios.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>

#define ESC 0x1B

char TastLes(void);
void Senden(char Zeichen);
unsigned int Horchen(void);
                                          
enum {COM1, COM2};                        
                                          
void InitCom (int ComPort, /* +------------------------------+ */
              int Baud,    /*  Der Initialisierungsparameter */
              int DataBits,/*  ist ein Byte-Wert, der zur    */
              int StopBits,/*  leichteren Handhabung aus     */
              char Parity) /*  "sprechenden" Parametern      */
{ char Paritaet;           /*  zusammengesetzt wird.         */
  switch (Parity)          /*                                */
  { case 'N': Paritaet=0;  /*  Bits Bedeutung                */
              break;       /*  7-5  Baudrate (100 = 1200)    */
    case 'O': Paritaet=1;  /*  4,3  Paritt  (0 = keine)     */
              break;       /*    2  Stopbits (1 = zwei)      */
    case 'E': Paritaet=3;  /*  1,0  Zeichenlnge (11 = 8)    */
  }                        /* +------------------------------+ */
  bioscom(0,                          /* Initialisieren */
          (1+(int) ceil(log(Baud/150)/log(2))) << 5
           | Paritaet << 3
           | (StopBits-1) << 2
           | DataBits-5,              /* Initialisierungsparameter */
          ComPort);                   /* Auswahl COM1 oder COM2    */
}

char TastLes(void)
{ char Zeichen;
  Zeichen=getch();
  if (Zeichen != ESC)
     putch(Zeichen);
  if (Zeichen == 0x0D)
     putch(0x0A);
  return Zeichen;
}

void Senden(char Zeichen)
{ bioscom (1,     /* auf Schnittstelle schreiben */
           Zeichen,
           COM1);  /* Auswahl COM1 oder COM2    */
}

unsigned int Horchen(void)
{ int RueckWert;
  char Zeichen;
  RueckWert=bioscom (3,0,COM1);
  if (RueckWert & 0x0100)          /* Zeichen zum Lesen da ?  */
     { RueckWert = bioscom (2,     /* Ja: von Schnittstelle lesen  */
                            0,     /* Inhalt beliebig           */
                            COM1); /* Auswahl COM1 oder COM2    */
       if ((RueckWert & ESC) == ESC)  /* wurde ESC empfangen ? */
       { puts("\nProgrammlauf durch Empfang von ESC beendet.\n");
         getch();
         exit(0);
       }
       if ((RueckWert & 0x8000) == 0) /* kein Time-out ? */
          return RueckWert;
     }
  else
     return 0;
}

main()
{ unsigned int RueckWert;
  char Zeichen;
  InitCom(COM1,1200,8,2,'N');
  clrscr();
  puts("");
  do
  { while (!kbhit())
    { RueckWert=Horchen();  /* Leseversuch auf Schnittstelle */
      if (RueckWert != 0)   /* Zeichen da?                   */
      { if ((RueckWert & 0x00FF) == 0x000D)  /* Ja: CR ?     */
           putchar(0x0A);   /* Ja: LF ausgeben               */
        if ((RueckWert != ESC) && (RueckWert != 0x8000))
           putchar (RueckWert);
      }
     }
     Zeichen=TastLes();
     Senden(Zeichen);
  }
  while ((RueckWert != ESC) && (Zeichen != ESC));
  puts("\nProgrammlauf durch Eingabe von ESC beendet.\n");
  getch();
}

