/* SerTest1.C: Terminal-Programm, feste Parameter, ohne bioscom */
#include <stdlib.h>
#include <bios.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>

#define ESC 0x1B

union REGS Register;
int ComPort=0, Baud=1200, DataBits=8, StopBits=2, Parity='N';

char TastLes(void);
void Senden(char Zeichen);
unsigned int Horchen(void);
                                          
void InitCom (int ComPort,  /* +------------------------------+ */
              int Baud,     /*  Der Initialisierungsparameter */
              int DataBits, /*  ist ein Byte-Wert, der zur    */
              int StopBits, /*  leichteren Handhabung aus     */
              char Parity)  /*  "sprechenden" Parametern      */
{ char Paritaet;            /*  zusammengesetzt wird.         */
  switch (toupper(Parity))  /*                                */
  { case 'N': Paritaet=0;   /*  Bits Bedeutung                */
              break;        /*  7-5  Baudrate (100 = 1200)    */
    case 'O': Paritaet=1;   /*  4,3  Paritt  (0 = keine)     */
              break;        /*    2  Stopbits (1 = zwei)      */
    case 'E': Paritaet=3;   /*  1,0  Zeichenlnge (11 = 8)    */
  }                         /* +------------------------------+ */
  Register.h.ah=0;
  Register.h.al=(1+(int) ceil(log(Baud/150)/log(2))) << 5
                 | Paritaet << 3
                 | (StopBits-1) << 2
                 | DataBits-5;            /* Initialisierungsparameter */
  Register.x.dx=ComPort;
  int86(0x14,&Register,&Register);
}

char TastLes(void)
{ char Zeichen;
  Zeichen=getch();
  if (Zeichen != ESC)
     putch(Zeichen);
  if (Zeichen == 0x0D)
     putch(0x0A);
  return Zeichen;
}

void Senden(char Zeichen)      /* auf Schnittstelle schreiben */
{ Register.h.ah=1;
  Register.h.al=Zeichen;
  Register.x.dx=ComPort;
  int86(0x14,&Register,&Register);
}

unsigned int Horchen(void)
{ int RueckWert;
  char Zeichen;
  Register.h.ah=3;
  Register.x.dx=ComPort;
  RueckWert=int86(0x14,&Register,&Register);
  if (RueckWert & 0x0100)          /* Zeichen zum Lesen da ?  */
  { Register.h.ah=2;
    Register.x.dx=ComPort;
    RueckWert=int86(0x14,&Register,&Register);
    if ((RueckWert & ESC) == ESC)  /* wurde ESC empfangen ? */
    { puts("\nProgrammlauf durch Empfang von ESC beendet.\n");
      getch();
      exit(0);
    }
    if ((RueckWert & 0x8000) == 0) /* kein Time-out ? */
       return RueckWert;
  }
  else
    return 0;
}

main()
{ unsigned int RueckWert;
  char Zeichen;
  InitCom(ComPort,Baud,DataBits,StopBits,Parity);
  delay(100);
  clrscr();
  puts("");
  do
  { while (!kbhit())
    { RueckWert=Horchen();  /* Leseversuch auf Schnittstelle */
      if (RueckWert != 0)   /* Zeichen da?                   */
      { if ((RueckWert & 0x00FF) == 0x000D)  /* Ja: CR ?     */
           putchar(0x0A);   /* Ja: LF ausgeben               */
        if (RueckWert != ESC)
           putchar (RueckWert);
      }
     }
     Zeichen=TastLes();
     Senden(Zeichen);
  }
  while ((RueckWert != ESC) && (Zeichen != ESC));
  puts("\nProgrammlauf durch Eingabe von ESC beendet.\n");
  getch();
}

