/* SerTestA.C: Terminal-Programm, feste Parameter, Assembler-nah */
#include <stdlib.h>
#include <bios.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>

#define ESC 0x1B

enum {COM1, COM2};

unsigned int Port[]={0x3F8,0x2F8};

char TastLes(void);
void Senden(unsigned char Zeichen);
unsigned char Horchen(void);
                                          
                                          
                                          
void InitCom (int COM1,     /* +------------------------------+ */
              int Baud,     /*  Der Initialisierungsparameter */
              int DataBits, /*  ist ein Byte-Wert, der zur    */
              int StopBits, /*  leichteren Handhabung aus     */
              char Parity)  /*  "sprechenden" Parametern      */
{ char Paritaet;            /*  zusammengesetzt wird.         */
  switch (toupper(Parity))  /*                                */
  { case 'N': Paritaet=0;   /*  Bits Bedeutung                */
              break;        /*  7-5  Baudrate (100 = 1200)    */
    case 'O': Paritaet=1;   /*  4,3  Paritt  (0 = keine)     */
              break;        /*    2  Stopbits (1 = zwei)      */
    case 'E': Paritaet=3;   /*  1,0  Zeichenlnge (11 = 8)    */
  }                         /* +------------------------------+ */
  bioscom(0,                          /* Initialisieren */
          (1+(int) ceil(log(Baud/150)/log(2))) << 5
           | Paritaet << 3
           | (StopBits-1) << 2
           | DataBits-5,              /* Initialisierungsparameter */
          COM1);                      /* Auswahl COM1 oder COM2    */
}

char TastLes(void)
{ char Zeichen;
  Zeichen=getch();
  if (Zeichen != ESC)
     putch(Zeichen);
  if (Zeichen == 0x0D)
     putch(0x0A);
  return Zeichen;
}

void Senden(unsigned char Zeichen)      /* auf Schnittstelle schreiben */
{ outportb(Port[COM1],Zeichen);
}


unsigned char Horchen(void)
{ int RueckWert;
  char Zeichen, Byte;
  Byte=inportb(Port[COM1]+5); /* Status vom Leitungs-Statusreg. lesen */
  if (Byte & 0x01)           /* wenn Zeichen zum Lesen da */
  { Zeichen=inportb(Port[COM1]);  /* Zeichen lesen */
    if (Zeichen == ESC)      /* wurde ESC empfangen ? */
    { puts("\nProgrammlauf durch Empfang von ESC beendet.\n");
      getch();
      exit(0);
    }
    return Zeichen;
  }
  else
    return 0;
}

main()
{ unsigned char Zeichen, Empfangen, Parity;
  InitCom(COM1,1200,8,2,'N');
  delay(100);
  clrscr();
  puts("");
  do
  { while (!kbhit())
    { Empfangen=Horchen();  /* Leseversuch auf Schnittstelle */
      if (Empfangen != 0)   /* Zeichen da?                   */
      { if (Empfangen == 0x0D)  /* Ja: CR ?        */
           putchar(0x0A);       /* Ja: LF ausgeben */
        if (Empfangen != ESC)
           putchar (Empfangen);
      }
     }
     Zeichen=TastLes();
     Senden(Zeichen);
  }
  while ((Empfangen != ESC) && (Zeichen != ESC));
  puts("\nProgrammlauf durch Eingabe von ESC beendet.\n");
  getch();
}

