#ifndef __BIT_H
#define __BIT_H

#define SETMSK(n) (1<<(n))
#define CLRMSK(n) (~(1<<(n)))

#define BITSET(v,n) ((v)|SETMSK(n))
#define BITCLR(v,n) ((v)&CLRMSK(n))
#define BITINV(v,n) ((v)^SETMSK(n))
#define BITTST(v,n) (((v)&SETMSK(n))!=0)
#define BITMAK(b,n) (((b)==0)?0:SETMSK(n))
#define BITINS(v,n,b) \
  (((b)==0)?BITCLR((v),(n)):BITSET((v),(n)))
#define BITOR(v,n,b) (((b)==0)?(v):BITSET((v),(n)))
#define BITAND(v,n,b) (((b)==1)?(v):BITCLR((v),(n)))
#define BITXOR(v,n,b) (((b)==0)?(v):BITINV((v),(n)))

#endif
