#ifndef __IO_HPP
#define __IO_HPP

#include <mytypes.h>
#define P_IO
#include <portable.h>
#include <mylib.h>
#include <bit.h>

#define GETPORT() intoff();Old=IN_PORT(Adr)
//#define GETPORT() intoff();Old=Val;Val=IN_PORT(Adr)
#define SETPORT() OUT_PORT(Adr,Val);inton()

#define PC_MAXPORTS 0x400

#define TRENN_OUT ':'
#define TRENN_IO  '='
#define TRENN_BIT '#'

#define DISP_IN  "->"
#define DISP_OUT "<-"
#define DISP_IO  "<>"

extern BOOL first_IO;

enum DIRECTION
{
  IN,
  OUT,
  IN_OUT
};

enum PORT
{
  BYTE,
  BIT
};

enum IO_ERR
{
  IO_NOERROR = 0,
  IO_ERR_ADDR,
  IO_ERRS_IOTYP,
  IO_ERRS_LEN,
  IO_ERRS_ADDR,
  IO_ERRS_BITN,
  IO_ERRS_DAT,
  IO_ERRBIT_NR,
  IO_ERR1,
  IO_ERR0
};

enum IO_DISP
{
  IO_DISP_NONE=0,
  IO_DISP_BIT=1,
  IO_DISP_BYTE=2,
  IO_DISP_BOTH=3
};

struct PORTUSAGE
{
  UCHAR in;
  UCHAR out;
};

class IO
{
public:

  UCHAR val()
    { return (Port==BYTE)?Val:BITTST(Val,Nr); }
  UCHAR old()
    { return (Port==BYTE)?Old:BITTST(Old,Nr); }
  UCHAR byte() { return Val; }
  UCHAR oldbyte() { return Old; }
  UCHAR bit() { return BITTST(Val,Nr); }
  INT adr() { return Adr; }
  DIRECTION io() { return Io; }
  CHAR nr() { return Nr; }
  PORT port() { return Port; }

  UCHAR Disp;

protected:

  IO(INT a, DIRECTION dir, BOOL check);
  IO(UCHAR n, INT a, DIRECTION dir, BOOL check);
  IO(PORT p, IO_DISP d)
    { Port=p; Disp = d; } // nur fr IOBYTE
  ~IO();

  INT Adr;
  DIRECTION Io;
  UCHAR Val;
  UCHAR Old;
  UCHAR Nr;

private:

  PORT Port;
  static PORTUSAGE portusage[PC_MAXPORTS];
  BOOL Check;
};

ostream& operator << (ostream& o, IO& iob);

IO_ERR chk (CHAR *s,
  INT& adr, DIRECTION& io, UCHAR& val, BOOL disp);
IO_ERR chkb(CHAR *s, CHAR& nr,
  INT& adr, DIRECTION& io, UCHAR& val, BOOL disp);

class IOBYTE : public IO
{
public:
  IOBYTE() : IO(BYTE, IO_DISP_BYTE) { Io=IN_OUT; }
  VOID setaddr(INT a) { Adr=a; }
  VOID setdata(UCHAR d) { Val=d; }
};

class IOBYTE_IN : public IO
{
public:
  IOBYTE_IN(INT a,BOOL c=TRUE) : IO(a,IN,c)
  { Old=Val=IN_PORT(Adr); }

  UCHAR operator () ()
    { Old=Val; Val=IN_PORT(Adr); return Val; }
  UCHAR get_c();
};


class IOBYTE_OUT : public IO
{
public:
  IOBYTE_OUT(INT a, UCHAR v,BOOL c=TRUE)  : IO(a,OUT,c)
    { OUT_PORT(Adr,v); Old=Val=v; }
  IOBYTE_OUT(INT a,BOOL c=TRUE) : IO(a,OUT,c) { }

  VOID operator = (UCHAR v)
    { Old=Val; Val=v; OUT_PORT(Adr,v); }

  UCHAR operator ~ ()
    { *this = ~Val; return Val; }
  UCHAR operator ++ ()
    { *this = (Val+1); return Val; }
  UCHAR operator -- ()
    { *this = (Val-1); return Val; }
  VOID operator += (UCHAR v) { *this = Val+v; }
  VOID operator -= (UCHAR v) { *this = Val-v; }
  VOID operator *= (UCHAR v) { *this = Val*v; }
  VOID operator /= (UCHAR v) { *this = Val/v; }
  VOID operator %= (UCHAR v) { *this = Val%v; }
  VOID operator <<= (UCHAR v) { *this = Val<<v; }
  VOID operator >>= (UCHAR v) { *this = Val>>v; }
  VOID operator ^= (UCHAR v) { *this = Val^v; }
  VOID operator &= (UCHAR v) { *this = Val&v; }
  VOID operator |= (UCHAR v) { *this = Val|v; }
};

class IOBYTE_IO : public IO
{
private:
  BOOL hide;
  VOID inton() { if (hide) enable(); }
  VOID intoff() { if (hide) disable(); }
public:
  IOBYTE_IO(INT a, UCHAR v, BOOL h=TRUE,BOOL c=TRUE)
  : IO(a,IN_OUT,c)
  { Old=Val=v; hide=h; }
  IOBYTE_IO(INT a, BOOL h=TRUE, BOOL c=TRUE)
  : IO(a,IN_OUT,c)
  { hide=h; }

  UCHAR operator () ()
    { Old=Val; Val=IN_PORT(Adr); return Val; }
  VOID operator = (UCHAR v)
    { GETPORT(); Val=v; SETPORT(); }

  UCHAR operator ++ ()
    { GETPORT(); Val=Old+1; SETPORT(); return Val; }
  UCHAR operator -- ()
    { GETPORT(); Val=Old-1; SETPORT(); return Val; }
  UCHAR operator ~ ()
    { GETPORT(); Val=~Old; SETPORT(); return Val; }
  VOID operator += (UCHAR v)
    { GETPORT(); Val=Old+v; SETPORT(); }
  VOID operator -= (UCHAR v)
    { GETPORT(); Val=Old-v; SETPORT(); }
  VOID operator *= (UCHAR v)
    { GETPORT(); Val=Old*v; SETPORT(); }
  VOID operator /= (UCHAR v)
    { GETPORT(); Val=Old/v; SETPORT(); }
  VOID operator %= (UCHAR v)
    { GETPORT(); Val=Old%v; SETPORT(); }
  VOID operator <<= (UCHAR v)
    { GETPORT(); Val=Old<<v; SETPORT(); }
  VOID operator >>= (UCHAR v)
    { GETPORT(); Val=Old>>v; SETPORT(); }
  VOID operator ^= (UCHAR v)
    { GETPORT(); Val=Old^v; SETPORT(); }
  VOID operator &= (UCHAR v)
    { GETPORT(); Val=Old&v; SETPORT(); }
  VOID operator |= (UCHAR v)
    { GETPORT(); Val=Old|v; SETPORT(); }

  IO_ERR tst(ostream& o, BOOL t);
};

class IOBIT_IN : public IO
{
public:
  IOBIT_IN(CHAR n, INT a, BOOL c=TRUE) : IO(n,a,IN,c)
    { Old=Val=IN_PORT(Adr); }

  UCHAR operator () ()
    { Old=Val; Val=IN_PORT(Adr);
      return BITTST(Val,Nr);
    }
  UCHAR get_c();
};


class IOBIT_OUT : public IO
{
public:
  IOBIT_OUT(CHAR n,INT a,UCHAR v,BOOL c=TRUE)
  : IO(n,a,OUT,c)
    { Val=Old=BITMAK(v,n); OUT_PORT(Adr,Val); }
  IOBIT_OUT(CHAR n,INT a,BOOL c=TRUE)
  : IO(n,a,OUT,c)
    { }

  VOID operator = (UCHAR v)
    { Old=Val; Val=BITINS(Val,Nr,v);
      OUT_PORT(Adr,Val);
    }
  VOID set(UCHAR v)
    { Old=Val; Val=v; OUT_PORT(Adr,v); }

  UCHAR operator ~ ()
    {  Old=Val; Val = BITINV(Val,Nr);
       OUT_PORT(Adr,Val); return BITTST(Val,Nr); }
  UCHAR operator ++ ()
    { return (*this).operator ~ (); }
  UCHAR operator -- ()
    { return (*this).operator ~ (); }
  VOID operator ^= (UCHAR v)
    { Old=Val; Val = BITXOR(Val,Nr,v);
      OUT_PORT(Adr,Val);
    }
  VOID operator &= (UCHAR v)
    { Old=Val; Val = BITAND(Val,Nr,v);
      OUT_PORT(Adr,Val);
    }
  VOID operator |= (UCHAR v)
    { Old=Val; Val = BITOR(Val,Nr,v);
      OUT_PORT(Adr,Val);
    }
};

class IOBIT_IO : public IO
{
private:
  BOOL hide;
  VOID inton() { if (hide) enable(); }
  VOID intoff() { if (hide) disable(); }
public:

  IOBIT_IO(CHAR n, INT a, UCHAR v,
    BOOL h=TRUE,BOOL c=TRUE)
  : IO(n,a,IN_OUT,c)
    { hide=h; Val=IN_PORT(Adr); Val=BITMAK(Val,n);
      Old=Val; OUT_PORT(Adr,Val); }
  IOBIT_IO(CHAR n, INT a,
    BOOL h=TRUE,BOOL c=TRUE)
  : IO(n,a,IN_OUT,c)
    { hide=h; Old=Val=IN_PORT(Adr); }

  VOID operator = (UCHAR v)
  { GETPORT(); Val = BITINS(Old,Nr,v); SETPORT(); }
  UCHAR operator () ()
    { Old=Val; Val=IN_PORT(Adr);
      return BITTST(Val,Nr);
    }
  UCHAR operator ~ ()
  { GETPORT(); Val = BITINV(Old,Nr); SETPORT();
    return BITTST(Val,Nr);
  }
  UCHAR operator ++ ()
    { return (*this).operator ~ (); }
  UCHAR operator -- ()
    { return (*this).operator ~ (); }
  VOID operator ^= (UCHAR v)
    { GETPORT(); Val=BITXOR(Old,Nr,v); SETPORT(); }
  VOID operator &= (UCHAR v)
    { GETPORT(); Val = BITAND(Old,Nr,v); SETPORT(); }
  VOID operator |= (UCHAR v)
    { GETPORT(); Val = BITOR(Old,Nr,v); SETPORT(); }
  IO_ERR tst(ostream& o, BOOL t);
  INT looperror();
};

class IOBIT_LOOP
{
public:
  IOBIT_LOOP(INT txa, CHAR txb, INT rxa, CHAR rxb,
             BOOL pol)
    { tx = new IOBIT_OUT(txb,txa);
      rx = new IOBIT_IN(rxb,rxa);
      polarity=pol; make = TRUE; }
  IOBIT_LOOP(IOBIT_OUT *out, IOBIT_IN *in, BOOL pol)
    { tx = out; rx = in; polarity=pol; make = FALSE; }
  IOBIT_LOOP(IOBIT_OUT& out, IOBIT_IN& in, BOOL pol)
    { tx = &out; rx = &in; polarity=pol; make = FALSE; }
  ~IOBIT_LOOP()
    { if (!make) return; delete tx; delete rx; }

  VOID operator = (UCHAR v) { tx->operator = (v); }
  UCHAR operator()() { return rx->operator()(); }

  INT tst(ostream& o);

private:

  IOBIT_OUT *tx;
  IOBIT_IN *rx;
  BOOL polarity;
  BOOL make;
};

#endif // __IO_HPP


