#ifndef __KEYBIOS_HPP
#define __KEYBIOS_HPP

#ifdef __cplusplus

#include <memabs.hpp>

/* class IBIOS
 * ===========
 * holds Pointer and Val of BIOS-Data-address
 */
template <class T>
class IBIOS : public BIOS<T>
{
public:

  IBIOS(BIOSA offset) : BIOS<T>(offset)
    { Old = Val; }
  IBIOS(UINT offset) : BIOS<T>(offset)
    { Old = Val; }
  IBIOS(BIOSA offset, T t) : BIOS<T>(offset,t)
    { Old = Val; }
  IBIOS(UINT offset, T t) : BIOS<T>(offset,t)
    { Old = Val; }

  T operator () ()
    { Old = Val;
      Val = *((T far *)MKB_FP(*p));
      return Val;
    }
  VOID operator = (T t)
    { Old = Val;
      *((T far *)MKB_FP(*p)) = t;
      Val = t;
    }
  BOOL changed() { return (Old==Val) ? FALSE : TRUE; }
  UINT pointoff() { return *p; }
private:
  UINT Old;
};

class KBDQUEUE : public BIOS<UINT>
{
private:

  BIOS<UINT> *begin;
  BIOS<UINT> *end;

public:

  KBDQUEUE(UINT adr) : BIOS<UINT>(adr)
    { begin=new BIOS<UINT>(keybd_begin);
      end=new BIOS<UINT>(keybd_end);
    }
  KBDQUEUE()
  : BIOS<UINT>( *((UINT far *)BIOSA_FP(keybd_begin)) )
    { begin=new BIOS<UINT>(keybd_begin);
      end=new BIOS<UINT>(keybd_end);
    }
  ~KBDQUEUE() { delete begin; delete end; }

  VOID set (UINT adr)
    { p=(UINT far*)MKB_FP(adr);
      operator()();
    }
  UINT next()
    { p++;
      if ( p==(UINT far *)MKB_FP(end->operator()()) )
	p=(UINT far *)MKB_FP(begin->operator()());
      return operator()();
    }
  UINT prev()
    { p--;
      if (p < (UINT far *)MKB_FP(begin->operator()()))
	p=(UINT far *)MKB_FP(end->operator()()-2);
      return operator()();
    }
  VOID operator = (UINT adr)
    { BIOS<UINT>::operator = (adr);
    }
  UINT operator () ()
    { return BIOS<UINT>::operator () ();
    }
  BOOL last()
    { BIOS<UINT> head(keybd_q_head);
      BIOS<UINT> tail(keybd_q_tail);
      KBDQUEUE q(tail());
      q.next();
      if (q.off()==head()) return TRUE;
      else return FALSE;
    }
};

struct KBDSTATUS
{
  UCHAR flag1;
  UCHAR flag2;
  UCHAR flag3;
  UCHAR flag4;
  UINT head;
  UINT tail;
  UCHAR alt;
  UCHAR brk;
  UINT key;
};

#ifdef MYHISTORY
  #include <myhist.h>
#else
  #include <queues.h>
#endif

class KBD
{
private:

  BIOS<UCHAR> *flag1;
  BIOS<UCHAR> *flag2;
  BIOS<UCHAR> *flag3;
  BIOS<UCHAR> *flag4;
  BIOS<UINT> *head;
  BIOS<UINT> *tail;
  BIOS<UCHAR> *alt;
  BIOS<UCHAR> *brk;

  KBDQUEUE *q;
  KBDSTATUS Last;
  KBDSTATUS Status;
  BOOL Change;

#ifdef MYHISTORY
  KBDHISTORY *history;
#else
  BI_QueueAsVector<KBDSTATUS> *history;
#endif

public:

  KBD();
  BOOL read();

  BOOL put();
  KBDSTATUS *get ();

  KBDSTATUS *operator () ();
  BOOL changed() { return Change; }
  KBDSTATUS last() { return Last; }
  KBDSTATUS status() { return Status; }
  UINT key() { return Status.key; }


  VOID out(KBDSTATUS *s);
  VOID out() { out(&Status); }
  VOID out_history();
};
#else
  #error "must compile with C++-Compiler
#endif // __cplusplus
#endif // __KEYBIOS_HPP
