#ifndef __MEMABS_HPP
#define __MEMABS_HPP

#define P_POINTER
#include <portable.h>
#include <mytypes.h>

#define GETMEM() Val=operator()()
#define SETMEM() operator=(Val);return Val

template <class T>
class MEM
{
protected:

  T Val;
  T far *p;

public:

  MEM(T far *tp)
    { p=tp; operator()(); }
  MEM(UINT s, UINT o)
    { p=(T far *)MK_FP(s,o); operator()(); }
  MEM(T far *tp, T t)
    { p=tp; operator=(t); }
  MEM(UINT s, UINT o, T t)
    { p=(T far *)MK_FP(s,o); operator=(t); }

  virtual VOID operator = (T t)
    { Val = *p = t; }
  virtual T operator () ()
    { Val = *p; return Val; }

  T operator ++ ()
    { GETMEM(); Val++; SETMEM(); }
  T operator -- ()
    { GETMEM(); Val--; SETMEM(); }
  T operator << (UINT i)
    { GETMEM(); Val<<=i; SETMEM(); }
  T operator >> (UINT i)
    { GETMEM(); Val>>=i; SETMEM(); }
  T operator ~ ()
    { GETMEM(); Val=~Val; SETMEM(); }
  T operator += (T t)
    { GETMEM(); Val+=t; SETMEM(); }
  T operator -= (T t)
    { GETMEM(); Val-=t; SETMEM(); }
  T operator *= (T t)
    { GETMEM(); Val*=t; SETMEM(); }
  T operator /= (T t)
    { GETMEM(); Val/=t; SETMEM(); }
  T operator %= (T t)
    { GETMEM(); Val%=t; SETMEM(); }
  T operator &= (T t)
    { GETMEM(); Val&=t; SETMEM(); }
  T operator |= (T t)
    { GETMEM(); Val|=t; SETMEM(); }
  T operator ^= (T t)
    { GETMEM(); Val^=t; SETMEM(); }

  T val() { return Val; }
  T far *addr() { return p; }

  UINT seg() { return FP_SEG(p); }
  UINT off() { return FP_OFF(p); }
};

template <class T>
class MEM_P : public MEM<T>
{
public:

  MEM_P(UINT s, UINT o) : MEM<T>(s,o)
    { Old = MEM<T>::operator()(); }
  MEM_P(UINT seg, UINT off, T t) : MEM<T>(seg,off,t)
    { MEM<T>::operator=(t); Old = t; }

  VOID operator = (T t)
   { Old = Val;
     **((T far **)p) = t;
     Val = t;
   }

  T operator () ()
    { Old = Val;
      Val = **((T far **)p);
      return Val;
    }

  BOOL changed()
    { return (Old==Val) ? FALSE : TRUE; }
  UINT pointoff()
    { return FP_OFF((T far *)(*p)); }
  UINT pointseg()
    { return FP_SEG((T far *)(p)); }
  T far *pointaddr()
    { return (T far *)(*p); }

protected:

  T Old;
};

#endif // __cplusplus

typedef enum BIOSA
{
  rs232_port_1       = 0x4100, // UINT
  rs232_port_2       = 0x4102, // UINT
  rs232_port_3       = 0x4104, // UINT
  rs232_port_4       = 0x4106, // UINT
  prn_port_1         = 0x4108, // UINT
  prn_port_2         = 0x410A, // UINT
  prn_port_3         = 0x410C, // UINT
  BIOS_data_seg      = 0x410E, // UINT
  equip_bits         = 0x4110, // UINT
  init_test_flag     = 0x4212, // UCHAR
  main_ram_size      = 0x4113, // UINT
  chan_io_size       = 0x4115, // UINT
  keybd_flags_1      = 0x4217, // UCHAR
  keybd_flags_2      = 0x4218, // UCHAR
  keybd_alt_num      = 0x4219, // UCHAR
  keybd_q_head       = 0x411A, // UINT
  keybd_q_tail       = 0x411C, // UINT
  keybd_queue        = 0x491E, // UINT
  dsk_recal_stat     = 0x423E, // UCHAR
  dsk_motor_stat     = 0x423F, // UCHAR
  dsk_motor_tmr      = 0x4240, // UCHAR
  dsk_ret_code       = 0x4241, // UCHAR
  dsk_status_1       = 0x4242, // UCHAR
  dsk_status_2       = 0x4243, // UCHAR
  dsk_status_3       = 0x4244, // UCHAR
  dsk_status_4       = 0x4245, // UCHAR
  dsk_status_5       = 0x4246, // UCHAR
  dsk_status_6       = 0x4247, // UCHAR
  dsk_status_7       = 0x4248, // UCHAR
  video_mode         = 0x4249, // UCHAR
  video_columns      = 0x414A, // UINT
  video_buf_siz      = 0x414C, // UINT
  video_segment      = 0x414E, // UINT
  vid_curs_pos0      = 0x4150, // UINT
  vid_curs_pos1      = 0x4152, // UINT
  vid_curs_pos2      = 0x4154, // UINT
  vid_curs_pos3      = 0x4156, // UINT
  vid_curs_pos4      = 0x4158, // UINT
  vid_curs_pos5      = 0x415A, // UINT
  vid_curs_pos6      = 0x415C, // UINT
  vid_curs_pos7      = 0x415E, // UINT
  vid_curs_mode      = 0x4160, // UINT
  video_page         = 0x4262, // UCHAR
  video_port         = 0x4163, // UINT
  video_mode_reg     = 0x4265, // UCHAR
  video_color        = 0x4266, // UCHAR
  gen_io_ptr         = 0x4167, // UINT
  gen_io_seg         = 0x4169, // UINT
  gen_int_occured    = 0x426B, // UCHAR
  timer_low          = 0x416C, // UINT
  timer_hi           = 0x416E, // UINT
  timer_rolled       = 0x4270, // UCHAR
  keybd_break        = 0x4271, // UCHAR
  warm_boot_flag     = 0x4172, // UINT
  hdsk_status_1      = 0x4274, // UCHAR
  hdsk_count         = 0x4275, // UCHAR
  hdsk_head_ctrl     = 0x4276, // UCHAR
  hdsk_ctrl_port     = 0x4277, // UCHAR
  prn_timeout_1      = 0x4278, // UCHAR
  prn_timeout_2      = 0x4279, // UCHAR
  prn_timeout_3      = 0x427A, // UCHAR
  prn_timeout_4      = 0x427B, // UCHAR
  rs232_timeout_1    = 0x427C, // UCHAR
  rs232_timeout_2    = 0x427D, // UCHAR
  rs232_timeout_3    = 0x427E, // UCHAR
  rs232_timeout_4    = 0x427F, // UCHAR
  keybd_begin        = 0x4180, // UINT
  keybd_end          = 0x4182, // UINT
  video_rows         = 0x4284, // UCHAR
  video_pixels       = 0x4185, // UINT
  video_options      = 0x4287, // UCHAR
  video_switches     = 0x4288, // UCHAR
  video_1_reservd    = 0x4289, // UCHAR
  video_2_reservd    = 0x428A, // UCHAR
  dsk_data_rate      = 0x428B, // UCHAR
  hdsk_status_2      = 0x428C, // UCHAR
  hdsk_error         = 0x428D, // UCHAR
  hdsk_int_flags     = 0x428E, // UCHAR
  hdsk_options       = 0x428F, // UCHAR
  hdsk0_media_st     = 0x4290, // UCHAR
  hdsk1_media_st     = 0x4291, // UCHAR
  hdsk0_start_st     = 0x4292, // UCHAR
  hdsk1_start_st     = 0x4293, // UCHAR
  hdsk0_cylinder     = 0x4294, // UCHAR
  hdsk1_cylinder     = 0x4295, // UCHAR
  keybd_flags_3      = 0x4296, // UCHAR
  keybd_flags_4      = 0x4297, // UCHAR
  timer_wait_off     = 0x4198, // UINT
  timer_wait_seg     = 0x419A, // UINT
  timer_clk_low      = 0x419C, // UINT
  timer_clk_hi       = 0x419E, // UINT
  timer_clk_flag     = 0x42A0, // UCHAR
  lan_1              = 0x42A1, // UCHAR
  lan_2              = 0x42A2, // UCHAR
  lan_3              = 0x42A3, // UCHAR
  lan_4              = 0x42A4, // UCHAR
  lan_5              = 0x42A5, // UCHAR
  lan_6              = 0x42A6, // UCHAR
  lan_7              = 0x42A7, // UCHAR
  video_sav_tbls     = 0x44A8, // ULONG
  days_since_1_80    = 0x41CE, // UINT
  prn_scrn_stat      = 0x5200  // UCHAR
};

/* BIOS_FP
 * =======
 * creates VOID-far-Pointer to BIOS-Data-area
 * using enum BIOSA
 */
#define BIOSA_FP(l) MK_FP(((l)&0xf000)>>8,(l)&0x00ff)

/* MKB_FP
 * ======
 * creates VOID-far-Pointer to BIOS-Data-area
 * using integer-argument
 */
#define MKB_FP(l) MK_FP(0x40,(l)&0x00ff)

/* BIOS_OFF
 * =======
 * returns Offset of BIOS data
 * using enum BIOSA
 */
#define BIOS_OFF(l) ((l)&0x00ff)

#ifdef __cplusplus

/* class BIOS
 * ==========
 * holds Pointer and Val of BIOS-Data-address
 * usable for all non-Pointer types
 */

template <class T>
class BIOS : public MEM<T>
{
public:
  BIOS(UINT offset)
  : MEM<T>(0x40,offset)
    { Old=Val; }
  BIOS(BIOSA offset)
  : MEM<T>((offset>>8)&0xf0,offset&0x00ff)
    { Old=Val; }
  BIOS(UINT offset,T t)
  : MEM<T>(0x40,offset,t)
    { Old=Val; }
  BIOS(BIOSA offset,T t)
  : MEM<T>((offset>>8)&0xf0,offset&0x00ff,t)
    { Old=Val; }

  virtual T operator () ()
    { Old=Val; return MEM<T>::operator()(); }
  virtual VOID operator = (T t)
    { Old=Val; MEM<T>::operator=(t); }
  BOOL changed()
    { return (Old==Val) ? FALSE : TRUE; }
private:
  T Old;
};

#endif // __MEMABS_HPP

