#ifndef __MYTYPES_H
#define __MYTYPES_H
/*
 * compiles on both C and C++ compiler
 * C++ compiler prefered, TURBO-C use -P option
 */

#if defined(__TURBOC__)
  #pragma option -w   // turn all warnings on
#endif

typedef long          LONG;
typedef int           INT;
typedef char          CHAR;
typedef float         FLOAT;
typedef double        DOUBLE;
typedef void          VOID;
typedef unsigned long ULONG;
typedef unsigned int  UINT;
typedef unsigned int  USHORT;
typedef unsigned char UCHAR;

typedef enum
{
  TRUE=1,
  FALSE=0
} BOOL;

#if defined(__cplusplus)

// define BOOLc,UCHARc,UINTc as classes

#ifdef __TURBOC__
#pragma warn -lvc   // temporary used
#pragma warn -ncf   // non constant function
                    // to const member
#endif

#include <limits.h>
#include <stdlib.h>
#include <iostream.h>

/*************************************************/
/*  BOOL class. Copyright by Joe Schell 1989.    */
/*************************************************/

const INT _TRUE = 1;
const INT _FALSE = 0;

class BOOLc
{
  int b;    // BOOL type.
  void value(const int i)
    { b = (i) ? _TRUE : _FALSE; }
public:
  BOOLc()
    { b = _FALSE; }
  BOOLc(const int i)
    { value(i); }
  BOOLc(const BOOLc &i)
    { b = i.b; }

  operator int() const
    { return b; }
  operator ~() const
    { return b ? _FALSE : _TRUE; }
  BOOLc &operator=(const int &i)
    { value(i);  return *this; }
  BOOLc &operator++(int)
    { b = b ? _FALSE : _TRUE;  return *this; }
  BOOLc &operator--(int)
    { return (*this)++; }
  friend ostream& operator << (ostream& o, BOOLc& b)
    { o << b ? "true" : "false"; return o; }
};  // End of BOOLc class.

/*************************************************/
/*  Byte classes. Copyright by Joe Schell 1989.  */
/*************************************************/

/*-----------------------------------------------*/
/* UCHARc  Handle a byte.      */
/*-----------------------------------------------*/
class UCHARc
{
public:
  UCHARc()
    { c = 0; }
  UCHARc(int &i)
    { c = value(i); }
  operator int() const
    { return c; }
  UCHARc operator=(int &i)
    { c = value(i); return *this; }
  UCHARc operator++(int)
    { c++; return *this; }
  UCHARc operator--(int)
    { c--; return *this; }
  friend ostream& operator << (ostream& o, UCHARc& uc)
    { o << uc.c; return o; }

private:

  unsigned char c;
  unsigned char value(int &i)
  {
    if (i > UCHAR_MAX)
    {
      cerr << "\nUCHARc class: Illegal value-"
           << i << "\n";
      exit(EXIT_FAILURE);
    }
    return (unsigned char)i;
  }
};  // End of UCHARc class.

/*-----------------------------------------------*/
/* UINTc      Handle a word    */
/*-----------------------------------------------*/
class UINTc
{
public:

  UINTc()
    { i = 0; }
  UINTc(long &x)
    { i = value(x); }
  operator long() const
    { return (long)i; }
  UINTc operator++(int)
    { i++; return *this; }
  UINTc operator--(int)
    { i--; return *this; }
  friend ostream& operator << (ostream& o, UINTc& ui)
    { o << ui.i; return o; }

private:

  unsigned int i;
  unsigned int value(long &x)
  {
    if (x > UINT_MAX)
    {
      cerr << "\nUINTc class: Illegal value-"
           << x << "\n";
      exit(EXIT_FAILURE);
    }
    return (unsigned int)x;
  }
};  // End of UINTc class.

#endif // __cplusplus

#endif // __MYC_H
