/* ANSIC.C TESTPROGRAMM fr ANSI-Bildschirmsteuerung in C */

#include <ansi.h>              /* inkludiert auch stdio.h und string.h */
#include <..\source\ansiw.c>   /* Funktionen WINDOW(), draw(), fill() */
#include <mem.h>               /* _fmemset */
#include <dos.h>               /* MK_FP */
#include <stdlib.h>            /* exit() */

void ZeichneRaster(void)
{
  int i;

  GOTOXY(1,1);
  for (i=0; i<8; i++)
    printf("1234567890");
  for (i=1; i<=25; i++)
    XYCHAR(i,1,i%10+'0');
}

void KursorTest(void)
{
  ZeichneRaster();
  GOTOXY(10,10);
  printf("Hallo mit ANSI Bildschirmsteuerung ");
  CURSPUSH();
  printf("\nKursorsteuerung\n");
  GOTOXY(20,29);
  CUUP(2); printf("UP");
  CUDN(4); CULT(2); printf("DOWN");
  CUUP(2); CULT(8); printf("LEFT");
  CURT(5); printf("RIGHT");
  CURSPOP(); printf("in C");
  XYSTRING(2,3,"noch ein Text");
  XYCHAR(2,2,'#');

  /* Holen der aktuellen Kursorposition */
  {
    unsigned row, col;
    row=0; col=0;
    GOTOXY(15,18);
    SETDISPLAY(0,0,8);
    GETCURPOS(&row,&col);
    printf("Der Kursor ist auf Zeile %u und Spalte %u (soll: 15,19)",
	   row,col);
  }
}

void DeviceStatus(void)
{
  char s[80];

  printf("Devicestatus: ");
  DEVICESTATUS();
  SETDISPLAY(0,0,8);
  scanf("%s",s);
  SETDISPLAY(0,0,0);
  printf(s);
}

void Bildschirmloeschen(unsigned char c,
			unsigned char a1,
			unsigned char a2,
			unsigned char a3)
{
  int i;

  CLS();
  SETSCREEN(7);
  SETDISPLAY(a1,a2,a3);
  for (i=0; i<2000; i++)
  {
    printf("%c",c);
  }
}

void Zeilenloeschen(void)
{
  Bildschirmloeschen('1',ANSI_FORE_GREEN,ANSI_BACK_RED,ANSI_NORMAL);
  GOTOXY(1,1);
  printf("Zeilenlschen\n");
  GOTOXY(10,10);
  EEOL();
}

void FarbenTest(void)
{
  printf("4. Farbentest\n");
  SETDISPLAY(42,31,1); printf("Hintergrund GRN        Vordergrund ROT     Hell\n");
  SETDISPLAY(43,32,1); printf("Hintergrund GELB        Vordergrund GRN    Hell\n");
  SETDISPLAY(44,33,1); printf("Hintergrund BLAU        Vordergrund GELB    Hell\n");
  SETDISPLAY(45,34,1); printf("Hintergrund VIOLETT     Vordergrund BLAU    Hell\n");
  SETDISPLAY(46,35,1); printf("Hintergrund CYAN        Vordergrund VIOLETT Hell\n");
  SETDISPLAY(47,36,1); printf("Hintergrund WEISS       Vordergrund CYAN    Hell\n");
  SETDISPLAY(40,37,1); printf("Hintergrund SCHWARZ     Vordergrund WEISS   Hell\n");
  SETDISPLAY(42,31,2); printf("Hintergrund GRN        Vordergrund ROT     Dunkel\n");
  SETDISPLAY(43,32,2); printf("Hintergrund GELB        Vordergrund GRN    Dunkel\n");
  SETDISPLAY(44,33,2); printf("Hintergrund BLAU        Vordergrund GELB    Dunkel\n");
  SETDISPLAY(45,34,2); printf("Hintergrund VIOLETT     Vordergrund BLAU    Dunkel\n");
  SETDISPLAY(46,35,2); printf("Hintergrund CYAN        Vordergrund VIOLETT Dunkel\n");
  SETDISPLAY(47,36,2); printf("Hintergrund WEISS       Vordergrund CYAN    Dunkel\n");
  SETDISPLAY(40,37,2); printf("Hintergrund SCHWARZ     Vordergrund WEISS   Dunkel\n");
  SETDISPLAY(0,0,0); printf("Folgender Text XXXX sollte nicht sichtbar sein\n");
  SETDISPLAY(0,0,8); printf("XXXX\n");
  SETDISPLAY(0,0,0); printf("Jetzt wieder normal\n");
}

void SetScreen(int mode, char *text)
{
  CLS();
  SETSCREEN(mode);
  printf(text);
  printf("\n\n");
  SETDISPLAY(42,31,1);
  printf("Hintergrund GRN        Vordergrund ROT     Hell\n");
  GETKB();
  RESETSCREEN(mode);
  SETDISPLAY(0,0,0);
}

void DisplayModi(void)
{
  SETDISPLAY(0,0,0);
  SetScreen(0, "0=40x25 mono");
  SetScreen(1, "1=40x25 color");
  SetScreen(2, "2=80x25 mono");
  SetScreen(3, "3=80x25 color");
  SetScreen(4, "4=320x200 color");
  SetScreen(5, "5=320x200 mono");
  SetScreen(6, "6=640x200 mono");
  SetScreen(14, "14=640x200  16 color EGA/VGA, MSDOS 4.0 and later");
  SetScreen(15, "15=640x350   2 color EGA/VGA, MSDOS 4.0 and later");
  SetScreen(16, "16=640x350  16 color EGA/VGA, MSDOS 4.0 and later");
  SetScreen(17, "17=640x480   2 color EGA/VGA, MSDOS 4.0 and later");
  SetScreen(18, "18=640x480  16 color EGA/VGA, MSDOS 4.0 and later");
  SetScreen(19, "19=320x200 256 color EGA/VGA, MSDOS 4.0 and later");
}

void ZeilenEndeTest(void)
{
  SETSCREEN(3); /* 80x25, 16 color */
  CLS();
  SETSCREEN(7);
  printf("Folgende Zeile wird am Ende umgefaltet:\n");
  {
    int i;
    for (i=0; i<20; i++)
      printf("Zeilenendetest ");
  }
  GETKB();
  CLS();
  RESETSCREEN(7);
  printf("Folgende gleichlange Zeile wird am Ende nicht umgefaltet:\n");
  {
    int i;
    for (i=0; i<20; i++, printf("Zeilenendetest ") );
  }
}

void IntensitaetsTest(void)
{
  SETSCREEN(3);
  VIDNORM();
  printf("Das ist normaler Text\n");
  VIDBLINK();
  printf("Das ist blinkender Text\n");
  VIDNORM();
  VIDHIGH();
  printf("Das ist intensivierter Text\n");
  VIDNORM();
  printf("Das ist normaler Text\n");
}

void Fenster(int row1, int col1, int row2, int col2, char type, char *txt)
{
  SETSCREEN(3);
  VIDNORM();
  XYSTRING(2,2,"Fenster auf : ");
  printf("z:%u,s:%u bis z:%u,s:%u : ",row1,col1,row2,col2);
  printf(txt);
  ZeichneRaster();
  draw(row1,col1,row2,col2,type);
  GETKB();
}

void FensterTest(void)
{
  SETSCREEN(3);
  VIDNORM();
  Fenster(10,10,10,10,'i',"Punktuelles Fenster");
  Fenster(21,1,21,10,'i',"Horizontale Linie");
  Fenster(1,78,10,78,'i',"Vertikale Linie");
  Fenster(10,10,20,20,'i',"IBM einfacher Rahmen");
  Fenster(10,10,20,20,'I',"IBM doppelter Rahmen");
  Fenster(10,10,20,20,'a',"ASCII-Zeichen 1");
  Fenster(10,10,20,20,'A',"ASCII-Zeichen 2");
  Fenster(10,10,20,20,IBM_LIGHT,"IBM_LIGHT");
  Fenster(10,10,20,20,IBM_MEDIUM,"IBM_MEDIUM");
  Fenster(10,10,20,20,IBM_DARK,"IBM_DARK");
  Fenster(10,10,20,20,IBM_BLACK,"IBM_BLACK");
  Fenster(10,10,20,20,ASC_LIGHT,"ASC_LIGHT");
  Fenster(10,10,20,20,ASC_MEDIUM,"ASC_MEDIUM");
  Fenster(10,10,20,20,ASC_DARK,"ASC_DARK");
  Fenster(10,10,20,20,ASC_BLACK,"ASC_BLACK");
  Fenster(10,10,20,20,IBM_LIGHT,"IBM_LIGHT");
  XYSTRING(3,2,"gefllt mit @, Ende mit ENTER");
  fill(11,11,19,19,'@');
  GETKB();
  CLS();
  XYSTRING(1,1,"Fenster auf 10,10 Lnge:10,10, IBM_LIGHT");
  XYSTRING(2,1,"gefllt mit 1");
  WINDOW(10,10,20,20,'1',IBM_MEDIUM);
  CUDN(2);
  printf("Ende: ENTER");
}

void EingabeTest(void)
{
  int row=0, col=0;
  int Zeichen;

  SETSCREEN(3);
  printf("Einzelzeicheneingabe ohne Echo, Ende mit ENTER: ");
  WHEREXY(&row,&col);
  GOTOXY(row,col+2);
  GETCH(Zeichen);
  printf("Eingegeben wurde: %2x=%c\n",Zeichen,Zeichen);

  printf("Einzelzeicheneingabe mit Echo, Ende mit ENTER: ");
  WHEREXY(&row,&col);
  GOTOXY(row,col+2);
  GETCHE(Zeichen);
  printf("Eingegeben wurde: %2x=%c\n",Zeichen,Zeichen);

  printf("Einzelzeicheneingabe mit Echo, hellgetastet, Ende mit ENTER: ");
  WHEREXY(&row,&col);
  GOTOXY(row,col+2);
  GETCHHI(Zeichen);
  printf("Eingegeben wurde: %2x=%c\n",Zeichen,Zeichen);
}

void (*TestFunktion[])(void) =
{
  KursorTest,
  DeviceStatus,
  Zeilenloeschen,
  FarbenTest,
  DisplayModi,
  ZeilenEndeTest,
  IntensitaetsTest,
  FensterTest,
  EingabeTest
};

void main(void)
{
  unsigned char c;

  while (1)
  {
    SETSCREEN(2); /* 80x25, B/W */
    SETDISPLAY(0,0,0);
    CLS();
    printf("0. Ende\n");
    printf("1. Kursortest\n");
    printf("2. Devicestatus\n");
    printf("3. Zeilenloeschen\n");
    printf("4. Farbentest\n");
    printf("5. Bildschirmmodi\n");
    printf("6. Zeilenendetest\n");
    printf("7. Intensittssteuerung\n");
    printf("8. Fenstertest\n");
    printf("9. Eingabetest\n");

    do
    {
      GETCHE(c);
    }
    while ((c<'0') || (c>'9'));

    if (c=='0') exit(0);

    SETDISPLAY(0,0,0);
    CLS();
    TestFunktion[c-'1']();
    GETKB();
  }
}

/* ANSIC.C END */
