/* HC04CM1A.CPP */
/*
 * Schreiben und Lesen des CMOS-RAM, mit Klasse CMOSRAM
 * ====================================================
 */
#include <cmosram.hpp>
#ifndef MYLIB
#include "\mylib\source\cmosram.cpp"
#endif

VOID main(VOID)
{
  INT adr, checksum, value;
  CMOSRAM cmosram;

  constream con;

  for (;;)
  {
    con.clrscr();
    cmosram.print(con);
    checksum=cmosram.chksum();
    con << setxy(1,18);
    con << "Checksum of adr 0x10..0x2d:";
    con << setw(4) << hex << checksum;

    do /* Read address to change */
    {
      con << setxy(1,19) << clreol;
      con << "Alter byte (adr=0 ends) adr: ";
      cin >> hex >> adr;
      if (adr==0) return;
    }
    while ((adr<0x10) || (adr>0x7f));

    con << clreol;
    con << "value: ";
    cin >> hex >> value;
    cmosram.write(adr,value);
    con << clreol;
    // Update CHECKSUM if necessary
    checksum=cmosram.chksum();
    if (checksum != cmosram.chksum_read())
      cmosram.chksum_write(checksum);
  }
}
