/* HC04IO1.CPP */
/* 
 * Testen der Klassen IOBYTE_IN, IOBYTE_OUT, IOBYTE_IO
 * ===================================================
 */
#include <portable.h>
#include <iodef.h>
#include <keyscan.h>
#include <mylib.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

#define F hex<<setw(2)<<setfill('0')
#define OUT(o,a,n) out(o,a.old(),n())
#define OUTIO(o,io) out(o,io.old(),io.val())

VOID out(CHAR* operation, UCHAR alt, UCHAR neu)
{
  cout << operation <<F<< ' ' ;
  cout << "alt:" <<F<< (INT)alt << ' '
       << "neu:" <<F<< (INT)neu << ' ' << endl;
}

INT main(VOID)
{
  cout << endl
       << "IOBYTE_OUT/IOBYTE_IN: Operatoren-Test,\n";
  {
    IOBYTE_IN pi(PC_LPT1|LPT_DATA);
    IOBYTE_OUT po(PC_LPT1|LPT_DATA);
    po=0x13;     OUT("po=0x13:   ",po,pi);
    ++po;        OUT("++po:      ",po,pi);
    --po;        OUT("--po:      ",po,pi);
    po += 5;     OUT("po+=5:     ",po,pi);
    po -= 5;     OUT("po-=5:     ",po,pi);
    po *= 5;     OUT("po*=5:     ",po,pi);
    po /= 5;     OUT("po/=5:     ",po,pi);
    po = 13;     OUT("po=13:     ",po,pi);
    po %= 5;     OUT("po%=5:     ",po,pi);
    ~po;         OUT("~po:       ",po,pi);
    po &= 0xf0;  OUT("po$=0xf0:  ",po,pi);
    po |= 0xf0;  OUT("po|=0xf0:  ",po,pi);
    po ^= 0xff;  OUT("po^=0xff:  ",po,pi);
    po <<= 2;    OUT("po<<=2:    ",po,pi);
    po >>= 2;    OUT("po>>=2:    ",po,pi);
  }
  cout << endl
       << "IOBYTE_IO: Operatoren-Test, \n";
  cin.get();
  {
    IOBYTE_IO pio(PC_LPT1|LPT_DATA);
    pio=0x13;    OUTIO("pio=0x13: ",pio);
    ++pio;       OUTIO("++pio:    ",pio);
    --pio;       OUTIO("--pio:    ",pio);
    pio += 5;    OUTIO("pio+=5:   ",pio);
    pio -= 5;    OUTIO("pio-=5:   ",pio);
    pio *= 5;    OUTIO("pio*=5:   ",pio);
    pio /= 5;    OUTIO("pio/=5:   ",pio);
    pio = 13;    OUTIO("pio=13:   ",pio);
    pio %= 5;    OUTIO("pio%=5:   ",pio);
    ~pio;        OUTIO("~pio:     ",pio);
    pio &= 0xf0; OUTIO("pio$=0xf0:",pio);
    pio |= 0xf0; OUTIO("pio|=0xf0:",pio);
    pio ^= 0xff; OUTIO("pio^=0xff:",pio);
    pio <<= 2;   OUTIO("pio<<=2:  ",pio);
    pio >>= 2;   OUTIO("pio>>=2:  ",pio);
  }
  cout << "Erfolgreich beendet" << endl;
  return EXIT_SUCCESS;
}
