/* HC04IO3.CPP */
/*
 * Testen der Klassen IOBIT_OUT/IOBIT_IN
 * =====================================
 */
#include <portable.h>
#include <iodef.h>
#include <keyscan.h>
#include <mylib.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

#define F hex<<setw(1)<<setfill('0')
#define OUT(o,a,n) out(o,a.old(),n())
#define OUTIO(o,io) out(o,io.old(),io.val())


VOID out(CHAR* operation, UCHAR alt, UCHAR neu)
{
  cout << operation <<F<< ' ' ;
  cout << "alt:" <<F<< (INT)alt << ' '
       << "neu:" <<F<< (INT)neu << ' ' <<endl;
}

INT main(VOID)
{
  cout << endl
       << "IOBIT_OUT/IOBIT_IN: Operatoren-Test\n"
       << "Parallele Schnittstelle, Ende mit ESC"
       <<endl;

  IOBIT_IN biti(0,PC_LPT1|LPT_DATA);
  IOBIT_OUT bito(0,PC_LPT1|LPT_DATA);

  bito.set(0x55);
  cout << "Oldbyte=" <<hex<< (UINT)bito.byte() <<endl;
  cout << "Bittest IN<-OUT mit 1: <-"; cin.get();
  bito=1;  OUT("bito=1:     ",bito,biti);
  ++bito;  OUT("++bito:     ",bito,biti); bito=1;
  --bito;  OUT("--bito:     ",bito,biti); bito=1;
  ~bito;   OUT("~bito:      ",bito,biti); bito=1;
  bito&=1; OUT("bito&=1:    ",bito,biti); bito=1;
  bito&=0; OUT("bito&=0:    ",bito,biti); bito=1;
  bito|=1; OUT("bito|=1:    ",bito,biti); bito=1;
  bito|=0; OUT("bito|=0:    ",bito,biti); bito=1;
  bito^=1; OUT("bito^=1:    ",bito,biti); bito=1;
  bito^=0; OUT("bito^=0:    ",bito,biti); bito=1;
  cout << "Newbyte=" <<hex<< (UINT)bito.byte() <<endl;
  cout << "Fortsetzung IN<-OUT mit 0 <-:"; cin.get();
  cout << "Oldbyte=" <<hex<< (UINT)bito.byte() <<endl;
  bito=0;  OUT("bito=0:     ",bito,biti);
  ++bito;  OUT("++bito:     ",bito,biti); bito=0;
  --bito;  OUT("--bito:     ",bito,biti); bito=0;
  ~bito;   OUT("~bito:      ",bito,biti); bito=0;
  bito&=1; OUT("bito&=1:    ",bito,biti); bito=0;
  bito&=0; OUT("bito&=0:    ",bito,biti); bito=0;
  bito|=1; OUT("bito|=1:    ",bito,biti); bito=0;
  bito|=0; OUT("bito|=0:    ",bito,biti); bito=0;
  bito^=1; OUT("bito^=1:    ",bito,biti); bito=0;
  bito^=0; OUT("bito^=0:    ",bito,biti); bito=0;
  cout << "Newbyte=" <<hex<< (UINT)bito.byte() <<endl;
  cout << "Bittest IN <-OUT beendet" <<endl;
  cout << "Beginn IO-Test" <<endl; cin.get();
  { IOBYTE_IO par1(PC_LPT1|LPT_DATA,0x55); }
  IOBIT_IO bitio(0,PC_LPT1|LPT_DATA);
  bitio();
  cout << "Oldbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  cout << "Bittest IO mit 1: <-"; cin.get();
  cout << "Newbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  bitio=1;  OUTIO("bitio=1:     ",bitio);
  ++bitio;  OUTIO("++bitio:     ",bitio); bitio=1;
  --bitio;  OUTIO("--bitio:     ",bitio); bitio=1;
  ~bitio;   OUTIO("~bitio:      ",bitio); bitio=1;
  bitio&=1; OUTIO("bitio&=1:    ",bitio); bitio=1;
  bitio&=0; OUTIO("bitio&=0:    ",bitio); bitio=1;
  bitio|=1; OUTIO("bitio|=1:    ",bitio); bitio=1;
  bitio|=0; OUTIO("bitio|=0:    ",bitio); bitio=1;
  bitio^=1; OUTIO("bitio^=1:    ",bitio); bitio=1;
  bitio^=0; OUTIO("bitio^=0:    ",bitio); bitio=1;
  cout << "Newbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  { IOBYTE_IO par1(PC_LPT1|LPT_DATA,0x55); }
  cout << "Fortsetzung IO mit 0 <-:"; cin.get();
  cout << "Oldbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  cout << "Newbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  bitio=0;  OUTIO("bitio=0:     ",bitio);
  ++bitio;  OUTIO("++bitio:     ",bitio); bitio=0;
  --bitio;  OUTIO("--bitio:     ",bitio); bitio=0;
  ~bitio;   OUTIO("~bitio:      ",bitio); bitio=0;
  bitio&=1; OUTIO("bitio&=1:    ",bitio); bitio=0;
  bitio&=0; OUTIO("bitio&=0:    ",bitio); bitio=0;
  bitio|=1; OUTIO("bitio|=1:    ",bitio); bitio=0;
  bitio|=0; OUTIO("bitio|=0:    ",bitio); bitio=0;
  bitio^=1; OUTIO("bitio^=1:    ",bitio); bitio=0;
  bitio^=0; OUTIO("bitio^=0:    ",bitio); bitio=0;
  cout << "Newbyte=" <<hex<< (UINT)bitio.byte() <<endl;
  cout << "Bittest IO und IN<-OUT beendet,<-";
  cin.get();
  return EXIT_SUCCESS;
}
