/* HC04IO4.CPP */
/*
 * Bearbeitung einzelner Bits
 * ==========================
 */
#include <portable.h>
#include <iodef.h>
#include <keyscan.h>
#include <bios.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

INT main(VOID)
{
  cout << endl
       << "XT: Tastatur ein/ausschalten"
       << endl;

  IOBIT_IO kbdenable(7,XT_PPI_B);
  IOBYTE_IN kbd(XT_PPI_A);

  cout << "Keyboard enabled : "
       << ((kbdenable()==0)?"YES":"NO") << endl;

  if (kbdenable.val())
  {
    cout << "Keyboard should be enabled\n" << endl;
    return EXIT_FAILURE;
  }
  cout << "Temporary turning off keyboard\n" << endl
       << "Try some keys, then keyboard is turned on"
       << endl;

  kbdenable = 1; // disable keyboard

  if (kbdenable()==0)
  {
    cout << "Keyboard cannot be turned off" << endl;
    return EXIT_FAILURE;
  }

  for (INT i=0; i<32000; i++)
  {
     if (bioskey(1))
     {
       cout << "Keyboard not turned off correctly"
            << endl;
       return EXIT_FAILURE;
     }
  }
  kbdenable = 0; // enable keyboard
  cout << "Keyboard is turned on now" << endl
       << "Test again an end with ESC" << endl;
  for (;;)
  {
     kbd();
     if (kbd.val()==SCAN_ESCAPE)
       break;
     if (kbd.val()!=kbd.old())
       cout << hex << (INT)kbd.val() << ' ';
  }
  return EXIT_SUCCESS;
}
