/* HC04PA1.CPP */
/*
 * Prfen des parallelen Ports mit Teststecker
 * ===========================================
 */
#include <iodef.h>
#include <portable.h>
#include <mytypes.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

const INT NUMPORTS=3;

UINT ports[NUMPORTS] = { PC_LPT1, PC_LPT2, PC_LPT3 };
BOOL exist[NUMPORTS] = { FALSE, FALSE, FALSE };

VOID main(INT argc)
{
  cout << endl;
  cout << "PARALLEL-PORTTEST\n";
  cout << "=================\n";

  if (argc>1)
  {
    cout << "Portadressen: ";
    for (INT port=0; port<NUMPORTS; port++)
    {
      cout << hex << setw(3) << ports[port] << ", ";
    }
    cout << endl;
    cout <<
      "PORT+0                                              \n"
      "Bit      7     6     5     4     3     2     1     0\n"
      "Name    D7    D6    D5    D4    D3    D2    D1    D0\n"
      "Pin      9     8     7     6     5     4     3     2\n"
      "Logik    +     +     +     +     +     +     +     +\n"
      "E/A     IO    IO    IO    IO    IO    IO    IO    IO\n"
      "PORT+1                                              \n"
      "Bit      7     6     5     4     3     2     1     0\n"
      "Name  BUSY   ACK  PEND  SELE ERROR                  \n"
      "Pin     11    10    12    13    15                  \n"
      "Logik    +     +     +     +     +                  \n"
      "E/A      I     I(IRQ)I     I     I                  \n"
      "PORT+2                                              \n"
      "Bit      7     6     5     4     3     2     1     0\n"
      "Name                     IRQ    SI  INIT    AF STROB\n"
      "Pin                             17    16    14     1\n"
      "Logik                      +     -     +     -     +\n"
      "E/A                       RW    IO    IO    IO    IO\n"
      "if PORT+2,bit 4 == 1 --> INT=ON,                  \n"
      "Hi-to-Lo-Transition on Pin 10 causes IRQ          \n"
      "Parallel Testadapter connects \n"
      "pins 1-13,2-15,10-16,11-17,12-14 \n";
    return;
  }

  for (INT port=0; port<NUMPORTS; port++)
  {
    cout << "Port-Nr: " << port;
    cout << "\nPortadresse: "
         << hex << ports[port] << " : ";
    IOBYTE_IO lpt(ports[port]);
    cout << "Port " << port << endl;
    if (lpt.tst(cout,TRUE)==0)
    {
      exist[port]=TRUE;
    }
    else
    {
      exist[port]=FALSE;
      cout << " not";
    }
    cout << " found" << endl;
  }

  for (port=0; port<NUMPORTS; port++)
  {
    if (exist[port]==FALSE) continue;

    INT error=0;

    cout << "Testing port " << port
	 << " at " << hex << ports[port] << endl;
    cout << "Insert test plug in port " << port
	 << " press a key" << endl;
    cin.get();
    IOBIT_LOOP
      l1(ports[port]+2,0,ports[port]+1,4,FALSE);
    if (l1.tst(cout)) error++;
    IOBIT_LOOP
      l2(ports[port],0,ports[port]+1,3,TRUE);
    if (l2.tst(cout)) error++;
    IOBIT_LOOP
      l3(ports[port]+2,2,ports[port]+1,6,TRUE);
    if (l3.tst(cout)) error++;
    IOBIT_LOOP
      l4(ports[port]+2,1,ports[port]+1,5,FALSE);
    if (l4.tst(cout)) error++;
    cout << error << " errors" << endl;

    IOBIT_IO portbit(4,ports[port]+2);
    cout << "Interrupt: "
	 << ((portbit())?"ON":"OFF") << endl;
    cout << "Port ";
    if (error)
      cout << "failed";
    else
      cout << "passed";
    cout << endl;
  }
}
