/* HC04TA1E.CPP */
/*
 * Tastatur-kodes prfen, wiederverwendbarer Kode
 * ==============================================
 */
#include <bios.h>    // bioskey()
#include <iodef.h>   // PC_KBD_DATA
#include <keyscan.h> // SCAN_ESCAPE
#include <mytypes.h> // INT, UCHAR...
#include <portable.h>// IN_PORT
                     // cout, setw(), setfill()

INT cdecl kbd_read(INT mode);
VOID cdecl clear_kbdqueue(VOID);

VOID main(VOID)
{
  UCHAR key;
  cout << "Tastatur-SCAN-Codes, Ende mit ESC" << endl;
  do
  {
    key=kbd_read(0);
    if (key!=SCAN_ESCAPE)
      cout << setfill('0') << setw(2) << hex
	   << (UINT)key << ' ';
    clear_kbdqueue();
  }
  while (key!=SCAN_ESCAPE);
  cout << endl << endl;
}

/*
 * UCHAR kbd_read(INT mode)
 * ========================
 * ENTRY: mode=0 ... wait for change on kbd-port
 *        mode=1 ... immediate return
 * EXIT:  returns SCAN-code
 */

INT cdecl kbd_read(INT mode)
{
  UCHAR key;
  static UCHAR oldkey=0;

  switch (mode)
  {
  case 0:
    do
      key=IN_PORT(PC_KBD_DATA);
    while (key==oldkey);
    break;
  case 1:
    key=IN_PORT(PC_KBD_DATA);
    break;
  }
  oldkey=key;
  return key;
}

/*
 * VOID clear_kbdqueue(VOID)
 * =========================
 * clears keyboard queue
 */

VOID cdecl clear_kbdqueue(VOID)
{
  while (bioskey(1)) bioskey(0);
}
