/* HC07IV2.CPP */
/*
 * Interrupt-Service-Routine
 * =========================
 */
#include <dos.h>
#include <mytypes.h>
#define P_INT
#include <portable.h>

VOID interrupt far prt_scr(VOID)
{
  UCHAR far *bild=(UCHAR far *)MK_FP(0xb800,0);
  (*bild)++;
}

VOID main(VOID)
{
  ULONG far *ip;
  struct SREGS sr;
  ULONG alter_vektor;

  cout<< "Umlenkung eines Interruptvektors "
         "auf das eigene Programm\n";

  ip=(ULONG far *)MK_FP(0,20);
  cout<< "Alter PrintScreen-Interrupt-Vektor: "
      << hex << *ip << endl;

  disable();
  alter_vektor = *ip;
  enable();

  /* Umlenken des PrintScreen-Interrupt */
  segread(&sr);
  disable();
  *ip=(ULONG)MK_FP(sr.cs,(UINT)prt_scr);
  enable();
  cout<< "Neuer PrintScreen-Interrupt-Vektor: "
      << hex << *ip << endl;
  cout<< "Die neue Interrupt-Service-Routine "
         "verndert den Inhalt\n"
   "der Bildschirmzelle 0,0 links oben "
         "mit PRTSCR\n"
   "Jede andere Taste "
         "stellt den alten Vektor wieder her\n";

  do {} while (!kbhit()); getch();

  disable();
  *ip = alter_vektor;
  enable();

  cout<< "Wiederhergestellter alter Vektor: "
      << hex << *ip << endl;
  getch();
}
