#include <iostream.h>
#include <..\source\intvec.cpp>

volatile int got_ctrl_c = 0;

//. In this case it is the minimally simple handler.  We just note
//. that the keyboard interrupt ocurred.
void __interrupt __far __cdecl ctrl_c_handler(void)
{
    ++got_ctrl_c;   // just note that one occurred
}

void main()
{

//. Declare a zIntVector on vector 0x23, to use the handler defined
//. above, with immediate installation.

    zIntVector ctrlc(0x23,ctrl_c_handler);
    char buffer[80];
    
    cout << "Enter a string possibly including ^C: ";
    cout.flush();
    cin >> buffer;
    cout << "\n\n";
    if (got_ctrl_c)
        cout << "There was " << got_ctrl_c << " ^C in the text you entered\n"; 
    cout.flush();
    getch();
}
