/* HC08IB0.C */
/*
 * Testen von BIOS-Interrupts
 * ==========================
 */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <mytypes.h>

VOID main(VOID)
{
  union REGS r;
  CHAR temp[20];
  INT lfw;

  printf("Testen einiger BIOS-Interrupts\n");
  printf("Speicherkapazitt feststellen, "
         "Interrupt 0x12\n");
  int86(0x12,&r,&r);
  printf("Der Speicher ist %u kByte gro\n", r.x.ax);
  printf("Ausstattung feststellen, Interrupt 0x11\n");
  int86(0x11,&r,&r);
  printf
    ("Bitkombination gelesen : %16x HEX\n",r.x.ax);
  printf
    ("Bitkombination gelesen : %16s BIN\n",
    itoa(r.x.ax,temp,2));
  printf
    ("Bitkombination         : ddsgsssDffvvrr7f\n");
  printf
    ("Laufwerk               : %i\n",
    r.x.ax & 0x0001);
  printf
    ("Arithmetik-Prozessor   : %s\n",
    (r.x.ax & 0x0002) ? "nein" : "ja");
  printf
    ("RAM auf Hauptplatine   : %i x16k\n",
    (r.x.ax & 0x000C)>>2 );
  printf("Bildschirmmodus        : ");
  switch ((r.x.ax&0x0030)>>4)
  {
  case 0: printf("unklar\n"); break;
  case 1: printf("40x25 Farbe\n"); break;
  case 2: printf("80x25 Farbe\n"); break;
  case 3: printf("80x25 s/w\n"); break;
  }
  printf
    ("Anzahl der Laufwerke   : %i\n",
    (r.x.ax & 0x00C0)>>6);
  printf
    ("DMA mglich            : %s\n",
    (r.x.ax & 0x0100) ? "nein" : "ja");
  printf
    ("Anzahl der RS232-Karten: %i\n",
    (r.x.ax & 0x0E00)>>9);
  printf
    ("Game-Port vorhanden    : %s\n",
    (r.x.ax & 0x1000) ? "nein" : "ja");
  printf
    ("Serieller Drucker      : %s\n",
    (r.x.ax & 0x2000) ? "nein" : "ja");
  printf
    ("Druckeranzahl          : %i\n\n",
    (r.x.ax & 0xC000)>>12);
  printf("Laufwerke feststellen\n");
  for (lfw=0; lfw<5; lfw++)
  {
    r.h.ah=0x15;
    if (lfw<2) r.h.dl=lfw;
    else r.h.dl=lfw+0x80-2;
    int86(0x13,&r,&r);
    printf("Laufwerk %i: Laufwerkstyp :",lfw);
    switch(r.h.ah)
    {
    case 0:
      printf("kein Laufwerk\n");
      break;
    case 1:
      printf("Floppy ohne Diskettenwechselsignal\n");
      break;
    case 2:
      printf("Floppy mit Diskettenwechselsignal\n");
      break;
    case 3:
      printf("Festplatte\n");
      break;
    }
    if (r.h.ah==3) /* Festplatte */
      printf("Anzahl der 512-byte-Sektoren: %16lu\n",
             r.x.cx*65536L+r.x.dx);
  }
  printf("\n");

  printf("Aktuelle Laufwerksparameter\n");
  for (lfw=0; lfw<5; lfw++)
  {
    r.h.ah=0x08;
    if (lfw<2) r.h.dl=lfw;
    else r.h.dl=lfw+0x80-2;
    int86(0x13,&r,&r);
    printf
      ("Laufwerk: "
       "Status(HEX)/Laufwerke/Seitenzahl/"
       "Sektoren/Spuren\n");
    printf
      ("%d:%x/%d/%d/%d/%d\n",
       lfw,r.h.ah,r.h.dl,r.h.dh,r.h.cl,r.h.ch);
  }
  printf("\n");
  r.h.ah = 0x0f;
  int86(0x10,&r,&r);
  printf("Bildschirmmodus : %x HEX\n",r.h.al);
  printf("Bildschirmseite : %d\n",r.h.bh);
  printf("Zeichen/Zeile   : %d\n",r.h.ah);
  printf("Mit TASTE lassen wir einen Teil "
         "des Bildschirms nach oben rollen\n");
  printf("und verndern dabei das Attribut\n");
  getch();
  r.h.ah=0x06;
  r.h.al=4;
  r.h.bh = 0x71;
  r.h.ch = 5;
  r.h.cl = 10;
  r.h.dh = 15;
  r.h.dl = 40;
  int86(0x10,&r,&r);
  getch();
  printf("\nUhr ablesen und Tastatur prfen\n");
  do
  {
    r.h.ah=0x02;
    int86(0x1a,&r,&r);
    printf("%x:%x:%x ",r.h.ch,r.h.cl,r.h.dh);
    delay(1000);
    r.h.ah=1;
    int86(0x16,&r,&r);
  }
  while(r.x.flags & 0x0040);
}

