/* HC08ID1.C */
/*
 * Demonstration des INT-21h
 * =========================
 */
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <mytypes.h>
#include <portable.h>

INT main(VOID)
{
  union REGS r;
  struct SREGS s;
  UCHAR sector[512];
  INT i;
  CHAR dateiname[80]="TEST.TXT";
  UINT dateinummer;
  CHAR testdaten[80]="TESTDATEN\n";
  UCHAR far * cp;
  UINT far * up;
  UCHAR len;

  printf("MSDOS ist in der Hauptsache ein Platten- und "
	 "Speicherverwaltungsprogramm\n");
  printf("Holen wir die wichtigsten Diskettendaten "
         "aus dem URLADER:\n");
  do
  {
    r.h.ah=0x02;
    r.h.al=1;
    r.h.ch=0;
    r.h.cl=1;
    r.h.dh=0;
    r.h.dl=0;
    segread(&s);
    s.es=s.ds;
    r.x.bx=(UINT)&sector[0];
    int86x(0x13,&r,&r,&s);
    if (r.h.ah)
    {
      printf("Fehlercode: %x\n",r.h.ah);
      if (r.h.ah==6) printf("Diskette entfernt\n");
    }
  }
  while (r.h.ah);
  {
    printf("Systembezeichnung         :");
    for (i=3; i<12; i++)
      printf("%c",sector[i]); printf("\n");
    printf("Bytes/Sektor              :%i\n",
           sector[11]+sector[12]*256);
    printf("Sektoren/Cluster          :%i\n",
           sector[13]);
    printf("Reservierte Anfangssekt.  :%i\n",
           sector[14]+sector[15]*256);
    printf("Anzahl der FAT-Kopien     :%i\n",
           sector[16]);
    printf("Stammverzeichniseintrge  :%i\n",
           sector[17]+sector[18]*256);
    printf("Sektoren/Disk             :%i\n",
           sector[19]+sector[20]*256);
    printf("Formatkennzeichen         :%2x\n",
           sector[21]);
    printf("ff:D-8,fe:S-8,fd:d9,fc:s9\n");
    printf("Sektoren/FAT              :%i\n",
           sector[22]+sector[23]*256);
    printf("Sektoren/Spur             :%i\n",
           sector[24]+sector[25]*256);
    printf("Kopfzahl                  :%i\n",
           sector[26]+sector[27]*256);
    printf("Reservierte Sektoren      :%i\n",
           sector[28]+sector[29]*256);
  }
  printf("Jetzt stellen wir fest, "
         "was auf dem Laufwerk noch frei ist:\n");
  r.h.ah=0x36;
  r.h.dl=0; /* Laufwerk A */
  intdos(&r,&r);
  printf("Sektoren/Cluster  : %i\n",r.x.ax);
  printf("Verfgbare Cluster: %i\n",r.x.bx);
  printf("Bytes/Sektor      : %i\n",r.x.cx);
  printf("Cluster Gesamt    : %i\n",r.x.dx);

  printf("\nJetzt legen wir auf dem Laufwerk A "
         "eine Datei an\n");
  r.h.ah=0x3c;
  r.x.cx=0;
  r.x.dx=(UINT)dateiname;
  segread(&s);
  intdosx(&r,&r,&s);
  if (r.x.cflag)
  {
    printf("Fehler: %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  dateinummer=r.x.ax;
  printf("Dateinummer: %i\n",dateinummer);

  printf("Daten schreiben %s\n",testdaten);
  r.h.ah=0x40;
  r.x.bx=dateinummer;
  r.x.cx=strlen(testdaten);
  r.x.dx=(UINT)testdaten;
  segread(&s);
  intdosx(&r,&r,&s);
  if (r.x.cflag)
  {
    printf("Fehler: %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  printf("Anzahl der geschriebenen Datenbytes: %x\n",
          r.x.ax);
  printf("Datei schlieen\n");
  r.h.ah=0x3e;
  r.x.bx=dateinummer;
  intdos(&r,&r);
  if (r.x.cflag)
  {
    printf("Fehlercode : %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  printf("Hurra\n");

  printf("\nJetzt lesen wir aus dieser Datei\n");
  r.h.ah=0x3d;
  r.h.al=0; /* Lesen */
  r.x.dx=(UINT)dateiname;
  segread(&s);
  intdosx(&r,&r,&s);
  if (r.x.cflag)
  {
    printf("Fehler: %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  dateinummer=r.x.ax;
  printf("Dateinummer: %i\n",dateinummer);

  printf("Daten lesen\n");
  r.h.ah=0x3f;
  r.x.bx=dateinummer;
  r.x.cx=100;
  r.x.dx=(UINT)testdaten;
  segread(&s);
  intdosx(&r,&r,&s);
  if (r.x.cflag)
  {
    printf("Fehler: %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  printf("Anzahl der gelesenen Datenbytes: %x: %s",
         r.x.ax,testdaten);
  printf("Datei schlieen\n");
  r.h.ah=0x3e;
  r.x.bx=dateinummer;
  intdos(&r,&r);
  if (r.x.cflag)
  {
    printf("Fehlercode : %x\n",r.x.ax);
    return EXIT_FAILURE;
  }
  printf("Hurra\n");

  printf("Was kann man ber "
         "das aktuell ausgefhrte Programm sagen?\n");
  r.h.ah=0x62;
  intdos(&r,&r);
  segread(&s);
  printf("Das aktuelle Datensegment ist: %x\n",s.ds);
  printf("Das aktuelle Codesegment ist : %x\n",s.cs);
  printf("Das PSP-Segment ist          : %x\n",r.x.bx);
  printf("Die wichtigsten PSP-Informationen:\n");
  up=(UINT far *)MK_FP(r.x.bx,0x02);
  printf("Speicherende bei : %x\n",*up);
  cp=(UCHAR far *)MK_FP(r.x.bx,0x80);
  len = *cp;
  printf("Parameterlnge: %x\n",*cp);
  printf("Parameter: ");
  for (i=0; i<len; i++)
  {
    cp++;
    printf("%c",*cp);
  }
  up = (UINT far *)MK_FP(r.x.bx,0x2c);
  printf("\nSegmentadresse der Umgebung: %x\n",*up);
  printf("Umgebungsvariable:\n");
  cp = (UCHAR far *)MK_FP(*up,0);
  do
  {
    if (*cp)
      printf("%c",*cp);
    else
      printf(" ");
    cp++;
  }
  while (*cp | *(cp+1));
  printf("\n");
  return EXIT_SUCCESS;
}
