/* HC09SE1.C */
/* 
 * Serielle Schnittstelle via INT14h
 * =================================
 */
#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <mytypes.h>

VOID main(VOID)
{
  union REGS r;
  UINT port = 0; /* COM1 */

  r.h.ah=0x00; /* INITIALISIEREN */
  /* 110 BAUD, keine Paritt, 1 STOP, 8 Bits */
  r.h.al=0x03;
  r.x.dx=port;
  int86(0x14,&r,&r);
  printf("COM%i initialisiert, Status: %4x\n",
    port+1,r.h.ah);
  printf("Beachten Sie, "
    "da an der Schnittstelle die Leitungen\n"
         "2 - 3       TX, RX\n"
         "4 - 5       RTS, CTS\n"
         "6 - 8 - 20  DSR, DCD, DTR\n"
         "verbunden werden mssen!\n");

  printf("Zeichens von Tastatur an COM%i senden, "
    "Ende mit ESC\n",port+1);
  for(;;)
  {
    UINT c = bioskey(0x01);
    if (c)
    {
      c = bioskey(0x00);
      if ((c&0xff) == 0x1b) break;
      // Senden
      r.h.ah=0x01;
      r.h.al=c;
      r.x.dx=port;
      int86(0x14,&r,&r);
      printf("\nGesendet: %c; Status: %4x\n",c,r.h.ah);
    }
    r.h.ah=0x03; /* STATUS */
    r.x.dx=port;
    int86(0x14,&r,&r);
    if (r.h.ah & 0x01)
    {
      r.h.ah=0x02; /* EMPFANG */
      r.x.dx=port;
      int86(0x14,&r,&r);
      printf("Empfangen: %c\n",r.h.al);
    }
  }
}

