/* HC06KB8.CPP */
/*
 * Tastenrckgabefunktion
 * ======================
 */
#include <bios.h>
#include <portable.h>
#include <keybios.hpp>

BOOL putback(UINT c)
{
  BIOS<UINT> tail(keybd_q_tail);
  KBDQUEUE q(tail());
  if (q.last()) return FALSE;
  q=c;
  q.next();
  tail=q.off();
  return TRUE;
}

VOID main(VOID)
{
  BIOS<UINT> head(keybd_q_head);
  BIOS<UINT> tail(keybd_q_tail);
  cout << endl;
  cout << "Tastenrckgabefunktion" << endl
       << "======================" << endl
       << "End with CTRL-BREAK" << endl << endl;

  KBDQUEUE q;

  cout << "Tastenwiederholung, Ende mit ESC\n";
  for (;;)
  {
    if (bioskey(1))
    {
      UINT c=bioskey(0);
      if (c==0x011b) break;
      q.set(head());
      q.prev();
      head=q.off();
      if (bioskey(1))
	cout << "Successfully echoed: "
	     << hex << bioskey(0) << endl;
    }
  }
  cout << "Tastensimulation\n";
  q.set(head());
  for (INT i=0; i<10; i++)
  {
    q.prev();
    q=i+0x30;
  }
  head=q.off();
  while (bioskey(1))
    cout << hex << (CHAR)(0xff&bioskey(0));
  cout << endl;
  cout << "Tastensimulation mit putback\n";
  for (i=0; i<20; i++)
    if (!putback('A'+i)) break;
  while (bioskey(1))
    cout << hex << (CHAR)(0xff&bioskey(0));
  cout << endl;
  cin.get();
}
