#include <intvec.h>

zIntVector::zIntVector()
{                       
    _state = VOID;  
}

zIntVector::zIntVector(unsigned v, ihandler fp)
{
    _state = VOID;
    install(v,fp);
} 

int zIntVector::install(unsigned vect, ihandler funcptr)
{
    if (_state & INITED) 
    {   // use newhandler to update
        err = IV_ALREADY;
        return IV_ALREADY;
    }
    _state |= INITED;        // set initialised flag
    vector = vect;  
    oldserver = getvect(vector);
    intserver = funcptr; 
    setvect(vect,funcptr); 
    _state |= ACTIVE;    // success - new server now in charge
    err = IV_OK;
    return IV_OK;
}

int zIntVector::suspend()
{
    if (!(_state & ACTIVE)) 
    {
        err = IV_NOTACTIVE;
        return IV_NOTACTIVE;
    }
    setvect(vector,oldserver);
    err = 0;
    return IV_OK;
}

int zIntVector::reinstate()
{
    if (_state != INITED) 
    {  // can only reinstate if inited and not active
        err = (_state & ACTIVE)? IV_ALREADY: IV_NOCANDO;
        return err;
    }
    setvect(vector,intserver); 
    _state |= ACTIVE;
    return IV_OK;
}

int zIntVector::newhandler(ihandler funcptr)
{
    if (!(_state & INITED)) 
    { // not initialised, so vector unknown
        err = IV_NOCANDO;
        return IV_NOCANDO;
    }
    if (_state & ACTIVE) 
    { // active, so put original handler back first
        oldserver = intserver;
    }
    _state &= ~ACTIVE;
    intserver = funcptr;
    setvect(vector,funcptr); 
    _state |= ACTIVE;        // new handler
    return IV_OK;
}

