/* IO.CPP */

#include <string.h>
#include <ctype.h>
#define P_STREAM
#include <portable.h>
#include <ioc.h>
#include <mylib.h>
#ifndef MYLIB
#include "..\source\is.cpp"
#endif

BOOL first_IO=TRUE;

PORTUSAGE IO::portusage[PC_MAXPORTS];

IO::IO(INT a, DIRECTION dir, BOOL c)
{
  if (first_IO)
  {
    first_IO=FALSE;
    for (INT i=0; i<PC_MAXPORTS; i++)
      IO::portusage[i].in=0;
      IO::portusage[i].out=0;
  }
  Check=c;
  Adr=a%0x400;
  if (Check)
  {
    switch (dir)
    {
    case IN:
      if (portusage[Adr].in) goto error;
      portusage[Adr].in=0xff;
      break;
    case OUT:
      if (portusage[Adr].out) goto error;
      portusage[Adr].out=0xff;
      break;
    case IN_OUT:
      if (portusage[Adr].in || portusage[Adr].out)
	goto error;
      portusage[Adr].in=0xff;
      portusage[Adr].out=0xff;
      break;
    error:
      cerr << "\nBYTE-Port " << hex << Adr
	   << " already in use" << endl;
      exit(EXIT_FAILURE);
    }
  }
  Io=dir;
  Port=BYTE;
  Disp=IO_DISP_BYTE;
}

IO::IO(UCHAR n, INT a, DIRECTION dir, BOOL c)
{
  if (first_IO)
  {
    first_IO=FALSE;
    for (INT i=0; i<PC_MAXPORTS; i++)
      IO::portusage[i].in=0;
      IO::portusage[i].out=0;
  }
  Adr=a%0x400;
  Adr=Adr+(n>>4);
  Nr=(n&0x0f);
  Check=c;
  if (Check)
  {
    switch (dir)
    {
    case IN:
      if (BITTST(IO::portusage[Adr].in,Nr))
	goto error;
      BITSET(portusage[Adr].in,Nr);
      break;
    case OUT:
      if (BITTST(IO::portusage[Adr].out,Nr))
	goto error;
      BITSET(portusage[Adr].out,Nr);
      break;
    case IN_OUT:
      if (BITTST(IO::portusage[Adr].in,Nr) ||
	  BITTST(IO::portusage[Adr].out,Nr)
	 )
	goto error;
      BITSET(portusage[Adr].in,Nr);
      BITSET(portusage[Adr].out,Nr);
      break;
    error:
      cerr << "\nBIT-Port " << hex << Adr
	   << ", BIT-Nr " << (INT)Nr
	   << " already in use" << endl;
      exit(EXIT_FAILURE);
    }
  }
  Io=dir;
  Port=BIT;
  Disp=IO_DISP_BIT;
}

IO::~IO()
{
  if (Check)
    switch (Port)
    {
    case BYTE:
      switch (Io)
      {
      case IN:
	IO::portusage[Adr].in=0;
	break;
      case OUT:
	IO::portusage[Adr].out=0;
	break;
      case IN_OUT:
	IO::portusage[Adr].in=0;
	IO::portusage[Adr].out=0;
	break;
      }
      break;
    case BIT:
      switch (Io)
      {
      case IN:
	BITCLR(IO::portusage[Adr].in,Nr);
	break;
      case OUT:
	BITCLR(IO::portusage[Adr].out,Nr);
	break;
      case IN_OUT:
	BITCLR(IO::portusage[Adr].in,Nr);
	BITCLR(IO::portusage[Adr].out,Nr);
	break;
      }
      break;
    }
}

/* chk
   ===
   Test Input-String for IOBYTE-Format aaa[:|=][hh]

   INPUT: s, disp   OUTPUT: adr, io, val, ERR_BYTE
   disp: TRUE     output comments on cerr
   disp: FALSE    no comments
   s: aaa         adr=aaa  io=IN       val=0
   s: aaa:        adr=aaa  io=OUT      val=0
   s: aaa=        adr=aaa  io=IN_OUT   val=0
   s: aaa:hh      adr=aaa  io=OUT      val=hh
   s: aaa=hh      adr=aaa  io=IN_OUT   val=hh
*/
IO_ERR chk(CHAR *s, INT& adr, DIRECTION& io, UCHAR& val, BOOL disp)
{
  INT adr_temp;
  UCHAR val_temp;
  DIRECTION io_temp;

  INT ArgumentLaenge=strlen(s);

  switch (ArgumentLaenge)
  {
  case 4:
  case 6:
    if (!((s[3]==TRENN_OUT) || (s[3]==TRENN_IO)))
    {
      if (disp)
	cerr << "\nFehlerhaftes Trennzeichen in: " << s;
      return IO_ERRS_IOTYP;
    }
    switch (s[3])
    {
    case TRENN_OUT:
      io_temp=OUT;
      break;
    case TRENN_IO:
      io_temp=IN_OUT;
      break;
    default:
      io_temp=IN;
      break;
    }
    s[3]=0;
    break;
  case 3:
    io_temp=IN;
    break;
  default:
    if (disp) cerr << "\nFalsche Lnge von: " << s;
    return IO_ERRS_LEN;
  }

  if (ishex(s)) // Adresse ueberpruefen
  {
    adr_temp = (INT)strtol(s,NULL,16);
    if (adr_temp>=PC_MAXPORTS) return IO_ERR_ADDR;
  }
  else
  {
    if (disp)
      cerr << "\nFalsches Zeichen in Adressfeld: " << s;
    return IO_ERRS_ADDR;
  }

  if (ArgumentLaenge==6)
  {
    if ( ishex(&s[4]) )
    {
      val_temp = (INT)strtol(&s[4],NULL,16);
    }
    else
    {
      if (disp)
	cerr << "\nFalsches Zeichen in Datenfeld: " << s;
      return IO_ERRS_DAT;
    }
  }
  adr = adr_temp;
  val = val_temp;
  io  = io_temp;
  return IO_NOERROR;
}

/* chkb
   ====
   Test Input-String for IOBIT-Format aaa#n[:|=][hh]

   INPUT: s, disp   OUTPUT: adr, io, val, ERR_BYTE
   disp: TRUE     output comments on cerr
   disp: FALSE    no comments
   s: aaa#n         adr=aaa  bitn=n  io=IN       val=0
   s: aaa#n:        adr=aaa  bitn=n  io=OUT      val=0
   s: aaa#n=        adr=aaa  bitn=n  io=IN_OUT   val=0
   s: aaa#n:hh      adr=aaa  bitn=n  io=OUT      val=hh
   s: aaa#n=hh      adr=aaa  bitn=n  io=IN_OUT   val=hh
*/
IO_ERR chkb(CHAR *s, CHAR& bitn, INT& adr, DIRECTION& io, UCHAR& val, BOOL disp)
{
  INT adr_temp;
  UCHAR val_temp;
  DIRECTION io_temp;
  CHAR bitn_temp;

  INT ArgumentLaenge=strlen(s);

  switch (ArgumentLaenge)
  {
  case 6:
  case 8:
    if (!s[3]==TRENN_BIT)
    {
      if (disp) cerr << "\nFehlerhaftes Trennzeichen in: " << s;
      return IO_ERRS_IOTYP;
    }
    break;
  default:
    if (disp) cerr << "\nFalsche Lnge von: " << s;
    return IO_ERRS_LEN;
  }
  bitn_temp = s[4]-'0';
  if (!isdigit(bitn_temp))
  {
    if (disp) cerr << "\nFalsche Lnge von: " << s;
    return IO_ERRS_BITN;
  }
  strcpy(&s[3],&s[5]); // delete bitnumber and get IOBYTE-Format
  IO_ERR e=chk(s, adr_temp, io_temp, val_temp, disp);
  if (e!=IO_NOERROR)
  {
    return e;
  }
  adr = adr_temp;
  val = val_temp;
  io  = io_temp;
  bitn = bitn_temp;
  return IO_NOERROR;
}

ostream& operator << (ostream& o, IO& iob)
{
  switch (iob.Disp)
  {
  case IO_DISP_NONE:
    return o;
  case IO_DISP_BOTH:
  case IO_DISP_BIT:
  case IO_DISP_BYTE:
    break;
  }
  switch (iob.port())
  {
  case BYTE:
    break;
  case BIT:
      o << (CHAR)(iob.nr()+'0') << ':';
  }

  o << setw(3) << setfill('0') << hex << iob.adr();

  switch (iob.io())
  {
  case IN:
    o << DISP_IN;
    break;
  case OUT:
    o << DISP_OUT;
    break;
  case IN_OUT:
    o << DISP_IO;
    break;
  };

  switch (iob.Disp)
  {
  case IO_DISP_BIT:
  case IO_DISP_BOTH:
    o << (CHAR)(iob.bit()+'0');
    break;
  }
  switch (iob.Disp)
  {
  case IO_DISP_BOTH:
    o << ':';
    break;
  }
  switch (iob.Disp)
  {
  case IO_DISP_BOTH:
  case IO_DISP_BYTE:
    o << setw(2) << setfill('0') << hex << (INT)iob.val();
    break;
  }
  return o;
}

UCHAR IOBYTE_IN::get_c()
{
  do
    Val=IN_PORT(Adr);
  while (Old==Val);
  Old=Val;
  return Val;
}

IO_ERR IOBYTE_IO::tst(ostream& o, BOOL t)
{
  IO_ERR error=IO_NOERROR;
  operator = (0xff);
  if (operator()()!=((t)?0xff:0x00))
  {
    if (o) o << "ERR1";
    error=IO_ERR1;
  }
  operator = (0x00);
  if (operator()()!=((t)?0x00:0xff))
  {
    if (o) o << "ERR0";
    error=IO_ERR0;
  }
  if (error==IO_NOERROR)
  {
    if (o) o << "OK";
  }
  if (o) o << endl;
  return error;
}

UCHAR IOBIT_IN::get_c()
{
  do
    Val=IN_PORT(Adr);
  while (BITTST(Old,Nr)==BITTST(Val,Nr));
  Old=Val;
  return BITTST(Val,Nr);
}

IO_ERR IOBIT_IO::tst(ostream& o, BOOL t)
{
  IO_ERR error=IO_NOERROR;
  if (o) o << "Bit:" << hex << (INT)Nr << ':' << Adr << ' ';
  operator = (1);
  if (operator()()!=((t)?1:0))
  {
    if (o) o << "ERR1";
    error=IO_ERR1;
  }
  operator = (0);
  if (operator()()!=((t)?0:1))
  {
    if (o) o << "ERR0";
    error=IO_ERR0;
  }
  if (error==IO_NOERROR)
  {
    if (o) o << "OK";
  }
  if (o) o << endl;
  return error;
}

INT IOBIT_LOOP::tst(ostream& o)
{
  INT error=0;
  UCHAR a;

  tx->operator = (1);
  a=rx->operator()();
  if (o)
    o << "Testing " << *tx << (polarity?" == ":" != ") << *rx;
  if (polarity?a==0:a==1)
  {
    if (o) o << "  << ERR";
    error++;
  }
  if (o) o << endl;
  tx->operator = (0);
  a=rx->operator()();
  if (o) o << "Testing " << *tx << (polarity?" == ":" != ") << *rx;
  if (polarity?a==1:a==0)
  {
    if (o) o << "  << ERR";
    error++;
  }
  if (o) o << endl;
  return error;
}

