/* KEYBIOS.CPP */

#include <mem.h>
#include <constream.h>
#include <keybios.h>
#ifdef MYHISTORY
#include "..\source\myhist.cpp"
#endif

KBD::KBD()
{
  head = new BIOS<UINT>(keybd_q_head);
  tail = new BIOS<UINT>(keybd_q_tail);
  alt = new BIOS<UCHAR>(keybd_alt_num);
  brk = new BIOS<UCHAR>(keybd_break);
  flag1 = new BIOS<UCHAR>(keybd_flags_1);
  flag2 = new BIOS<UCHAR>(keybd_flags_2);
  flag3 = new BIOS<UCHAR>(keybd_flags_3);
  flag4 = new BIOS<UCHAR>(keybd_flags_4);
#ifdef MYHISTORY
  history = new KBDHISTORY;
#else
  history = new BI_QueueAsVector<KBDSTATUS>(100);
#endif

  q = new KBDQUEUE;

  Last.head=head->operator()();
  Last.tail=tail->operator()();
  Last.alt=alt->operator()();
  Last.brk=brk->operator()();
  Last.flag1=flag1->operator()();
  Last.flag2=flag2->operator()();
  Last.flag3=flag3->operator()();
  Last.flag4=flag4->operator()();

  memcpy(&Status,&Last,sizeof(KBDSTATUS));

  Change=FALSE;
}

BOOL KBD::put()
{
  // store last status
  memcpy(&Last,&Status,sizeof(KBDSTATUS));
  // calculate new status
  if (head->operator()()==tail->operator()())
    Status.key=0;
  else
  {
    (*q) = tail->operator()();
    q->prev();
    Status.key=q->operator()();
  }
  Status.head=head->operator()();
  Status.tail=tail->operator()();
  Status.alt=alt->operator()();
  Status.brk=brk->operator()();
  Status.flag1=flag1->operator()();
  Status.flag2=flag2->operator()();
  Status.flag3=flag3->operator()();
  Status.flag4=flag4->operator()();
  // changed ?
  if ( memcmp(&Last,&Status,sizeof(KBDSTATUS))==0 )
    Change = FALSE;
  else
    Change = TRUE;
  if (Change) history->put(Status);
  return Change;
}

KBDSTATUS *KBD::get ()
{
static KBDSTATUS s;
  if (history->isEmpty())
    return NULL;
  else
  {
    s = history->get();
    return &s;
  }
}

inline KBDSTATUS *KBD::operator () ()
{
  if (Change)
    return &Status;
  else
    return NULL;
}

VOID KBD::out(KBDSTATUS *s)
{
  cout << setw(4) << hex << s->head << ':';
  cout << setw(4) << hex << s->tail << "::";
  cout << setw(4) << hex << s->key << ":";
  cout << setw(2) << hex << (UINT)s->alt << ":";
  cout << setw(2) << hex << (UINT)s->brk << ":";
  cout << setw(2) << hex << (UINT)s->flag1 << ':';
  cout << setw(2) << hex << (UINT)s->flag2 << ':';
  cout << setw(2) << hex << (UINT)s->flag3 << ':';
  cout << setw(2) << hex << (UINT)s->flag4 << ':';
  cout << endl;
}

VOID KBD::out_history ()
{
  KBDSTATUS *s;
  for (;;)
  {
    s=get();
    if (s==NULL) break;
    out(s);
  }
}
