
#define P_IO         //IN_PORT
#include <portable.h>
#include <iodef.h>   // PC_IO_COM1
#include <mytypes.h> // INT, UCHAR...

/*
 * UCHAR mouse_read(INT port, INT mode)
 * ========================
 * ENTRY: mode=0 ... wait for change on mouse-port
 *        mode=1 ... return with actual SCAN-code
 *        port=1 ... COM1, port=2 ... COM2
 * EXIT:  returns MOUSE-code
 */

INT mouse_read(INT port, INT mode)
{
  UCHAR mouse;
  static UCHAR oldmouse=0;
  INT adr = PC_COM1;
  adr = (port==2)?PC_COM2:PC_COM1;

  switch (mode)
  {
  case 0:
    do
      mouse=IN_PORT(adr);
    while (mouse==oldmouse);
    break;
  case 1:
    mouse=IN_PORT(adr);
    break;
  }
  oldmouse=mouse;
  return mouse;
}

