#include <dos.h>
#include <iodef.h>
#include <mylib.h> 
#define P_INT
#define P_IO
#include <portable.h>

VOID spk_on(VOID)
{
  UCHAR c = IN_PORT(0x61);
  c |= 2;
  OUT_PORT(0x61,c);
}

VOID spk_off(VOID)
{
  UCHAR c = IN_PORT(0x61);
  c &= ~2;
  OUT_PORT(0x61,c);
}

VOID spk_toggle(VOID)
{
  UCHAR value=IN_PORT(0x61);
  value ^= 2;
  OUT_PORT(0x61,value);
}

VOID par_toggle(VOID)
{
  UCHAR value=IN_PORT(0x378);
  value ^= 1;
  OUT_PORT(0x378,value);
}

VOID tim2_on(VOID)
{
  UCHAR c = IN_PORT(0x61);
  c |= 1;
  OUT_PORT(0x61,c);
}

VOID tim2_off(VOID)
{
  UCHAR c = IN_PORT(0x61);
  c &= ~1;
  OUT_PORT(0x61,c);
}

VOID tim2_init(VOID)
{
  OUT_PORT(PC_TIM | TIM_CTL,0xb6);
  OUT_PORT(PC_TIM | TIM_CH2,0xa8); /* Zeitkonstante niederwertiger Teil */
  OUT_PORT(PC_TIM | TIM_CH2,0x04); /* Zeitkonstante hherwertiger Teil */
}

VOID tim2_set(UINT count)
{
  OUT_PORT(PC_TIM | TIM_CTL,0xb6);
  OUT_PORT(PC_TIM | TIM_CH2,(UCHAR)count);      /* niederwertiger Teil */
  OUT_PORT(PC_TIM | TIM_CH2,(UCHAR)(count>>8)); /* hherwertiger Teil */
}

UINT tim2_read(VOID)
{
  UINT h,l;
  l=IN_PORT(PC_TIM | TIM_CH2);
  h=IN_PORT(PC_TIM | TIM_CH2);
  return ((h<<8)+l);
}

VOID tim2_waitus(UINT time)
{
  UINT ende=0xffff-time;

  disable();
  tim2_on();
  tim2_set(0);

  do
  {
  }
  while (tim2_read()>ende);

  tim2_off();
  enable();
}

VOID tim2_waitms(UINT time)
{
  disable();

  do
  {
    tim2_waitus(1000);
  }
  while (time--);

  enable();
}

VOID tim2_waits(UINT time)
{
  disable();

  do
  {
    tim2_waitms(1000);
  }
  while (time--);

  enable();
}

VOID soundf(FLOAT frequenz)
{
  UINT periode = (UINT)(1190000.0/frequenz);
  tim2_set(periode);
  spk_on();
  tim2_on();
}

VOID nosoundf(VOID)
{
  spk_off();
  tim2_off();
  tim2_init();
}

VOID soundf1(FLOAT frequenz, UINT dauer)
{
  soundf(frequenz);
  delay(dauer);
  nosoundf();
}


FLOAT freq_tab[] =
{
  130.8F,  /*        C          0  */
  138.6F,  /*   Db        C#    1  */
  146.8F,  /*        D          2  */
  155.6F,  /*   Eb        D#    3  */
  164.8F,  /*        E          4  */
  174.6F,  /*        F          5  */
  185.0F,  /*   Gb        F#    6  */
  196.0F,  /*        G          7  */
  207.7F,  /*   Ab        G#    8  */
  220.0F,  /*        A          9  */
  233.1F,  /*   Hb        A#    10 */
  246.9F,  /*        H          11 */
  261.7F,  /*        c          0 */
  277.2F,  /*   db        c#    */
  293.7F,  /*        d          */
  311.1F,  /*   eb        d#    */
  329.6F,  /*        e          */
  349.2F,  /*        f          */
  370.0F,  /*   gb        f#    */
  392.0F,  /*        g          */
  415.3F,  /*   ab        g#    */
  440.0F,  /*        a          */
  466.2F,  /*   hb        a#    */
  493.9F,  /*        h          */
  523.3F,  /*        c1         */
  0.0F,
  0.0F
};


