
#include <string.h>
#include <ctype.h>
#include <mylib.h>

VOID putstr(CHAR * str)
{
  CHAR * p=str;
  while(*p)
  {
    putchar(*p);
    p++;
  }
}

INT convert_string(CHAR *d, CHAR *s)
{
  // copy strings, source s, destination d

  // valid rules:
  // \xhh ... \x flags hexadezimal digit hh
  // \\   ... backslash

  // returns: 0 error, 1 error free

  static const CHAR hexchars[]="0123456789ABCDEFabcdef";

  CHAR * sp=s;   // pointer to source
  CHAR * dp=d;   // pointer to destination
  INT state=0;   // 0 normal, 1: \, 2: \x

  if (*s==0)  // nothing to copy
  {
    *d=0;
    return 1;
  }

  while (*sp)
  {
    switch (state)
    {
    case 0: // normal
      switch (*sp)
      {
      case '\\':
	state++;
	sp++;
	break;
      default:
	*dp=*sp;
	sp++;
	dp++;
	break;
      }
      break;
    case 1: // backslash found
      switch (*sp)
      {
      case '\\': // second backslash follows
	*dp=*sp;
	dp++;
	sp++;
	state--;
	break;
      case 'x':
      case 'X':
	state++;
	sp++;
	break;
      default:
	return 0; // Error-Condition
      }
    case 2: // \x or \X found
      *sp=toupper(*sp);
      *(sp+1)=toupper(*(sp+1));
      if (strchr(hexchars,*sp) && strchr(hexchars,*(sp+1)))
      {
	CHAR temp[3]; temp[0]=*sp; temp[1]=0;
	*dp=strcspn(hexchars,temp)*16;
	sp++;
	temp[0]=*sp;
	*dp=*dp+strcspn(hexchars,temp);
	sp++;
	dp++;
	state=0;
      }
      else
	return 0; // Error-Condition
      break;
    }
  }
  *dp=0;
  return 1;
}

#if 0 // testing convert_string
VOID main(VOID)
{
  CHAR s[100];
  CHAR d[100];
  INT i;
  strcpy(s,"ULONG ");
  i = convert_string(d,s);
  printf("s:'%s', d:'%s', r:%i\n",s,d,i);
  strcpy(s,"ULONG and LONGER ");
  i = convert_string(d,s);
  printf("s:'%s', d:'%s', r:%i\n",s,d,i);
}
#endif