;*****************************************************************************
;*                                                                           *
;*              (C)  Copyright 1992-1993  by  Alberto Pasquale               *
;*                                                                           *
;*                   A L L   R I G H T S   R E S E R V E D                   *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   FastLst required many hours of work: if you like it and would like to   *
;*   support me in developing this and other similar products, please        *
;*   register. See REGISTER.FRM for more details.                            *
;*                                                                           *
;*****************************************************************************
;*                                                                           *
;*   How to contact the author:  Alberto Pasquale of 2:332/504.1@fidonet.org *
;*                               Viale Verdi 106                             *
;*                               41100 Modena                                *
;*                               Italy                                       *
;*                                                                           *
;*****************************************************************************
;
;
;                    Sample FastLst 1.13 config file
;
;
;
;RegKey    RegistrationKey ; If you are a registered user, put your
;                          ; registration key here (not case sensitive)
;
;
Address $ADDR$        ; Your network address (4D)
Country 43-            ; Your country code (Intl phone code: 1- for the USA)
MaxBaud 9600           ; Your highest baud rate (as in your nodelist entry)
;
StatusLog    $PATH$\log\fastlst.log ; Binkley style log file
;
AutoErase    ; Delete old nodelist and nodediff after applying nodediff
;
;KillOld     ; Kill old nodelist files.
;            ; When a nodelist file is processed, existing old versions
;            ; are erased.
;
;Kill999     ; Delete the final .999 when Merging (MergeList).
;
KillAfter    ; Old NODEX.* files are killed after the new ones have been
;            ; successfully written.
;            ; Thus you will always have a valid nodelist, even in the case
;            ; of a compilation error. On the other hand you need some more
;            ; spare disk space to hold the old and new files during
;            ; compilation.
;
;Dash2Comma            ; Change dashes to commas in the phone number
;NoDash                ; Remove dashes from the phone number


;                          Nodelist format

;Gated                 ; If you want to keep the output files small,
;                      ; you can use this option: only zones/regions/nodes
;                      ; that are listed in GateAddr will be present in
;                      ; the output files. Anyway the coordinators at
;                      ; GateCoord level or above will always be in the
;                      ; output files.
;
;GateAddr 1 2:33 3:632 4:801/17
;                      ; Defaults to your zone.
;                      ; You can specify zone, region/net and node numbers.
;                      ; The example compiles: zone 1, region 33 of zone 2,
;                      ; net 632 of zone 3, node 4:801/17
;
;GateCoord NC          ; Defaults to NC, can be ZC, RC, NC, HC.
;                      ; The coordinators of the specified and upper levels
;                      ; are always present in the output files.
;                      ; If you use V6, you _must_ include coordinators of
;                      ; all levels above any of the segments selected
;                      ; via the GateAddr statement: if you are unsure,
;                      ; leave it commented out.
;
; Version6               ; Generate Version 6 format files
Version7               ; Generate Version 7 format files

;Comments              ; Output comment lines to video
;NoReport              ; Do not output nodelist statistics
;FidoTxt               ; Output 80 Column Text List of nodes
;FidoPrn               ; Output 132 Column Text List of nodes

FidoUserLst            ; Generate fidouser.lst text list of sysop names
; SysopNdx               ; Generate SYSOP.NDX (version 7 sysop name list)
Interlist              ; Put all zones in above sysop lists,
                       ; instead of your zone only.

;SysDup 2:332/504 2:332/505 2:332/104
;                      ;
;                      ; When a SysOp name is present in various nodes,
;                      ; all the name/address couples are kept in the
;                      ; SysOp lists (fidouser.lst/sysop.ndx).
;                      ; If you want to keep only one address you can
;                      ; use one or more SysDup lines: the SysOps who have
;                      ; these addresses will be present in the
;                      ; output sysop lists with the specified address only.

                       ; MergeList allows to Merge the main nodelist with
                       ; a segment of it. I used to merge the complete
                       ; fidonet nodelist with my region's segment, in order
                       ; to have it always up to date.
                       ; If you use V7 you should generally prefer Mylist.

;MergeList region33    ; The latest region.nnn is merged with the latest nodelist
;MergeList c:\opus\hub.500 ; My Hub segment is merged with the latest region33.nnn
                       ; before it is merged with the main nodelist.

;MyList region33       ; The latest region33.nnn is added to the compilation.
;MyList c:\opus\hub.500 ; If you use Version7, in the case of duplicate nodes,
                       ; the last compiled ones are put in the indexes.
                       ; With Version7 you can save time by using "MyList"
                       ; instead of "MergeList" for local nodelist segments:
                       ; all the new and changed nodelist entries will be
                       ; active, but the deleted ones will still be present.

;MyList region88 39    ; The latest region88.nnn is added to the compilation.
;                      ; It is considered in Zone 39 (using Version7).
;                      ; If you use Version6 you need a "ZONE,39,..." line
;                      ; at the start of region88.nnn.
;
;MyList Hub400.lst 1:120 ; Hub400.lst is added to the compilation.
;                      ; It is considered in Zone 1, Net 120 (Version7).
;                      ; With Version6 you need Zone and Host lines.
;
MyList Schulist
;PvtList Points.Lst    ; A private node list (not in the Text outputs).

; PvtList  Pointnet.Lst
PvtList  Point4d.lst
; PvtList  Region31.lst


Password 2:310/1.0    $PASSWD$

; include fastlst.pwd    ; You can put here all your "password" lines

; Definitions for modem_type flags:
; TypeDef <flag> <value>

; If <flag> is found in the flag portion of the nodelist entry, the
; corresponding modem_type byte is OR-ed with <value>.
; e.g.: a V32B entry will get both the V32 and V32B bits
;
TypeExact          ; Use this option with Binkley 2.55 and newer.
;                  ; The modem type will be determined by the first match
;                  ; only: If you define HST before V32 a node with
;                  ; both V32 and HST will have a plain HST modem type.
;                  ; Thus you can use 255 different modem types (1 -> 255)
;                  ; since this field is not bit oriented anymore.
;
TypeDef H16  1  ; Type 1 if H16 flag present
TypeDef V32B 2  ; Type 2 if V32B flag present
TypeDef HST  3  ; Type 3 if HST flag present
TypeDef H14  3  ; Type 3 if H14 flag present
TypeDef V32  4  ; Type 4 if V32 flag present
;

;Name 2:332/504.0 800_support      ; Substitute a Board Name

;Phone 2:332/501.0 39-59-399999     ; Substitute a phone number
;Baud  2:332/501.0 9600             ; Substitute a baud rate
;CM    2:332/501.0                  ; It can handle crash mail


; Cost table: 
;
;    The COST statement at the head of the table takes two
;    arguments, which are the default costs to apply to
;    domestic and international calls.
;
;    Each entry in the cost table consists of a partial phone number 
;    followed by a cost for any node whose phone number begins with that
;    string.  The first matching entry is the one that is used.
;
;    Cost table entries can take an optional third item, which is a 
;    mask for modem type to use when calling into that area.
;    The bits not contained in the mask are removed from modem type.
;
;    When using TypeExact the optional third item becomes a list of
;    numbers representing the allowed exact modem types.
;
;    An example follows: 
;

; Cost table: 
;
;    The COST statement at the head of the table takes two
;    arguments, which are the default costs to apply to
;    domestic and international calls.
;
;    Each entry in the cost table consists of a partial phone number 
;    followed by a cost for any node whose phone number begins with that
;    string.  The first matching entry is the one that is used.
;
;    Cost table entries can take an optional third item, which is a 
;    mask for modem type to use when calling into that area.
;    The bits not contained in the mask are removed from modem type.
;
;
Cost 120 17
;    ^   ^
;    !   briges Ausland: 1,7 Sekunden
;    briges Inland: 12 Sekunden
; Ortsgebuehr (720 Sekunden):

  43-1-     7200
  43-222    7200
  43-2215   7200
  43-2217   7200
  43-2218   7200
  43-2219   7200
  43-223    7200
  43-224    7200
  43-2251   7200
  43-2252   7200
  43-2259   7200
  43-2260   7200
  43-2261   7200
  43-2262   7200
  43-2264   7200
  43-2266   7200
  43-2271   7200
  43-2273   7200
  43-2287   7200

; Inlandszone I (180 Sekunden):

  43-2142   1800
  43-2143   1800
  43-2144   1800
  43-2145   1800
  43-2146   1800
  43-2147   1800
  43-2148   1800
  43-2148   1800
  43-215    1800
  43-216    1800
  43-217    1800
  43-218    1800
  43-219    1800
  43-220    1800
  43-2210   1800
  43-2211   1800
  43-2212   1800
  43-2213   1800
  43-2214   1800
  43-2253   1800
  43-2254   1800
  43-2255   1800
  43-2256   1800
  43-2257   1800
  43-2258   1800
  43-2263   1800
  43-2265   1800
  43-2267   1800
  43-2268   1800
  43-2269   1800
  43-2272   1800
  43-2274   1800
  43-2275   1800
  43-2276   1800
  43-2277   1800
  43-2278   1800
  43-2279   1800
  43-2280   1800
  43-2281   1800
  43-2282   1800
  43-2283   1800
  43-2284   1800
  43-2285   1800
  43-2286   1800
  43-2288   1800
  43-2289   1800
  43-229    1800
  43-23     1800
  43-24     1800
  43-25     1800
  43-26     1800
  43-27     1800
  43-281    1800
  43-2821   1800
  43-2822   1800
  43-2823   1800
  43-2824   1800
  43-2825   1800
  43-2826   1800
  43-2827   1800
  43-2828   1800
  43-2829   1800
  43-2872   1800
  43-2873   1800
  43-2874   1800
  43-2875   1800
  43-2876   1800
  43-2877   1800
  43-2878   1800
  43-2879   1800
  43-288    1800
  43-289    1800
  43-291    1800
  43-292    1800
  43-293    1800
  43-294    1800
  43-295    1800
  43-296    1800
  43-297    1800
  43-2981   1800
  43-2982   1800
  43-2983   1800
  43-2984   1800
  43-2985   1800
  43-2986   1800
  43-2987   1800
  43-2988   1800
  43-2989   1800
  43-333    1800
  43-334    1800
  43-335    1800
  43-3385   1800
  43-3882   1800  
  43-3883   1800
  43-3884   1800
  43-3885   1800
  43-3886   1800
  43-7412   1800
  43-7413   1800
  43-7414   1800
  43-7415   1800
  43-7416   1800
  43-7417   1800
  43-7418   1800
  43-748    1800

; Ausland 1 (720 Sekunden):
  32-     720   ; Belgien
  33-     720   ; Andorra
  44-     720   ; BRD
  45-     720   ; Dnemark
  33-     720   ; Frankreich
  39-     720   ; Italien
  38-     720   ; Ehem. Yugoslavien
  351-    720   ; Portugal (ab 2000 Uhr)
  352-    720   ; Luxemburg
  31-     720   ; Niederlande
  48-     720   ; Polen
  40-     720   ; Rumnien
  41-     720   ; Schweiz
  42-     720   ; Tschechoslowakai
  36-     720   ; Ungarn

; Ausland 2 (554 Sekunden):
  355-    554   ; Albanien
  359-    554   ; Bulgarien
  25-     554   ; Finnland
  30-     554   ; Griechenland  
  44-     554   ; Grobritannien & Nordirland
  353-    554   ; Irland
  354-    554   ; Island
  46-     554   ; Schweden
  34-     554   ; Spanien 
  90-     554   ; Trkei
  7-      554   ; UdSSR
  357-    554   ; Zypern
  213-    554   ; Algerien
  216     554   ; Tunesien

; Ausland 3 (267 Sekunden):
  972-    267   ; Israel
  1-      267   ; USA Kanada
  218-    267   ; Libyen
  212-    267   ; Marokko
End

; UCost table:
; Same as Cost table, but for User_Cost (Fee for a netmail message on BBS)
; There is not the third optional argument.
; If UCost is commented out, the User_Cost is taken equal to Call_Cost.
;
Ucost 0  0
  43-1-     0
End

;Type  2:332/501.0 4                 ; Substitute a modem type as defined
                                     ; via TypeDef.

                         ; The Flags statement allows to set the "user
                         ; defined" bits in the Flags word of the compiled
                         ; nodelist entry.
                         ; These bits are named 5,6,7,8,9,A,B,D,E,F;
                         ; where bit 5 is the 6th bit and F is the 16th
                         ; bit of the word.

;Flags 2:332/501.0 AB5   ; Set bits 5,A & B.
;Flags 2:332/503.0 A     ; Set bit A only.

; Cost Override  (<type> as defined via TypeDef/TypeExact)
; TypeCost <type> <cost>
;
;TypeCost  1 100    ; Cost override for HST nodes
;TypeCost  2 50     ; Cost override for PEP nodes
;TypeCost  4 100    ; Cost override for V32 nodes

;Cost 2:332/501.0 150    ; Call_Cost override.
                         ; If the UCOST table is not defined, then
                         ; the User_Cost is overriden too.

;UCost 2:332/501.0 10    ; User_Cost override.

; Dialing Translations
;
; The Dial statement at the head of the table takes two arguments for
; domestic and international prefix/suffix default specifications.
; The subsequent lines contain a partial phone number and a single
; argument for the prefix/suffix to be used for nodes whose phone number
; begins with that string.
;
; The first matching entry is the one that is used.
; If no entry applies, the defaults are used.
;

Dial  0- 00-
      352-            00432 /
      43-222-               /
      43-1-                 /
      43-2             0-2  /
      43-3             0-3  /
      43-4             0-4  /
      43-5             0-5  /
      43-6             0-6  /
      43-7             0-7  /
      43-8             0-8  /
      43-9             0-9  /
End
                     ; If you want to specify a suffix, then you must precede
                     ; it with a slash ("/<suffix>"). If both a prefix and a
                     ; suffix are specified, they must be separated by a slash
                     ; ("<prefix>/<suffix>"). No spaces are allowed
                     ; between prefix, suffix and the separating slash.




