; The 'Address' keyword specifies the network addresses of your
; system.
;
; -------------
; FOR 4D POINTS
; -------------
;
; This feature can only be used if both you and your boss are running
; 4D-aware packers AND 4D mailers.
;
; For 4D points, simply include your full 4D address.  Any addresses
; after that will simply be considered as AKAs.
;

Address $ADDR$
Address $SADDR$
; The 'NetFile' keyword tells Squish where your mailer places
; received packets and ARCmail packages.  You can specify as many
; NetFile paths as you like, and Squish will search each of them
; when invoked with 'SQUISH IN'.
;
; The NetFile keyword has two modifiers:  'NoPkt' and 'NoArc'.  The
; 'NoPkt' modifier instructs Squish NOT to toss *.PKT files from
; the specified path.  The 'NoArc' modifier instructs Squish NOT
; to toss ARCmail bundles from that path.  These modifiers may
; be useful for a tri-level security scheme, such as that which
; is offered by BinkleyTerm.

NetFile                 $PATH$\Inbound

;NetFile                $PATH$\Prot
;NetFile NoArc          $PATH$\Known
;NetFile NoArc NoPkt    $PATH$\Unknown


; The 'AreasBBS' keyword tells Squish where to find a standard-format
; AREAS.BBS file.  NOTE: using AREAS.BBS is optional!  If you
; have no other utilities which use AREAS.BBS, it may be easier
; to comment out this keyword and to use the 'EchoArea' keyword
; to define areas in this configuration file.  (See later in
; this file for more details.)

; AreasBBS        Areas.BBS


; The 'ArcmailAttach' keyword instructs Squish to use
; FroDo/IM/D'bridge-style message handling.  This is compatible with
; most other mailers which use an 'attach message' to send archives.
;
; This keyword is NOT required for systems running BinkleyTerm,
; Opus, or any other programs which use an 'outbound directory'.
;
; When this keyword is uncommented, Squish will generate *.MSG
; attach messages instead of Binkley-style *.?LO files.  This keyword
; also disables most of the routing commands in ROUTE.CFG.
;
; EVEN IF 'ArcmailAttach' IS ENABLED, YOU MUST STILL USE THE
; "SQUISH SQUASH" COMMAND AND HAVE A VALID ROUTE.CFG!
;
; When ArcmailAttach is defined, the `squash' phase of processing
; will be used to build attach messages, as opposed to scanning
; the outbound area.  ROUTE.CFG is still required, but since most
; mailers will perform dynamic routing, its importance is minimal.
; Please see the comments in ROUTE.CFG for information on routing
; and ArcmailAttach systems.

; ArcmailAttach


; If you're running BinkleyTerm 2.50 or above, the BinkPoint
; keyword can be enabled.  BinkPoint enables the Binkley 2.50+
; "point directories", which allows for full 4D point support.
; If you wish to run 4D points on a Bink system, you must be
; running Binkley 2.50 or greater, and this keyword must be 
; enabled.

BinkPoint


; The 'Compress' keyword gives the name of a compression configuration
; file.  Squish's compression is extremely flexible, and support for new
; archiving programs can be added at any time.  For most people, the
; default COMPRESS.CFG is all that is required.

Compress        Compress.Cfg


; The routing control file is used to control Squish's operation during
; the 'Squash' phase of processing.
;
; --> THIS KEYWORD IS ALWAYS REQUIRED, EVEN FOR ARCMAILATTACH SYSTEMS!  <--
; -->        PLEASE SEE THE COMMENTS IN ROUTE.CFG FOR DETAILS!          <--

Routing         Route.Cfg


; When not using 'ArcmailAttach', the Outbound keyword tells Squish where
; to find your Binkley-style outbound area.  This should always be the
; name of your PRIMARY outbound area, without an extension.  Squish
; will dynamically create outbound areas as necessary for other zones,
; so only the primary directory name is required.
;
; If 'ArcmailAttach' is being used, THIS KEYWORD IS STILL REQUIRED!
; In this case, the Outbound directory should point to a scratch
; area which Squish can use to build and store compressed mail packages.

Outbound        $PATH$\Outbound


; The 'LogFile' keyword instructs Squish to keep a log of its activities.
; This log is written using a Max/Bink/Opus-compatible format, so the
; same logfile name can be used for both Max and Squish.

LogFile         $PATH$\log\Squish.Log


; The 'Origin' keyword is used to specify a default origin line for
; EchoMail areas.  This option is only required if you're NOT using
; an AREAS.BBS, since Squish can normally obtain the origin line
; from that file.
;
; This origin line will be added to local messages which were created
; without an origin or tear line.

Origin         $SYSTEM$

; The 'Secure' keyword instructs Squish to check the addresses on all
; echomail messages it receives, and causes it to reject unsolicited
; messages.  This means that only only those nodes which are listed
; in AREAS.BBS (or your EchoArea lines) will be able to send echomail
; messages to your system.
;
; If a message is received from a system which is not listed for
; a particular message area, the message will be placed in your
; BadArea and noted in the logfile.

Secure


; The 'CheckZones' keyword instructs Squish to check the zone number
; on all incoming messages, and to treat different zones as distinct
; entities.
;
; This is normally desired; however, several older software packages
; do not support zones, and as such, Squish may find a 'random'
; zone number in packets it receives from other systems.
;
; If this keyword is commented out, Squish will ignore zone numbers
; when tossing messages.

CheckZones


; The 'QuietArc' keyword instructs Squish to suppress the screen output
; of external compression programs.  This is useful for reducing screen
; clutter, especially when packing mail for a large number of nodes.
;
; NOTE:  this keyword will not suppress the screen output for LHarc 2.xx.
; For whatever reason, the author of LHarc wrote the program in such
; a way that screen output cannot be easily eliminated.

QuietArc


; The 'Duplicates' keyword defines the number of duplicate message IDs
; that Squish will keep for each individual area.  By default, Squish
; keeps 1000 IDs for each area, which should be acceptable for the
; majority of other systems.
;
; Unlike most other software, Squish uses a safe 64-bit ID to identify
; messages as dupes.  Due to a few other factors, Squish's advanced
; dupe checking technology almost never identifies messages as false
; duplicates, so raising this number will not adversely impact mail
; reliability.

Duplicates 1000


; The 'KillDupes' keyword instructs Squish to delete duplicate messages
; as they are tossed.  This provides for efficient use of disk space
; (if a large packet of dupes is received from your uplink), but it
; leaves the operator with no way to determine the cause of the dupes.
;
; By default, KillDupes is off, and duplicate messages will be placed
; into your DupeArea.

KillDupes


; The 'KillIntransit' keyword instructs Squish to delete in-transit
; netmail.  This means that netmail NOT addressed to your system will
; be deleted after it is packed.

KillIntransit


; The 'KillBlank' keyword instructs Squish to delete blank netmail
; messages, or netmail messages which do not have a message body.
; Such messages are generated by some D'bridge systems, in addition 
; to manually-generated file requests and file attaches.

KillBlank


; The 'Password' keyword is used to specify a password for outgoing
; packets.  In addition, if 'Secure' mode is enabled, Squish will
; also check incoming packets for the specified password, and it will
; reject and rename packets with invalid passwords.  Passwords are
; case insensitive, and they must be eight characters or less.

;              Address         Password
;              -----------     --------
;Password      1:249/106.2     Boffo
;Password      1:225/1         Gnarly


; The 'Pointnet' verb is used to support fakenet-style points.  This
; keyword must be used by BOTH fakenet bosses and fakenet points.
; Simply specify your pointnet number, and Squish will automatically
; convert pointnet addresses and strip SEEN-BYs as necessary.  This
; option is not required if you are a 4D point, or if you are a boss
; and only feed 4D points.  If you are a boss which supports BOTH
; 4D and fakenet points, then this keyword is still required.

; Pointnet        12345


; The 'Track' keyword instructs Squish to keep a log of forwarded netmail
; messages, including the header information (to/from/subject).
; This command in not a replacement for external utilities such as
; MsgTrack, but it can be used as a quick means of finding out who is
; forwarding netmail through your system.
;
; WARNING!  This keyword must point to a SEPARATE log file.  You cannot
; use the same logfile for both Track and LogFile.

Track           $PATH$\Log\MsgTrack.Log


; The 'Pack' keyword tells Squish to use the specified compression method
; when compressing mail for the specified nodes.
;
; The first word following 'Pack' must be a valid compression type, as
; specified in COMPESS.CFG.  (The compression types supported by
; the distribution version of Squish are ARC, PAK, ZIP, LHARC, LH113,
; ZOO and ARJ.  However, more archivers can be easily added when
; they become available.)
;
; Any number of nodes may be specified after the compression type, and
; 'All' may also be used to specify a broad range of systems.  If no
; compression type is specified for a given node, then the default
; compression method will be used.  (See below.)
;
; NOTE!  Older programs, including QMail 1.00, do not support the LHarc 2.xx
; compression format.  For this reason, the 'LH113' compression format
; is provided; this instructs LHarc to create archives in compatibility
; mode.  If your feeds are running QM 1.00, you must specify the
; LH113 method instead of LHarc.
;
;Pack Zip   1:24906/All 249/102 104 106 108 2:2/1
Pack LHarc  2:310/1
;Pack LHarc 2:222/123 500/All


; The 'DefaultPacker' specifies the name of the compression program to
; use for nodes not lisited in any of the 'Pack' statements.
;
; WARNING!  The official FidoNet standard for mail compression is
; ARC.  Unless you have a very good reason for using a different
; compression method, you should leave this keyword alone to ensure
; maximum compatibility.

DefaultPacker Arc


; The 'SaveControlInfo' keyword instructs Squish to keep the SEEN-BY and
; PATH control information inside the message database.  This command
; will ONLY be applied to Squish-type areas, and will ONLY be used when
; running in a one-pass "IN OUT" mode.  The SEEN-BYs and PATH lines will
; always be retained when running in multi-pass mode.  This option
; can be used to save space on your hard drive.

SaveControlInfo


; The 'ForwardTo' keyword tells Squish that it has permission to forward
; messages which are destined to the specified nodes.  If you add the
; modifier 'File' after 'ForwardTo', then Squish will also forward
; file attaches to the specified nodes as well.
;
; To forward ALL mail passing through your system, simply
; use 'ForwardTo WORLD'.
;
; For ArcmailAttach systems, your mailer handles the routing of files.
; This keyword is not needed for such systems.

;ForwardTo              1:249/0 1 9 106 126 229/414 24906/All
;ForwardTo File         1:249/122


; The 'ForwardFrom' keyword uses the same syntax as ForwardTo, except it
; it tells Squish to allow messages coming from the specified nodes to
; be forwarded ANYWHERE.  When used with the 'File' modifier, this
; command is considerably more dangerous than ForwardTo, since it
; effectively gives the specified nodes a blank cheque, since they
; will have the ability to send large files through your system,
; possibly to a long-distance number.  Normally, this option should
; only be used for points or trusted individuals.
;
; For ArcmailAttach systems, your mailer handles the routing of files.
; This keyword is not needed for such systems.

;ForwardFrom 1:24906/All 249/99
;ForwardFrom File 1:249/108


; The 'TinySeenbys' verb tells Squish to use "tiny" SEEN-BYs for the
; specified list of nodes.  This means that Squish will strip off all
; excess node numbers when exporting a message, and it will only add the
; node numbers of the systems that are defined for each echo area.
;
; This keyword can significantly reduce the size of output packets,
; especially if Squish is processing widely-distributed EchoMail
; areas.

;TinySeenbys  249/199 2:123/456


; The 'Remap' keyword can be used to automatically forward messages to
; points.  If a message arrives on your system which is addressed to one
; of your 'Address' statements, Squish will compare the message's
; "To:" address with each of the names listed below.  If a match is
; found, Squish will forward the packet manually, and readdress the
; message to the specified point.
;
; In addition, the '*' character functions as a wildcard, and can be used
; to remap mail which is addressed using only a partial name.
;
; NOTE!  If you are using fakenet points, make sure to specify the
; full fakenet address!  Similarly, if you are using 4D points, make
; sure that you use the full 4D address.  The address you specify doesn't
; have to be a point address, but if you are using a point address, you
; should make sure to specify the correct one.
;
; FOR BOSSES OF FAKENET POINTS ONLY:
;
;Remap   24906/2 Mark Kaye      ; Remap messages for Mark Kaye to point 2
;Remap   24906/3 Kevin Kell     ; Remap messages for Kevin Kell to point 3
;Remap   24906/1 Scott*         ; Remap messages starting with 'Scott' to
;                               ; point 1.
;
; FOR BOSSES OF 4D POINTS ONLY:
;
;Remap   .2      Mark Kaye      ; Remap messages for Mark Kaye to point 2
;Remap   .3      Kevin Kell     ; Remap messages for Kevin Kell to point 3
;Remap   .1      Scott*         ; Remap messages starting with 'Scott' to
;                               ; point 1.


; The 'AddToSeen' keyword instructs Squish to add a particular node number
; to the SEEN-BYs for all echomail areas that your system receives.
; (Note: it is possible to add SEEN-BYs on an area-by-area basis.  See
; 'EchoArea' below for more details.)
;
; The node numbers you specify here will be added to each and every
; message that passes through your system.  This is usually not required,
; except when changing primary addresses.

;AddToSeen 250/814 820


; The 'GateRoute' keyword is used to send inter-zone messages through
; the zonegate.  Since this is declared in SQUISH.CFG, this will gateroute
; ALL netmail messages going through your system to the specified
; addresses.  This command is only useful when NOT using ArcmailAttach.
;
; GateRouting is only required by other<tm> brain-dead packers which
; do not properly understand zones.  If you're using the low-priority
; netmail routing scheme, it's probably safe to use a normal
; 'Route' command in ROUTE.CFG.  However, when sending directly to
; any of the official zonegates, it's best to use the GateRoute method.
;
; After the word 'GateRoute', you must specify a flavour to use for
; the resulting gaterouted package.  This will be placed into the
; appropriate .?UT message bundle.
;
; Following the message flavour is the 'host node'.  This is where
; all of the gaterouted messages will be sent.
;
; After the host node comes the 'route-to' nodes.  You can specify any
; number of nodes after the host, and you can even use the 'All'
; wildcards.
;
; If you wish to except certain nodes from gateroute processing, include
; the word 'Except', followed by any nodes whose mail you do NOT wish
; to gateroute.
;
; The following will work for standard gaterouting within zone 1:
;
;GateRoute Normal 1:1/2 2:All
;GateRoute Normal 1:1/3 3:All
;GateRoute Normal 1:1/4 4:All
;GateRoute Normal 1:1/5 5:All
;GateRoute Normal 1:1/6 6:All
;
; If you were connecting directly with a particular node in zone 2, and
; you did not want that node's mail to be gaterouted, you could use the
; following sample gateroute line:
;
;GateRoute Normal 1:1/2 2:All Except 2:123/456


; The 'BusyFlags' keyword instructs Squish to use the BinkleyTerm
; *.BSY flags in the outbound area.  These flags are a must when
; Squish is running in a multitasking or network environment, since
; they stop Squish and Binkley from trying to access the same
; bundle at the same time.

BusyFlags


; The 'OldArcmailExts' keyword should be used when communicating with
; older systems, such as Opus 1.03.  Early versions of Opus did
; not understand the *.TU?, *.WE?, and other day-of-week extensions
; when performing a WaZOO session, so sending compressed archives
; using the new ARCmail extensions may cause the remote end not
; to unpack mail right away.  This keyword instructs Squish to
; use only the .MO? extension.

;OldArcmailExts

; The 'TossBadMsgs' keyword instructs Squish to "toss" messages from
; your BadArea, every time a SQUISH IN is performed.  Squish will
; skim all of the message in the area, and it will attempt to toss
; each one.
;
; This feature is extremely useful if you request an area, but forget
; to add the echo to your configuration files.  The messages for that
; area would end up in your BadArea; with TossBadMsgs enabled,
; once you add that area to your configuration, messages will be
; tossed from your BadArea just as they would from a .PKT file,
; thereby saving you a lot of manual message moving.

TossBadMsgs



; The 'BatchUnarc' keyword instructs Squish to decompress all compressed
; mail archives at the same time, and to start tossing the packets after
; all of the archives have been decompressed.
;
; Using BatchUnarc requires slightly more space, but it also prevents
; messages from getting out of order.  Squish will toss packets accoring
; to their dates, but if Squish only tossed mail from one archive at
; a time, the dates can get mixed up.  If you don't send mail to
; anyone else, you probably don't need to use this.  However, if you're
; sending one or more echoes to other systems, using BatchUnarc is
; probably a good idea.

;BatchUnarc


; The 'ZoneGate' command instructs Squish to perform special conversions
; on messages addressed to the 'zonegate node'.  When sending an
; echomail conference across zones, SEEN-BYs must be stripped from
; messages, since net/node numbers may be duplicated among different
; zones.
;
; This command provides an FTSC-0004 compliant method to gate conferenes
; between zones.  The format for the ZoneGate command is as follows:
;
; ZoneGate <host> <nodes...>
;
; The <host> is the address of the system which you are gating for.  All
; echomail messages addressed to this system will have their SEEN-BYs
; stripped.
;
; <nodes> is a list of nodes which are to be added to the SEEN-BYs,
; after the original set of nodes is stripped.  WARNING:  Squish does
; NOT automatically add your address or the host's address to
; the SEEN-BYs, so you must include your address and the other system's
; address, at a bare minimum.  Other nodes can be added to the SEEN-BYs
; for safety purposes.
;
; NOTE:  ZoneGate is a potentially dangerous command.  If you do not
; know exactly what you're doing, this command should be avoided.

;ZoneGate 2:253/68 249/106 253/68


; The 'Statistics' keyword instructs Squish to keep a statistics file,
; based on mail sent and mail received.  These statistics are extremely
; verbose, but they are also extremely accurate.  An external program
; can be used to read the SQUISH.STA file, and to generate a 100%
; accurate billing report for the specified nodes.
;
; Statistics


; The 'StripAttributes' keyword instructs Squish to strip the message
; flavour attributes (CRASH and HOLD) from incoming netmail messages.
; Stripping these attributes prevents someone from routing a CRASH
; message through your system, and then having your system deliver
; the message as CRASH as well.

StripAttributes


; The 'AddMode' keyword instructs Squish to "add" to existing .?LO files.
; Normally, when Squish wants to send a message or file to a particular
; node, it will use the exact flavour specified in the routing control
; file.  However, AddMode instructs Squish to check the outbound area
; first, and if a flavoured file attach exists (such as CRASH, HOLD or
; DIRECT), the file will be added to that file attach instead.
;
; This is useful if a specified set of routing commands is normally used,
; but if exceptions must be made.  In other words, a node may be marked
; Crash, but if that node goes down for a period of time, it may be
; desirable to keep that node's mail on hold.  When AddMode is enabled,
; simply change the flavour of the existing attach to HOLD, and all future
; attaches will also be made as HOLD (regardless of the original flavour),
; until the HOLD file attach is picked up.

;AddMode

; The 'MaxMsgs' keyword instructs Squish to stop scanning after 'x' 
; messages have been reached, to pack the resulting packets into an
; archive, and to continue scanning from where it left off.  This
; feature can help in situations where disk space is at a premium,
; or where the size of the output .PKT files is to be kept small.
;
; When running in "IN OUT SQUASH" mode, the MaxMsgs feature is
; automatic.  However, when the OUT and SQUASH phases are separated,
; some batch file magic is required.  Please see the documentaton
; for information on using MaxMsgs in separate passes.
;
; The number after MaxMsgs specifies the number of messages to
; process before taking a break and archiving the output.  A number
; of around 100 messages usually yields packets of about 75K in
; size, assuming a normal backbone load.  This number can be increased
; or decreased, depending on your processing requirements.

;MaxMsgs 150


; The Swap keyword (DOS only) instructs Squish to swap itself out to
; XMS/EMS/disk before spawning the compression programs.  This frees
; up all but 3k of the memory that Squish normally uses, and it
; allows Squish to be used in tight-memory situations.
;
; By default, Squish will attempt to swap to XMS first followed by
; EMS, and finally, Squish will attempt to swap to disk.  If you
; don't specify anything after the 'Swap' keyword, and Squish
; resorts to disk swapping, Squish will write the swap file in
; the current directory.  However, if you wish Squish to swap elsewhere
; when it has to resort to disk swapping, you can specifiy a path
; and a filename after the 'Swap' keyword.
;
; WARNING!  Some networks may be allergic to the Swap command.  If
; you're having trouble getting Squish to run with Swap, try
; turning it off.
;

; Swap $PATH$\Temp\SQUISH.SWP

; The 'Nuke' keyword (ArcmailAttach mode only) instructs Squish to
; delete ARCmail bundles for which there is no attach message.  This
; keyword is ONLY required when using Max with D'bridge, or some other
; mailer which cannot delete or truncate files as they are sent.
;
; When Squish gets to the SQUASH phase, it will scan all of the messages
; in the netmail directory, and make a note of all file attaches.  It
; will then scan the outbound packet directory, and delete any ARCmail
; bundles which do not have attach messages.
;
; THIS COMMAND IS POTENTIALLY DANGEROUS, SO IT SHOULD ONLY BE USED
; IF YOUR MAILER REQUIRES IT!
;
;Nuke


; The 'MaxAttach' keyword is for ArcmailAttach mode ONLY.  This option
; instructs Squish to reserve memory for up to <n> netmail attach
; messages.  You should have no more than this number of messages in
; your netmail area.  Nothing drastic will happen if the number of
; attaches exceeds this, but you may find that duplicate attach
; messages are created if it's too small.  The default for MaxAttach is
; 256.  Most systems will NOT need to use this keyword.
;
;MaxAttach 256


; The 'MaxPkt' keyword is used in both ArcmailAttach and
; non-ArcmailAttach modes.  This keyword specifies the maximum number
; of packets which can be present in OUTBOUND.SQ at one time.  If the
; number of packets exceeds this value, then the excess packets will
; simply be queued for the next run of Squish.  The default for MaxPkt
; is 256.  Most systems will NOT need to modify this number.
;
;MaxPkt 256

; The `Buffers' keyword controls Squish's memory usage.  By default,
; Squish will use large buffers for processing mail.  However, if
; you're running Squish in a memory-restricted environment, you
; can tell Squish to use less memory by specifying one of the
; options below.  WARNING!  As you decrease the buffer size, Squish
; becomes slower and slower.  `Buffers Small' is unsuitable if you're
; forwarding mail to any other nodes; medium buffers should be
; considered the minimum for hubs.

;Buffers Large
Buffers Medium
;Buffers Small

; Next are any number of message area definitions.  However, as a bare
; minimum, you must have a NetMail area and a bad messages area.
;
; The format of a message area definition is:
;
; <type> <tag> <path> [flags] [nodes]
;
; <type> specifies the type of area to define.  Valid <type>s are
; NetArea, BadArea, DupeArea and EchoArea.  You must have at least
; one NetArea and at least one BadArea.
;
; <tag> specifies a short-form "name" for that area.  This name is
; used as a quick way of referring to that area; for NetAreas, BadAreas
; and DupeAreas, the only requirement is that the tag must be unique.
; However, for EchoAreas, this tag defines the actual name of the area,
; as used when talking to other systems.  In other words, before assigning
; a tag to an echo, you should ask your feed for the name of that echo.
;
; <path> specifies the path to the area.  For *.MSG areas, this should
; be the path to the message directory.  For Squish areas, <path>
; should be the path and root filename of the Squish area.
;
; [flags] are an optional set of modifiers for each area.  A flag is
; a dash followed by a character, plus an optional argument.  Flags
; can be used to change the attributes of an area, such as making
; that area "passthru", using the Squish message format for that area,
; and so on.
;
; A brief description of each flag follows, but for more information,
; you should consult the Squish documentation for a full explanation of
; each flag.
;
;       -f              The '-f' flag selects the FTSC-0001 (*.MSG)
;                       storage format.  *.MSG is the default, so this
;                       flag normally doesn't need to be used.
;
;       -p<node>        The '-p' flag selects an alternate primary
;                       address for the current area only.  This
;                       address will be used in SEEN-BYs, PATH lines,
;                       and packet headers.
;
;       -s              The '-s' flag instructs Squish to strip the
;                       private bit from all messages received in the
;                       current area.
;
;       -x<node>        The '-x' flag stops <node> from SENDING mail
;                       into the specified echo.
;
;       -0              The '-0' flag indicates that the current
;                       area is a passthru area.
;
;       -+<node>        The '-+' flag instructs Squish to add <node>
;                       to the SEEN-BYs for the current area only.
;
;       -$              The '-$' flag tells Squish that the specified
;                       area uses the Squish message format.
;
;       -$m<msgs>       The '-$m' flag instructs Squish to keep up
;                       to a maximum of <msgs> messages in this
;                       Squish-format area.  Message will be
;                       deleted by Squish on the fly.
;
;       -$s<msgs>       The '-$s' flag instructs Squish to skip the
;                       first <msgs> messages when killing up to the
;                       last '-$m' messages in each area.  This
;                       parameter is only applicable when using
;                       the -$m flag.
;
;       -$d<age>        The '-$d' flag instructs Squish to keep up
;                       to a maximum of <age> days' worth of
;                       messages in this Squish-format area.  Killing
;                       by date is NOT done on the fly, so SQPACK must
;                       be run on a regular basis to purge messages.


; Every system must have at least one NetArea.  You can declare
; more NetAreas if you like (and Squish will scan all of them when
; packing mail), but all inbound NetMail will be placed into
; this area.

NetArea         NETMAIL         $PATH$\Mess\NetMail   -$

; The BadArea is used for placing insecure or grunged messages.  Every
; system must have a BadArea.

BadArea         BAD_MSGS        $PATH$\mess\Bad     -$m100

; The DupeArea is optional.  If you have defined a DupeArea, all duplicate
; messages will be placed into this message area.  Otherwise, duplicates
; will go into your BadArea.

; DupeArea        DUPES           $PATH$\mess\DUPE

; Next comes zero or more EchoMail area definitions.  IF YOU ARE DECLARING
; YOUR AREAS IN AREAS.BBS, COMMENT OUT ALL 'ECHOAREA' LINES!
;
; The first line defines an EchoMail area called 'TUB', which uses
; the *.MSG format in the C:\Max\Msg\Bath directory.  This echo is
; scanned to 1:123/99.

; EchoArea        TUB             $PATH$\Mess\Tub          2:310/1

; The second line defines an EchoMail area called 'MUFFIN', which uses
; the Squish format (because of the '-$') in the files called
; C:\Max\Msg\Muffin.Sq?.  This echo is also scanned to 1:123/99.

; EchoArea        MUFFIN          $PATH$\Mess\Muffin  -$   2:310/1

; As many EchoMail areas can be added as you like.  Just make sure to
; add the appropriate flags, including -$ for Squish-format areas,
; and you should be all set.

EchoArea  TRASH         $PATH$\Mess\Trash  -$    2:310/1  -$d7
EchoArea  S.TEST.100    $PATH$\Mess\S_Test -$  -p$SADDR$  -s  22:102/1 
;

;                               ###

