/* define.h - global definitions for Tar program (see file tar.c)
 * Author: Shaporev T.V.
 * Creation date: 14 Dec 1990
 */
#ifdef __ALLOCEXT__
#	define EXT
#	define INI(x) = x
#else
#	define EXT extern
#	define INI(x)
#endif

#define TRUE     1
#define FALSE    0
#define ERROR    (-1)
#define ERRARG   1
#define ERINIT   2
#define ERREAD   3
#define EWRITE   4
#define ESMALL   5
#define EINTER   6
#define EXIT     7
#define CORRECT  0
#define MAXBLOCK 32
#define BLKSIZE  512
#define MAXTNAME 100
#define QUADISK  '\200'
#define RAINBOW  '\201'
#define dimof(x) (sizeof(x)/sizeof((x)[0]))

#ifndef RMKDIR
#	ifdef M_XENIX
#		define RMKDIR
#	endif
#endif
#ifndef RMKDIR
#	ifdef i386
#		define RMKDIR
#	endif
#	ifdef sun
#		define RMKDIR
#	endif
#endif

#ifdef MSDOS
#	include <fcntl.h>
#endif

#ifdef __TURBOC__
#       define NO_REALLOC /* stupid runtime can't shrink a block */
#else
#       include <sys/types.h>
#endif
#include <sys/stat.h>
#ifndef S_IREAD
#  	define S_IREAD  00400
#	define S_IWRITE 00200
#	define S_IEXEC  00100
#endif
#ifndef S_ISVTX
#	define S_ISUID 04000
#	define S_ISGID 02000
#	define S_ISVTX 01000
#endif
#ifndef O_RDONLY
#	define O_RDONLY 0
#	define O_WRONLY 1
#	define O_RDWR   2
#	define O_BINARY 0
#endif

EXT struct stat sa, st;
EXT long longcsum, codesize, allblock, allbytes;
EXT short dmajor, dminor;
EXT int allfiles;
#define isfile ((sa.st_mode & S_IFMT) == S_IFREG)
EXT short ndrive;
#ifdef MSDOS
#	define DEV_FILE 0
#	define DEV_FLOP 1
#	define DEV_QIC2 2
	EXT char devtype INI(DEV_FILE);
	EXT char setdrive INI(FALSE);
#endif

#ifdef UNIX
	EXT FILE *myinp;
#else
#	define myinp stdin
#endif
EXT FILE *myout;
EXT int  handle, hwrite;
EXT char a_flag, x_flag, t_flag, c_flag, v_flag, u_flag, y_flag, w_flag,
         i_flag, m_flag, d_flag, j_flag, s_flag, nonest, dslash, o_flag,
         l_flag, cbreak;
#ifdef UNIX
	EXT char p_flag;
#endif

#ifdef MSDOS
	EXT char k_flag, deldrv;
	EXT int filemask;
	EXT char *archname INI(NULL);
#endif

EXT char pktype;
EXT int pklevel;
#define PKNONE 0
#define PKLZH  1
#define PKfLZW 2
#define PKpLZW 3
#define PKZIP  4

/* Standard tar file type flags */
#define TF_OLD '\0' /* old-fashion flag - regular file */
#define TF_REG '0'  /* regular file */
#define TF_LNK '1'  /* link */
#define TF_SYM '2'  /* symbolic link */
#define TF_CHR '3'  /* character device */
#define TF_BLK '4'  /* block device */
#define TF_DIR '5'  /* directory */
#define TF_QUE '6'  /* FIFO special */
#define TF_CTG '7'  /* contiguous file */

/* GNU extensions */
#define GF_DMP 'D'  /* This is a dir entry that contains
                       the names of files that were in the
                       dir at the time the dump was made */
#define GF_LLN 'K'  /* Identifies the NEXT file on the tape
                       as having a long linkname */
#define GF_LNM 'L'  /* Identifies the NEXT file on the tape
                       as having a long name. */
#define GF_MUL 'M'  /* This is the continuation of a file
                       that began on another volume */
#define GF_NAM 'N'  /* For storing filenames that didn't
                       fit in 100 characters */
#define GF_SPR 'S'  /* This is for sparse files */
#define GF_VOL 'V'  /* This file is a tape/volume header */

#define TMAGIC "ustar  "
#define GMAGIC "GNUtar "

#define TXT_WORD 8
#define TXT_LONG 12

struct header {
   char name[MAXTNAME];
   char mode[TXT_WORD];
   char uid[TXT_WORD];
   char gid[TXT_WORD];
   char size[TXT_LONG];
   char mtime[TXT_LONG];
   char chksum[TXT_WORD];
   char filetype;
   char linkname[MAXTNAME];
   union {
      struct {/* old-fashion data & padding */
         char comment[BLKSIZE-MAXTNAME-8-8-8-12-12-8-1-MAXTNAME-12-12];
         char srcsum[TXT_LONG];
         char srclen[TXT_LONG];
      } old;
      struct {/* System V extensions */
         char extent[4];
         char allext[4];
         char total[TXT_LONG];
      } s_v;
      struct {/* P1003 & GNU extensions */
         char magic[8];
         char uname[32];
         char gname[32];
         char devmajor[TXT_WORD];
         char devminor[TXT_WORD];
         /* the following fields are added gnu and NOT standard */
         char	atime[12];
         char	ctime[12];
         char	offset[12];
      } new;
   } x;
};

struct node {
	struct node *prev, *next;
        union {
		long time;
		struct {
			int inode, device, count;
		} data;
	} info;
        char name[MAXTNAME];
};

#define pkfile (pktype == PKLZH || pktype == PKfLZW)
#define PKSIZE (8*BLKSIZE)
EXT int pksize INI(PKSIZE);
EXT char *pk_inp INI(NULL), *pk_out INI(NULL);

EXT char *io_buf, *io_2nd;
EXT int cblock;

EXT struct header *hblock;
EXT char *scratch;

#define NONE (struct node *)0
EXT struct node *timehead INI(NONE);
#ifdef UNIX
	EXT struct node *linkhead INI(NONE);
#endif

#ifndef MSDOS
#	define takename(a,b) (void)strcpy((a),(b))
#endif

int   yes_no   __ARGS__(( char ));
#define YES_NO() yes_no('N')

void  outmem   __ARGS__(( FILE* ));
char  *salloc  __ARGS__(( int ));
char  *getbuf  __ARGS__(( int ));
void  done     __ARGS__(( int ));
int   initape  __ARGS__(( char* ));
int   runtape  __ARGS__(( void ));
void  duptape  __ARGS__(( char* ));
void  prmode   __ARGS__(( char, int ));
int   okwork   __ARGS__(( char, char, struct stat *, char* ));
void  cantopen __ARGS__(( char* ));
void  savefile __ARGS__(( char* ));
void  store    __ARGS__(( char* ));
char  prefix   __ARGS__(( void ));
int   usize    __ARGS__(( void ));
short isextent __ARGS__(( short *, long *));
int   ismagic  __ARGS__(( void ));
void  catalog  __ARGS__(( void ));
void  extract  __ARGS__(( void ));
int   restore  __ARGS__(( char*));
void  makelink __ARGS__(( char*, char* ));
void  acctime  __ARGS__(( void ));
void  uplist   __ARGS__(( void ));
int   gethead  __ARGS__(( void ));
int   inargs   __ARGS__(( int, char**, char* ));
void  scantape __ARGS__(( int, char**, void(*)() ));
void  backtape __ARGS__(( void ));
void  extwrerr __ARGS__(( void ));
struct header *readtape  __ARGS__(( void ));
short headsum  __ARGS__(( struct header * ));
struct header *steptape  __ARGS__(( void ));
void  writebyte __ARGS__(( int ));
int   writearch __ARGS__(( int, long, char* ));
void  nullblock __ARGS__(( struct header * ));
void  endtape  __ARGS__(( void ));
int   readbyte __ARGS__(( void ));
void  bacouple __ARGS__(( void ));
int   readarch __ARGS__(( int, long ));
struct node *finditem __ARGS__(( char*, struct node **, struct node * ));
struct node *additem  __ARGS__(( char*, struct node *, struct node ** ));
void  delitem  __ARGS__(( struct node *, struct node ** ));
void  skipfile __ARGS__(( void ));
void  percent  __ARGS__(( long, long ));
#ifdef MSDOS
	int    argdisk  __ARGS__(( int ));
	void   inidisk  __ARGS__(( void ));
	int    defdev   __ARGS__(( char* ));
	void   logdisk  __ARGS__(( int, char*, int ));
	void   takename __ARGS__(( char*, char* ));

	int    streamer __ARGS__(( int, void*, int ));
	long   ptr2abs  __ARGS__(( void far * ));
	void   qend     __ARGS__(( void ));
#endif
