#include <iodef.h>
#include <mylib.h>
#include <portable.h>

VOID tim0_set(UINT count)
{
  OUT_PORT(PC_TIM | TIM_CTL,0x36);
  OUT_PORT(PC_TIM | TIM_CH0,(UCHAR)count);      /* niederwertiger Teil */
  OUT_PORT(PC_TIM | TIM_CH0,(UCHAR)(count>>8)); /* hherwertiger Teil */
}

VOID tim0_init(VOID)
{
  OUT_PORT(PC_TIM|TIM_CTL,0x36);
  OUT_PORT(PC_TIM|TIM_CH2,0x00); /* Zeitkonstante niederwertiger Teil */
  OUT_PORT(PC_TIM|TIM_CH2,0x00); /* Zeitkonstante hherwertiger Teil */
}

UINT tim0_read(VOID)
{
  UINT h,l;
  l=IN_PORT(PC_TIM | TIM_CH0);
  h=IN_PORT(PC_TIM | TIM_CH0);
  return ((h<<8)+l);
}

enum COUNTERMODE { CTR_START, CTR_STOP, CTR_STOPREAD, CTR_SUSPEND, CTR_RESUME}; 

double counter(enum COUNTERMODE mode)
{
  static clock_t start;
  clock_t finish;
  static double duration;

  switch (mode)
  {
  default: return duration;
  case CTR_START:
    start = clock();
    duration = 0.0;
    return duration;
  case CTR_STOP:
    finish = clock();
    duration = duration + (double)(finish - start) / CLOCKS_PER_SEC;
    return duration;
  case CTR_STOPREAD:
    finish = clock();
    duration = duration + (double)(finish - start) / CLOCKS_PER_SEC;
    printf( "\n%f Sekunden\n", duration );
    return duration;
  case CTR_SUSPEND:
    finish = clock();
    duration = duration + (double)(finish - start) / CLOCKS_PER_SEC;
    return duration;
  case CTR_RESUME:
    start = clock();
    return duration;
  }
}

