;*****************************************************************************
; Quelldatei: TONERZ.ASM
; ----------------------
; Erzeugt Frequenzen gem der Tner einer Oktave und gibt
; diese auf dem Lautsprecher aus.
; Als Eingabe sind die Ziffern 0 bis 9 gltig. Bei CTRL-C wird
; abgebrochen.
;*****************************************************************************
; Programmdirektiven
;
; Small-Memory-Modell

    .MODEL SMALL

    .STACK 50		    ;50 Bytes Stapelspeicher

    EXTERN  WARTEN:FAR	    ;Prozedur WARTEN aus anderem Modul verwenden
;*****************************************************************************
; Datensegment

    .DATA

    TON  DW 1612    ;740 Hz fis
	 DW 2712    ;440 Hz a
	 DW 2560    ;466 Hz b
	 DW 2420    ;493 Hz h
	 DW 2281    ;523 Hz c
	 DW 2153    ;554 Hz cis
	 DW 2032    ;587 Hz d
	 DW 1918    ;622 Hz dis
	 DW 1810    ;659 Hz e
	 DW 1709    ;698 Hz f

;*****************************************************************************
; Codesegment

    .CODE
;-----------------------------------------------------------------------------
; Hauptprogramm
; =============
;
   .STARTUP		    ; DX, DS, SS, SP setzen

   MOV	AL,0B6H		    ;Timerkanal 2 fr
   OUT	43H,AL		    ;Modus 3 programmieren
SCHL:
   MOV	AH,1
   INT	21H		    ;Tastatur lesen mit Echo
   CMP	AL,30H
   JB	SCHL		    ;Prfen, ob Zifferntaste
   CMP	AL,39H		    ;0 bis 9
   JA	SCHL
   SUB	AL,30H		    ;Ascii -> Binr
   MOV	BL,AL
   IN	AL,61H		    ;bit 0 und 1 des Port B des
   OR	AL,3H		    ;8255 Chips auf 1 setzten
   OUT	61H,AL
   MOV	BH,0
   SHL	BX,1		    ;Tastenwert mit 2 multiplizieren
   MOV	AX,TON[BX]	    ;entspr. Frequenzteiler holen
   OUT	42H,AL		    ;LSB an Latchreg. ausgeben
   MOV	AL,AH
   OUT	42H,AL		    ;MSB an Latchreg. ausgeben
   MOV	AX,5
   CALL WARTEN		    ;1/2 Sekunde Ton stehen lassen
   IN	AL,61H
   AND	AL,0FCH 	    ;Ton abschalten
   OUT	61H,AL
   JMP	SCHL

   .Exit		    ;Mit Inhalt in AL zurck ins DOS
;*****************************************************************************
;			    ;Ende des Assemblerprogrammes
   END
