;*****************************************************************************
;
; Dieses Programm laedt den Interruptvektor fuer den
; Timerinterrupt um auf eine eigene Interruptprozedur,
; die exakt dasselbe macht wie die Original-ROM-BIOS
; Vers. 3.1 Prozedur, zusaetzlich jedoch bei jedem Aufruf die
; aktuelle Uhrzeit rechts oben am Bildschirm anzeigt
;
;*****************************************************************************
; Programmdirektiven
;
; Tiny-Memory-Modell

    .MODEL TINY

    .STACK 32			 ;32 Byte Stapelspeicher

;*****************************************************************************
; Code- und Datensegment

    .CODE
    .286

    ORG 100H                     ;um *.COM-Datei daraus zu machen

    .STARTUP

    JMP INSTALL

    VAR DW	?		 ;zum speichern der Bildschirm-Adresse

;-----------------------------------------------------------------------------
; Prozedur (resident)
; ===================
;
; TIMER_INT
; ---------
; Diese Prozedur wird bei jedem Timer-Interrupt 8 aufgerufen und aktualisiert
; die Uhrzeit und gibt diese rechts oben am Bildschirm aus.

TIMER_INT       PROC    FAR
    STI                         ;Interrupts erlauben
    PUSHA
    PUSH DS
    PUSH ES

    MOV AX,40H
    MOV DS,AX

    INC WORD PTR DS:[6CH]       ;TIMER_LOW
    JNZ T4
    INC WORD PTR DS:[6EH]       ;TIMER_HIGH

T4: CMP WORD PTR DS:[6EH], 018H ;TIMER_HIGH
    JNZ T5
    CMP WORD PTR DS:[6CH], 0B0H ;TIMER_LOW
    JNZ T5

    MOV WORD PTR DS:[6EH], 0    ;TIMER_HIGH
    MOV WORD PTR DS:[6CH], 0    ;TIMER_LOW
    MOV BYTE PTR DS:[70H], 1    ;TIMER_OFL

T5: DEC BYTE PTR DS:[40H]       ;MOTOR_COUNT
    JNZ T6
    AND BYTE PTR DS:[3FH], 0F0H ;MOTOR_STATUS
    MOV AL,0CH
    MOV DX,03F2H
    OUT DX,AL

T6: MOV AX,40H
    MOV ES,AX
    MOV AX,ES:[6EH]             ;ROM-BIOS Stunden
    MOV BL,10                   ;in zwei Dezimalziffern
    DIV BL                      ;aufspalten
    ADD AX,3030H                ;in ASCII-Code umwandeln

    MOV CX,CS:VAR               ;Startadresse des Bild-
    MOV DS,CX                   ;schirmspeichers
    MOV DS:[144],AL             ;Stunden-Zehner
    MOV BYTE PTR DS:[145],70H   ;Inverse Darstellung
    MOV DS:[146],AH             ;Stunden-Einer
    MOV BYTE PTR DS:[147],70H
    MOV BYTE PTR DS:[148],3AH   ;Doppelpunkt
    MOV BYTE PTR DS:[149],70H

    MOV DX,0
    MOV AX,ES:[6CH]             ;ROM-BIOS TIMER_LOW
    MOV BX,1092                 ;Divisor fuer Minuten
    DIV BX
    MOV BL,10
    DIV BL
    ADD AX,3030H
    MOV DS:[150],AL             ;Minuten-Zehner
    MOV BYTE PTR DS:[151],70H
    MOV DS:[152],AH             ;Minuten-Einer
    MOV BYTE PTR DS:[153],70H
    MOV BYTE PTR DS:[154],3AH
    MOV BYTE PTR DS:[155],70H

    MOV AX,DX
    MOV BH,18                   ;Divisor fuer Sekunden
    DIV BH
    MOV AH,0
    DIV BL
    ADD AX,3030H
    MOV DS:[156],AL             ;Sekunden-Zehner
    MOV BYTE PTR DS:[157],70H
    MOV DS:[158],AH             ;Sekunden-Einer
    MOV BYTE PTR DS:[159],70H

;***********************************************************
    INT 1CH                     ;Anschluss fuer Benutzerprozedur
    MOV AL,020H                 ;=EOI
    OUT 020H,AL

    POP ES
    POP DS
    POPA
    IRET
TIMER_INT ENDP

ENDE LABEL WORD 		; Ende des residenten Teils

;-----------------------------------------------------------------------------
; Hauptprogramm (nicht resident)
; ==============================
; Dieses Programm wird bei der Installation einmal aufgerufen und stellt
; die Adresse des Bildschirmspeichers fest und ldt den Interruptvektor
; fr INT 8 um. Es ist nicht resident und der beanspruchte Speicherplatz
; wird bei Start eines anderen Programms berschrieben.

INSTALL:
    MOV AX,0
    MOV DS,AX
    NOP
    MOV AH,0FH
    INT 10H                    ;Bildschirm-Modus lesen
    .IF (AL==2 || AL==3)
      MOV       CS:VAR,0B800H  ;Startadresse des Farbbildschirmspeichers
    .ELSEIF (AL==7)
      MOV       CS:VAR,0B000H  ;Startadresse des Monochrombildschirmspeichers
    .ELSE
      MOV       AH,4CH         ;Bildschirm ist auf ungeeigneten Modus eingestellt
			       ;Programm bleibt unwirksam
      INT 21H		       ;Rckkehr ins MS-DOS
    .ENDIF

;********* Umladen des Interruptvektors fuer INT 8 ************************
    CLI
    MOV WORD PTR DS:[32],OFFSET TIMER_INT
    MOV WORD PTR DS:[34], CS
    STI
    MOV DX,OFFSET ENDE    ;Neuer Programmbeginn = Ende des residenten Teils
    
    MOV AX,CS		  ;Code- und Datensegment gleich
    MOV DS,AX
    INT 27H		  ;Beenden, aber TIMER_INT bleibt resident
;**************************************************************************
    END
