;*****************************************************************************
; Quelldatei: DAYTIME.ASM
; =======================
;
; Beispiel einer DLL-Anwendung. WINDLL.DLL enthlt zwei exportierbare
; Bibliotheksfunktionen, welche von einem Windows-Programm aufgerufen
; werden knnen.
;
;      GetSysTime      Gibt einen Zeiger auf einen String in der Form
;                      st:mi:se zurck.
;
;      GetSysDate      Gibt einen Zeiger auf eine String zurck in der
;                      Form Tag, Monat, Jahr.
;
;      GetSysInfo      Returns a ptr to a structure containing various
;                      data from the the BIOS data areas.
;
;*****************************************************************************
; INCLUDE-Dateien

  INCLUDE win.inc
  INCLUDE dll.inc
;*****************************************************************************
; Prozedur-Prototypen der exportierten Funktionen

  GetSysTime    PROTO   FAR PASCAL
  GetSysDate    PROTO   FAR PASCAL
  GetSysInfo    PROTO   FAR PASCAL
;*****************************************************************************
; Programmdirektiven

  .MODEL        MEDIUM, PASCAL, FARSTACK
  .286

;*****************************************************************************
; Datensegment

  .DATA

  DayGer    STRZ    'Sonntag', 0,  'Montag', 0,     'Dienstag', 0
	    STRZ    'Mittwoch', 0, 'Donnerstag', 0, 'Freitag', 0
	    STRZ    'Samstag', 0

  MonGer    STRZ    'Januar', 0,   'Februar', 0,    'Mrz', 0
	    STRZ    'April', 0,    'Mai', 0,        'Juni', 0
	    STRZ    'Juli', 0,     'August', 0,     'September', 0
	    STRZ    'Oktober', 0,  'November', 0,   'Dezember', 0

sys         SYSINFO<>                  ; Datenstruktur fr Systeminformation
time        QUALTIME<>                 ; Datenstruktur fr Zeit
Date        STRZ    32 DUP(0)          ; Datenstruktur fr Datum

; indx ist ein Zeiger auf eine erweiterbare Liste von NPSTR-Zeigern.
; NPSTR ist ein NEAR-Zeiger auf einen Byte-String und in WIN.INC definiert.
; Damit knnen mehrere Sprachen von Wochentags- und Monatsbezeichnungen
; verarbeitet werden. Die Form mte dann so sein:
;         days  NPSTR   DayGer, Day Eng, DayFre
; Der Quellcode der exportierbaren Prozeduren mte auf diese Mglichkeiten
; angepat werden.

indx        WORD    0
days        NPSTR   DayGer
months      NPSTR   MonGer

;*****************************************************************************
; Codesegment

  .CODE

LibMain  PROC FAR PASCAL
sub     bx, bx                  ; Verwende 0 als Index fr die
mov     indx, bx                ; Sprachauswahl
ret
LibMain  ENDP

; Interne nichtexportierbare Prozeduren
;--------------------------------------
; IntToAsc
; --------
; Konvertiert eine Binrzahl in AL in ASCII-Ziffern. Dreht die Ziffern
; um, soda '12' zu einer '21' wird.
; Eingang:     AX      = Binrzahl
; Ausgang:     DX:AX   = ADCII-Ziffern

IntToAsc  PROC NEAR USES cx
cwd                     ; DX-Register lschen
mov     cx, 100         ; Dividiere AX durch 100
div     cx              ; AX = Quotient, DX = Rest
aam                     ; Konvertiere in ungepackte BCDs
or      ax, '00'        ; Konvertiere in ASCII-Zahlen
xchg    ah, al          ; Drehe Ziffern um
xchg    dx, ax
aam
or      ax, '00'
xchg    ah, al
.IF (al=='0')           ; Fhrende Nullen in Leerzeichen
  mov al, 20H           ; konvertieren
.ENDIF
ret                     ; ASCII Ziffern in DX:AX zurckgeben
IntToAsc    ENDP

; Exportierbare Bibliotheks-Prozeduren
; ------------------------------------
OPTION  PROLOGUE:None   ; Keinen automatischen Prolog und
OPTION  EPILOGUE:None   ; Epilog generieren

; GetSysInfo
; ----------
; Bekommt die Versionsnummer von DOS und Windows und konvertiert
; diese in ASCII-Ziffern.
;
; Eingang:      Nichts
; Ausgang:      DX:AX = FAR-Zeiger auf Versionsstring

GetSysInfo      PROC    FAR EXPORT
Prolog
INVOKE GetVersion                ; DOS- und Windows-Version bekommen
mov      bx, dx                  ; Sichere DOS-Version in BX
push ax
cbw                              ; AX = Windows-Hauptversionsnummer
call IntToAsc                    ; In ASCII-Ziffern konvertieren
mov      WORD PTR sys.szWinVer, ax
pop      ax                      ; AX = Windows-Nebenversionsnummer
xchg ah, al
cbw
call IntToAsc                    ; In ASCII-Ziffern konvertieren
mov      WORD PTR sys.szWinVer[3], ax
mov      ax, bx                  ; AX = DOS-Versionsnummer
xchg ah, al
cbw                              ; AX = DOS-Hauptversionsnummer
call IntToAsc                    ; In ASCII-Ziffern konvertieren
mov      WORD PTR sys.szDOSVer, ax
mov      ax, bx
cbw                              ; AX = DOS-Nebenversionsnummer
call IntToAsc                    ; In ASCII-Ziffern konvertieren
mov      WORD PTR sys.szDOSVer[3], ax
mov     dx, ds                   ; Return far pointer
mov     ax, OFFSET sys           ;   to structure in DX:AX
Epilog                           ; Epilogue macro
ret
GetSysInfo      ENDP

; GetSysTime
; ----------
; Gibt einen Zeiger auf einen String in der Form
; st:mi:se zurck.
;
; Eingang:  Nichts
; Ausgang:  DX:AX = FAR-Zeiger  auf Zeit-String

GetSysTime  PROC FAR EXPORT
Prolog                          ; Prolog-Macro
mov     ah, 2Ch                 ; DOS Interrupt 2Ch
call    DOS3Call                ; Systemzeit
mov     ax, '  '                ; AX mit Leerzeichen laden
push    dx                      ; Sekunden sichern
mov     al, ch
cbw                             ; AX = Stunden
call    IntToAsc                ; In ASCII-Ziffern konvertieren
mov     time.wHour, ax          ; und in Datenstrucktur speichern
mov     al, cl
cbw                             ; AX = Minuten
call    IntToAsc                ; In ASCII-Ziffern konvertieren
mov     time.wMin, ax           ; und in Datenstrucktur speichern
pop     ax                      ; AH = Sekunden
mov     al, ah
cbw
call    IntToAsc                ; In ASCII-Ziffern konvertiere
mov     time.wSec, ax           ; und in Datenstrucktur speichern
mov     dx, ds                  ; Mit FAR-Zeiger in DX:AX
mov     ax, OFFSET time         ; zurck ins aufrufende Programm
Epilog
ret
GetSysTime  ENDP

; GetSysDate
; ----------
; Gibt einen Zeiger auf eine String zurck in der
; Form Tag, Monat, Jahr.
;
; Eingang:  Nichts
; Ausgang:  DX:AX = FAR-Zeiger  auf Zeit-String

GetSysDate  PROC FAR EXPORT
Prolog
mov     ah, 2Ah                 ; DOS Interrupt 2Ah
call    DOS3Call                ; Bekomme System-Datum
push    cx                      ; Sichere das Jahr
push    ds
pop     es                      ; ES = DS
mov     bx, indx                ; BX = Zeiger fr die Sprache
mov     di, days[bx]            ; ES:DI = Zeiger auf Wochentage
cbw                             ; In ASCII-Zeichen konvertieren
xchg    ah, al                  ; AH = Wochentag

.WHILE  ( ah )                  ; Zhle AH-mal bis zum richtigen String
  mov   cl, 255
  repne scasb                   ; String kopieren
  dec   ah
.ENDW

mov     si, di                  ; DS:SI = Zeiger auf Tagesstring
mov     di, OFFSET Date         ; ES:DI = Zeiger auf Puffer
		
.REPEAT
  lodsb                         ; Kopiere Puffer in Tagesstring
  stosb                         ; bis Null erreicht wird
.UNTIL  ( !al )

dec     di                      ; ES:DI zeigt auf das Ende des Tagesstrings
mov     ax, '  '                ; Lerrzeichen anhngen
stosw

mov     al, dl                  ; DL = Monatstag
cbw                             ; in AX kopieren
call    IntToAsc                ; In ASCII-Zeichen konvertieren
stosw                           ; und kopieren
mov     ax, ' .'                ; Mit Punkt abschlieen
stosw

mov     si, di                  ; Aktuelle Puffer-Position abspeichern
mov     di, months[bx]          ; ES:DI = Zeiger auf String

sub     al, al
mov     cl, 255
repne   scasb
dec     dh

xchg    si, di                  ; DS:SI = Zeiger auf Monatsstring
.REPEAT                         ; ES:DI = Zeiger auf Puffer
  lodsb                         ; Monatsstring kopieren
  stosb
.UNTIL  ( !al )
mov     BYTE PTR [di-1], ' '    ; Mit einem Leerzeichen abschlieen

pop     ax                      ; AX = Jahr
call    IntToAsc                ; In ASCII-Ziffer konvertieren
xchg    dx, ax                  ; und mit '19' ergnzen
stosw
xchg    dx, ax                  ; AX = Zehner und Einer-Jahre
stosw                           ; String kopieren
sub     al, al                  ; String mit 0 terminieren
stosb                           ;
mov     dx, ds                  ; Mit FAR-Zeiger in DX:AX zurck
mov     ax, OFFSET Date         ; ins aufrufrufende Programm
Epilog
ret
GetSysDate  ENDP

; Plaziere die WEP-Prozedur in ein eigenes Segment und setze PRELOAD FIXED
; in die Moduldefinitionsdatei DAYTIME.DEF.
;
CODE2   SEGMENT WORD 'CODE'
	ASSUME  cs:CODE2

; WEP
; ---
; Diese Prozedur wird vor dem Freigeben des Speicherplatzes einer DLL
; aufgerufen. Sie wird von Windows gerufen, falls entweder Windows be-
; endet wird oder eine API-Funktion den Speicherplatz der DLL wieder
; freigeben will.
;
; Eingang:  wExitCode = 0 falls der Speicherplatz der DLL freigegeben wird.
;                     = 1 falls Windows beendet wird.
; Ausgang:  AX        = 1 Returnwert

WEP  PROC    FAR EXPORT
     Prolog
     mov     ax, TRUE                              ; Returnwert AX = 1
     Epilog
     ret
WEP  ENDP

CODE2   ENDS

END
