;*****************************************************************************
;
; Quelldatei: WINDEMO.ASM
; -----------------------
; Liest verschiedene Systeminformationen und gibt diese mit aufrufbaren
; Menpunkten und Nachrichtenfeldern am Bildschirm aus. Die Informationen
; werden ber API- und DLL-Funktionen erhalten.
;
;*****************************************************************************
; INCLUDE-Datei

  INCLUDE win.inc
;*****************************************************************************
; Prozedur-Prototypen

  WinMain         PROTO PASCAL, hInstance:HANDLE,  hPrevInstance:HANDLE,
				lpszCmdLine:LPSTR, nCmdShow:SWORD

  WndProc         PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD

  GetSysTime      PROTO FAR PASCAL                ; DLL-Prozeduren
  GetSysDate      PROTO FAR PASCAL
  GetSysInfo      PROTO FAR PASCAL
;*****************************************************************************
; Programmdirektiven

  .MODEL SMALL, PASCAL, NEARSTACK
  .286

;*****************************************************************************
; Datensegment

  .DATA

  M_B_DOS_WIN           EQU 10          ; Konstanten fr Menereignisse
  M_B_CPU               EQU 11          ; (entsprechen den Werten in
  M_B_TASK              EQU 12          ; Resourcedatei WINDEMO.RC)
  M_B_DATUM             EQU 13
  M_B_ZEIT              EQU 14
  M_B_BEENDEN           EQU 15
  M_B_INFO              EQU 80

  extern __astart:proc                                ; Start-Code fr Windows

szAppName       SBYTE "MASM-Windows-Programm",0       ; Anwendungsname

szMS_DOS        SBYTE "DOS- und Windows-Version:",0   ; Texte fr
szProzessor     SBYTE "Prozessor:",0                  ; Nachrichtenfelder
sz286           SBYTE "80286",0
sz386           SBYTE "80386",0
sz486           SBYTE "80486 oder Pentium",0
szTasks         SBYTE "Anzahl der gestarteten Windows-Anwendungen:",0
szInfo          SBYTE "Version 1.0 meines erstes MASM Windows-Programmes",0
szNumTasks      SBYTE "  ",0
szZeit          SBYTE "Stunden:Minuten:Sekunden",0
szBeenden       SBYTE "Wollen Sie das Programm beenden?",0
szDummy         BYTE  " ",0

szMenu          SBYTE "MyMenu",0                  ; Menname aus WINDEMO.RC

hMen            HANDLE  ?

;*****************************************************************************
; Codesegment

  .CODE

; IntToAsc
; --------
; Konvertiert eine Binrzahl in AL in ASCII-Ziffern. Dreht die Ziffern
; um, soda '12' zu einer '21' wird.
; Eingang:     AX      = Binrzahl
; Ausgang:     DX:AX   = ASCII-Ziffern
;

IntToAsc  PROC NEAR USES cx
cwd                     ; DX-Register lschen
mov     cx, 100         ; Dividiere AX durch 100
div     cx              ; AX = Quotient, DX = Rest
aam                     ; Konvertiere in ungepackte BCDs
or      ax, '00'        ; Konvertiere in ASCII-Zahlen
xchg    ah, al          ; Drehe Ziffern um
xchg    dx, ax
aam
or      ax, '00'
xchg    ah, al
.IF (al=='0')           ; Fhrende Nullen in Leerzeichen
  mov al, 20H           ; konvertieren
.ENDIF
ret                     ; ASCII Ziffern in DX:AX zurckgeben
IntToAsc  ENDP

; WndProc
; -------
; Verarbeitet alle Nachrichten, die an das Fenster der Anwendung
; geschickt werden.

WndProc  PROC FAR PASCAL, hWnd:HWND, iMessage:WORD, wParam:SWORD, lParam:SDWORD

.IF     (iMessage == WM_DESTROY)                ; Fenster schlieen?
  INVOKE  PostQuitMessage, 0
  ret
.ELSEIF (iMessage  == WM_CREATE)                ; Fenster anzeigen?
  INVOKE GetMenu, hWnd                          ; Handle des Mens
  INVOKE EnableMenuItem, ax, 17, MF_GRAYED      ; bekommen und anzeigen
  ret
.ELSEIF (iMessage  == WM_COMMAND)               ; Men-Auswahl:
  .IF (wParam == M_B_DOS_WIN)                   ; DOS- und Windos-Version?
    INVOKE GetSysInfo                           ; DLL-Funktion
    INVOKE MessageBox, hWnd, dx::ax, ADDR szMS_DOS,
		       MB_ICONINFORMATION OR MB_OK
    ret
  .ELSEIF (wParam == M_B_CPU)    ; Prozessortyp anzeigen?
    INVOKE GetWinFlags
    .IF (AX & WF_CPU286)         ; Teste Bit des Prozessorflags
     INVOKE MessageBox, hWnd, ADDR sz286, ADDR szProzessor,
			 MB_ICONINFORMATION OR MB_OK
    .ELSEIF (AX & WF_CPU386)
      INVOKE MessageBox, hWnd, ADDR sz386, ADDR szProzessor,
			 MB_ICONINFORMATION OR MB_OK
    .ELSEIF (AX & WF_CPU486)
      INVOKE MessageBox, hWnd, ADDR sz486, ADDR szProzessor,
			 MB_ICONINFORMATION OR MB_OK
    .ENDIF
    ret
   .ELSEIF (wParam == M_B_TASK)    ; Anzahl der Tasks?
     INVOKE GetNumTasks
     call  IntToAsc                ; In ASCII-Ziffern konvertieren
     mov WORD PTR szNumTasks, ax
     INVOKE MessageBox, hWnd, ADDR szNumTasks, ADDR szTasks,
			MB_ICONEXCLAMATION OR MB_OK
     ret
   .ELSEIF (wParam == M_B_DATUM)   ; Datum anzeigen?
     INVOKE GetSysDate             ; DLL-Funktion
     INVOKE MessageBox, hWnd, dx::ax, ADDR szDummy,
			MB_ICONEXCLAMATION OR MB_OK
     ret
   .ELSEIF (wParam == M_B_ZEIT)    ; Zeit anzeigen?
     .REPEAT
       INVOKE GetSysTime           ; DLL-Funktion
       INVOKE MessageBox, hWnd, dx::ax, ADDR szZeit,
			  MB_ICONEXCLAMATION OR MB_RETRYCANCEL
     .UNTIL (ax==IDCANCEL)
     ret
   .ELSEIF (wParam == M_B_BEENDEN)                ; Programm beenden?
     INVOKE MessageBeep, 0
     INVOKE MessageBox, hWnd, ADDR szBeenden, ADDR szAppName, MB_YESNO
     .IF (ax==IDYES)
       INVOKE PostQuitMessage, 0   ; Falls mit ja besttigt, beenden
     .ELSE
       ret
     .ENDIF
     ret
   .ELSEIF (wParam == M_B_INFO)
     INVOKE MessageBox, hWnd, ADDR szInfo, ADDR szInfo,
			MB_ICONINFORMATION OR MB_OK
     ret
   .ENDIF

  .ELSE                            ; Nicht bearbeitete Nachricht abfangen
    INVOKE DefWindowProc, hWnd, iMessage, wParam,lParam
    ret
  .ENDIF

  mov ax, 0                        ; Nachrichtenbearbeitung beenden
  cwd
  ret

WndProc  ENDP
;-----------------------------------------------------------------------------
; Hauptprogramm
; =============
WinMain  PROC, hInstance:HANDLE, hPrevInstance:HANDLE,
	       lpszCmdLine:LPSTR, nCmdShow:SWORD

LOCAL   msg:MSG, wndclass:WNDCLASS

.IF (hPrevInstance == 0)        ; Falls Anwendung noch nicht gestartet,
				; Fenster und Anwendung registrieren
  lea   di, wndclass
  ASSUME  di:PTR WNDCLASS

  mov  [di].style, NULL
  mov  WORD PTR [di].lpfnWndProc, LROFFSET WndProc
  mov  WORD PTR [di].lpfnWndProc+2, SEG WndProc
  xor  ax,ax
  mov  [di].cbClsExtra, ax
  mov  [di].cbWndExtra, ax

  INVOKE  LoadIcon, NULL, IDI_APPLICATION
  mov  [di].hIcon, ax

  mov  ax, hInstance
  mov  [di].hInstance, ax

  INVOKE  LoadCursor, NULL, IDC_ARROW
  mov  [di].hCursor, ax

  INVOKE  GetStockObject, GRAY_BRUSH
  mov  [di].hbrBackground, ax

  xor  ax, ax
  mov  WORD PTR [di].lpszMenuName, ax
  mov  WORD PTR [di].lpszMenuName+2, ax

  mov  WORD PTR [di].lpszClassName, OFFSET szAppName
  mov  WORD PTR [di].lpszClassName+2, ds

  INVOKE  RegisterClass, di
  .IF (ax == 0)
    mov    ax, FALSE
    ret
  .ENDIF

  ASSUME  di:NOTHING

.ENDIF

; Fenster auf Basis der oben beschriebenen Fensterklasse erzeugen
;

INVOKE  LoadMenu, hInstance, ADDR szMenu

mov hMen, ax                                 ; Handle des Mens sichern
INVOKE  CreateWindow, ADDR szAppName, ADDR szAppName, WS_OVERLAPPEDWINDOW,
		      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		      CW_USEDEFAULT, NULL, hMen, hInstance, NULL

.IF (ax == 0)                                ; Bei Fehler Programm abbrechen
  mov ax, FALSE
  ret
.ENDIF

; Fenster erfolgreich angelegt und Handle nach Register si

mov     si, ax

INVOKE  ShowWindow, si, SW_SHOWNORMAL        ; Fenster anzeigen
INVOKE  UpdateWindow, si

.WHILE TRUE                                  ; Nachrichtenschleife
  INVOKE  GetMessage,     ADDR msg, 0, 0, 0
  .BREAK .IF (ax == 0)                       ; Bei Programmende Schleife
  INVOKE  TranslateMessage, ADDR msg         ; verlassen
  INVOKE  DispatchMessage,  ADDR msg
.ENDW

mov     ax, msg.wParam                       ; Zurck zu Windows
ret

WinMain  ENDP

END  __astart
