;*****************************************************************************
;
; Quelldatei: WOCHENT.ASM
; -----------------------
; bungsprogramm um Sie mit der PWB und dem CODEVIEW-Debugger
; vertraut zu machen.
;
;*****************************************************************************
; Prozedur-Prototypen

    ZeichenEinlesen PROTO NEAR C
    SchreibString PROTO NEAR C String:PTR WORD, Auswahl:BYTE
    SchreibNr PROTO NEAR C Auswahlzeichen:BYTE

;*****************************************************************************
; Programmdirektiven
;
; Small-Memory-Modell

    .MODEL SMALL, C

PUBLIC SegAdresse

     .STACK                        ;1 kByte Stapelspeicher

;*****************************************************************************
; Datensegment

    .DATA

Montag          DB 'Montag',10,13,'$'             ; Wochentage
Dienstag        DB 'Dienstag',10,13,'$'
Mittwoch        DB 'Mittwoch',10,13,'$'
Donnerstag      DB 'Donnerstag',10,13,'$'
Freitag         DB 'Freitag',10,13,'$'
Samstag         DB 'Samstag',10,13,'$'
Sonntag         DB 'Sonntag',10,13,'$'
;
Auswahl_1       DB '1','$'                        ; Tastenkrzel fr Wochen-
Auswahl_2       DB '2','$'                        ; tage
Auswahl_3       DB '3','$'
Auswahl_4       DB '4','$'
Auswahl_5       DB '5','$'
Auswahl_6       DB '6','$'
Auswahl_7       DB '7','$'
Auswahl_Ende    DB '8','$'

Eingabe         DB 'Geben Sie eine Ziffer fr den Wochentag von 1 - 8 ein:',10,13,'$'
TagAuswahl      DB 'Sie whlten den Wochentag','$'
FalscheTaste    DB 10,13,'Unerlaubte Taste, bitte erneut whlen!',10,13, '$'

SegAdresse      DW      ?       ; 16Bit Segmentadresse
;*****************************************************************************
; Codesegment

    .CODE
;-----------------------------------------------------------------------------
; Hauptprogramm
; =============
;
; Gibt den Wochentag gem der eingegebenen Ziffer am Bildschirm aus.
; Auswahl aus. Bei der Eingabe der Ziffer 8 wird das Programm abgebrochen.

   .STARTUP                                    ; DX, DS, SS, SP setzen


   mov    [SegAdresse],SEG Montag              ; Segmentadresse feststellen

   INVOKE SchreibString, ADDR Eingabe, ' '      ; Aufforderung zur Zifferneingabe

   .WHILE 1                                    ; Endlosschleife
     INVOKE ZeichenEinlesen

     INVOKE SchreibString, ADDR TagAuswahl, ' '   ; Auswahl ankndigen

     .IF (AL==Auswahl_1)                          ; Ausgewhlten Tag
	INVOKE SchreibString, ADDR Montag, ' '    ; auslisten
     .ELSEIF (AL==Auswahl_2)
	INVOKE SchreibString, ADDR Dienstag, ' '
     .ELSEIF (AL==Auswahl_3)
	INVOKE SchreibString, ADDR Mittwoch, ' '
     .ELSEIF (AL==Auswahl_4)
	INVOKE SchreibString, ADDR Donnerstag, ' '
     .ELSEIF (AL==Auswahl_5)
	INVOKE SchreibString, ADDR Freitag, ' '
     .ELSEIF (AL==Auswahl_6)
	INVOKE SchreibString, ADDR Samstag, ' '
     .ELSEIF (AL==Auswahl_7)
	INVOKE SchreibString, ADDR Sonntag, ' '
     .ELSEIF (AL!=Auswahl_Ende)
	INVOKE SchreibString, ADDR FalscheTaste, ' '
     .ENDIF

   .BREAK .IF (AL==Auswahl_Ende)     ; 'Programm beenden': Schleife abbrechen
   .ENDW                             ; Ende der WHILE-Schleife

   .Exit                             ; Mit Inhalt in AL zurck ins DOS
;*****************************************************************************
				     ; Ende des Assemblerprogrammes
   END
