;*****************************************************************************
;
; Quelldatei: WOCHPROC.ASM
; ------------------------
; bungsprogramm um Sie mit der PWB und dem CODEVIEW-Debugger
; vertraut zu machen. Diese Datei enthlt die vom Hauptprogramm
; WOCHENT.ASM verwendeten Prozeduren.
;
;*****************************************************************************
; Prozedur-Prototypen

    ZeichenEinlesen PROTO NEAR C
    SchreibString PROTO NEAR C String:PTR WORD, Auswahl:BYTE
    SchreibNr PROTO NEAR C Auswahlzeichen:BYTE

;*****************************************************************************
; Programmdirektiven
;
; Small-Memory-Modell

    .MODEL SMALL, C

;*****************************************************************************
; Externe Variablen

    EXTERN SegAdresse:WORD

;*****************************************************************************
; Codesegment

       .CODE

; Prozeduren
; ==========
;
; ZeichenEinlesen
; ---------------
; Liest ein Zeichen von der Tastatur und schreibt dieses in das AL-Register.
;
ZeichenEinlesen PROC C PUBLIC
    mov    ah,07h                ; Attribut 07h: Zeichen einlesen
    int    21h                   ; DOS-Interrupt
    ret
ZeichenEinlesen ENDP             ; SchreibString
;
; SchreibString
; -------------
; Gibt einen String am Bildschirm aus mittels der DOS-Interrupt-Funktion 21h.
;
SchreibString PROC C PUBLIC USES ds dx, String:PTR WORD, Auswahl:BYTE
    INVOKE SchreibNr, Auswahl    ; Auswahlzeichen ausgeben
    mov    ds,[SegAdresse]       ; Segmentadressen laden
    mov    dx,String             ; Offsetadresse laden
    mov    ah,09h                ; Attribut 9h: String bis zum $ ausgeben
    int    21h                   ; DOS-Interrupt
    ret
SchreibString ENDP

; SchreibNr
; ---------
; Gibt ein ASCII-Zeichen auf dem Bildschirm aus mittels der DOS-Interrupt-
; Funktion 21h.
;
SchreibNr PROC C PUBLIC USES dx, Auswahlzeichen:BYTE
    mov    dl,Auswahlzeichen
    mov    ah,02h                ; Attribut 2h: Zeichen ausgeben
    int    21h                   ; DOS-Interrupt
    ret
SchreibNr ENDP
       END
