;*****************************************************************************
;
; Quelldatei: MASMDEMO.ASM
; ------------------------
;
; Demonstrationsprogramm fr PROTO-, PROC-, INVOKE-, WHILE, und BREAK-Direktiven.
;
; Es werden 9 Zeilen am Bildschirm mit der Zeilennummer und dem String
; "Hallo Welt" ausgegeben.
;
;*****************************************************************************
; Definitinionen

MAX_ZEILENR  equ  39h                   ; Maximale Zeilennummer ist ASCII 9
;*****************************************************************************
; Prozedur-Prototypen

    SchreibString PROTO NEAR C
    SchreibNr PROTO NEAR C ZeileNr:BYTE

;*****************************************************************************
; Macros

; INIIT_ADR
;
; Mit diesem Macro wird die Adresse der angegebenen Stringvariable ermittelt. Die
; Paragraphennummer (Segmentadresse) und die Offsetadresse werden in SegAdresse
; und SegOffset abgespeichert.

INIT_ADR MACRO name
    mov    [SegAdresse],SEG name
    mov    [SegOffset],OFFSET name
    ENDM

;*****************************************************************************
; Programmdirektiven
;
; Small-Memory-Modell und Prozeduren kompatibel zur C-Hochsprache

    .Model small,C

    .STACK                        ;1 kByte Stapelspeicher

;*****************************************************************************
; Datensegment

    .DATA

hallo   db      '. Hallo Welt',
		10,     ; ASCII-Zeichen fr neue Zeile
		13,     ; und Anfang der Zeile
		'$',0   ; $ wird als Stringende fr BIOS-Routine int 21h 09h
			; bentigt
Zeile      db   31h     ; ASCII-Zeichen fr 1. Zeile
SegAdresse dw   ?       ; 16Bit Segmentadresse
SegOffset  dw   ?       ; 16Bit Offsetadresse

;*****************************************************************************
; Codesegment

    .CODE
;-----------------------------------------------------------------------------
; Prozeduren
; ==========
;
; SchreibString
; -------------
; Mit dieser Procedur wird ein String am Bildschirm ausgegeben mittels der BIOS-
; Interrupt-Funktion 21h.

SchreibString PROC C PUBLIC USES ds dx
    mov    ds,[SegAdresse]       ; Adressen des
    mov    dx,[SegOffset]        ; Strings laden
    mov    ah,09h                ; Attribut 9h: String bis zum $ ausgeben
    int    21h                   ; Bios-Interrupt
    ret
SchreibString ENDP

; SchreibNr
; ---------
; Mit dieser Prozedur wird ein ASCII-Zeichen auf dem Bildschirm ausgegeben
; mittels der BIOS-Interrupt-Funktion 21h.

SchreibNr PROC C PUBLIC USES dx, ZeilenNr:BYTE
    mov    dl,ZeilenNr
    mov    ah,02h                ; Attribut 2h: Zeichen ausgeben
    int    21h                   ; Bios-Interrupt
    ret
SchreibNr ENDP

;-----------------------------------------------------------------------------
; Hauptprogramm
; =============
;
; Gibt 9 Zeilen am Bildschirm mit der Zeilennummer und dem String
; "Hallo Welt" aus.

   .Startup                          ; dx, ds, ss, sp setzen

   INIT_ADR hallo ; Adresse der Variablen hallo ermitteln

   .WHILE 1                          ; Endlosschleife
     INVOKE SchreibNr, Zeile         ; Zeilennummer ausgeben
     INVOKE SchreibString            ; String ausgeben
     .BREAK .IF (Zeile==MAX_ZEILENR) ; nach Zeile 9 WHILE-Schleife abbrechen

     inc        Zeile                ; Zeilennummer erhhen
   .ENDW                             ; Ende der WHILE-Schleife

   .Exit                             ; Mit Inhalt in AL zurck ins DOS
;*****************************************************************************
				     ; Ende des Assemblerprogrammes
   END
