;*****************************************************************************
;
; Quelldatei: MENU.ASM
; --------------------
;
; Demonstrationsprogramm fr .MODEL-, .STACK-, .STURTUP-, .DATA-, .CODE-,
; PROTO-, PROC-, INVOKE-, .IF-, .WHILE-, und .BREAK-Direktiven.
;
; Dieses Programm gibt ein Men am Bildschirm aus und lt die Eingabe
; einer Auswahlziffer zu. Der ausgewhlte Menpunkt wird ausgegeben.
;
;*****************************************************************************
; Prozedur-Prototypen

    ZeichenEinlesen PROTO NEAR C
    SchreibString PROTO NEAR C String:PTR WORD, Auswahl:BYTE
    SchreibNr PROTO NEAR C Auswahlzeichen:BYTE

;*****************************************************************************
; Programmdirektiven
;
; Small-Memory-Modell und Prozeduren kompatibel zur C-Hochsprache

    .MODEL SMALL, C

    .STACK                        ;1 KByte Stapelspeicher

;*****************************************************************************
; Datensegment

    .DATA

Menuepunkt_1    DB ' Datei ffnen',10,13,'$'      ; Menpunkte
Menuepunkt_2    DB ' Datei speichern',10,13,'$'
Menuepunkt_3    DB ' Datei lschen',10,13,'$'
Menuepunkt_4    DB ' Datei drucken',10,13,'$'
Menuepunkt_5    DB ' Datei schlieen ',10,13,'$'
Menuepunkt_6    DB ' Programm beenden',10,13,'$'
;
Auswahl_1       DB '1','$'                        ; Tastenkrzel fr Menue-
Auswahl_2       DB '2','$'                        ; aufrufe
Auswahl_3       DB '3','$'
Auswahl_4       DB '4','$'
Auswahl_5       DB '5','$'
Auswahl_6       DB '6','$'

MenueAuswahl    DB 'Sie whlten den Menpunkt','$'
FalscheTaste    DB 'Unerlaubte Taste, bitte erneut whlen!',10,13,'$'

SegAdresse      DW      ?       ; 16Bit Segmentadresse

;*****************************************************************************
; Codesegment

    .CODE
;-----------------------------------------------------------------------------
; Prozeduren
; ==========
;
; ZeichenEinlesen
; ---------------
; Liest ein Zeichen von der Tastatur und schreibt dieses in das AL-Register.
;
ZeichenEinlesen PROC C PUBLIC
    mov    ah,07h                ; Attribut 07h: Zeichen einlesen
    int    21h                   ; DOS-Interrupt
    ret
ZeichenEinlesen ENDP             ; SchreibString
;
; SchreibString
; -------------
; Gibt einen String am Bildschirm aus mittels der DOS-Interrupt-Funktion 21h.
;
SchreibString PROC C PUBLIC USES ds dx, String:PTR WORD, Auswahl:BYTE
    INVOKE SchreibNr, Auswahl    ; Auswahlzeichen ausgeben
    mov    ds,[SegAdresse]       ; Segmentadressen laden
    mov    dx,String             ; Offsetadresse laden
    mov    ah,09h                ; Attribut 9h: String bis zum $ ausgeben
    int    21h                   ; DOS-Interrupt
    ret
SchreibString ENDP

; SchreibNr
; ---------
; Gibt ein ASCII-Zeichen auf dem Bildschirm aus mittels der DOS-Interrupt-
; Funktion 21h.
;
SchreibNr PROC C PUBLIC USES dx, Auswahlzeichen:BYTE
    mov    dl,Auswahlzeichen
    mov    ah,02h                ; Attribut 2h: Zeichen ausgeben
    int    21h                   ; DOS-Interrupt
    ret
SchreibNr ENDP

;-----------------------------------------------------------------------------
; Hauptprogramm
; =============
;
; Listet Menpunkte mit ihren Tastenkrzeln am Bildschirm aus.
; Bei Aktivieren von 'Programm beenden' wird abgebrochen.

   .STARTUP                                    ; DX, DS, SS, SP setzen



   mov    [SegAdresse],SEG Menuepunkt_1        ; Segmentadresse feststellen

   INVOKE SchreibString, ADDR Menuepunkt_1, Auswahl_1
   INVOKE SchreibString, ADDR Menuepunkt_2, Auswahl_2
   INVOKE SchreibString, ADDR Menuepunkt_3, Auswahl_3
   INVOKE SchreibString, ADDR Menuepunkt_4, Auswahl_4
   INVOKE SchreibString, ADDR Menuepunkt_5, Auswahl_5
   INVOKE SchreibString, ADDR Menuepunkt_6, Auswahl_6

   .WHILE 1                                    ; Endlosschleife
     INVOKE ZeichenEinlesen
     mov BL,AL                                 ; Zeichen in Register BL kopieren

     INVOKE SchreibString, ADDR MenueAuswahl, ' '   ; Men auslisten

     .IF (BL==Auswahl_1)                            ; Ausgewhlten Menpunkt
	INVOKE SchreibString, ADDR Menuepunkt_1, ' '; auslisten
     .ELSEIF (BL==Auswahl_2)
	INVOKE SchreibString, ADDR Menuepunkt_2, ' '
     .ELSEIF (BL==Auswahl_3)
	INVOKE SchreibString, ADDR Menuepunkt_3, ' '
     .ELSEIF (BL==Auswahl_4)
	INVOKE SchreibString, ADDR Menuepunkt_4, ' '
     .ELSEIF (BL==Auswahl_5)
	INVOKE SchreibString, ADDR Menuepunkt_5, ' '
     .ELSEIF (BL==Auswahl_6)
	INVOKE SchreibString, ADDR Menuepunkt_6, ' '
     .ELSE                                          ; Falsche Eingabe abfangen
	INVOKE SchreibString, ADDR FalscheTaste, ' '
     .ENDIF

   .BREAK .IF (BL==Auswahl_6)        ; 'Programm beenden': Schleife abbrechen
   .ENDW                             ; Ende der WHILE-Schleife

   .Exit                             ; Mit Inhalt in AL zurck ins DOS
;*****************************************************************************
				     ; Ende des Assemblerprogrammes
   END
