;Programm AKAKTv2.LSP: Kfiglufer (IP 44 IC 4) Aktivteil
;erstellt von J. Tschelienig, SS 1995
(defun c:akakt ()
;Definition Begrungstext 
 (defun hilfe ()
   (setq titel1 "Befehl AKAKT zeichnet den Aktivteil einer DAM-KL"
         titel1ff "Einfgepunkt = Wellenende links, Mittellinie"
   )
   (princ titel1)
   (princ)
   (terpri)
   (princ titel1ff)
   (princ)
 )
 (hilfe) 
 ;Abfrage der Abmessungen                               Def.der Var.
 (setq e (getpoint "\nEinfgepunkt zeigen: ")                   ;e
       h (getreal "\nAchshhe (mm)= ")                          ;h
       db (getreal "\nBohrungsdurchm. (mm)= ")                  ;db
       lfe (getreal "\nEisenlnge (mm)= ")                      ;lfe
       lluft (getreal "\nLuftspaltlnge (mm)= ")                ;lluft
       dwe (getreal "\nWellenende-D (mm)= ")                    ;dwe
       lwe (getreal "\nWellenende-L(mm)= ")                     ;lwe
       dwla (getreal "\nLager AS, Innendurchm.(mm)= ")          ;dwla
       bla (getreal "\nLager AS, Breite (mm)= ")                ;bla
       dla (getreal "\nLager AS, Auendurchm.(mm)= ")           ;dla
       hnaba (getreal "\nLagernabe AS, Dicke (mm)= ")           ;hnaba
 )  ;setq - Klammer zu
;Vorschlagswerte Lagerstelle, Wellendicke innen, Abfrage, bernahme
 (setq vbnaba (+ 10 bla))    ;vlla
          (princ "\n Lagernabe AS, Breite (mm) ")
          (princ " = <")
          (princ vbnaba)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq bnaba (getreal)) ;bnaba eingeben                 ;bnaba
          (cond ((null bnaba) (setq bnaba vbnaba))) ;Vorschlag bernehmen
 (setq vlla (+ 30 bla))    ;vlla
          (princ "\nLnge Lagerstelle AS (mm) ")
          (princ " = <")
          (princ vlla)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq lla (getreal)) ;lla eingeben                     ;lla
          (cond ((null lla) (setq lla vlla))) ;Vorschlag bernehmen
 (setq vdwi (+ dwla 10))   ;vdwi
          (princ "\nWellendurchm. zwischen Lagern (mm) ")
          (princ " = <")
          (princ vdwi)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq dwi (getreal))  ;dwi eingeben                    ;dwi
          (cond ((null dwi) (setq dwi vdwi))) ;Vorschlag bernehmen
;Abfrage Fortsetzung       
 (setq x (getreal "\nWicklungsausldg. Stat. (mm)= "))             ;x
 (setq lxakt (+ lfe 60 (* 2 x)))                                 ;lxakt
 (setq vdwlb dwla)        ;vdwlb
          (princ "\nLager NS, Innendurchm. (mm) ")
          (princ " = <")
          (princ vdwlb)   ;Vorschlagswert anzeigen
          (princ "> ")
          (setq dwlb (getreal))                                  ;dwlb
          (cond ((null dwlb) (setq dwlb vdwlb))) ;Vorschlag bernehmen
 (setq vblb bla)         ;vblb
          (princ "\nLager NS, Breite (mm) ")
          (princ " = <")
          (princ vblb)   ;Vorschlagswert anzeigen
          (princ "> ")
          (setq blb (getreal))                                    ;blb
          (cond ((null blb) (setq blb vblb))) ;Vorschlag bernehmen
 (setq vdlb dla)          ;vdla
          (princ "\nLager NS, Auendurchm. (mm) ")
          (princ " = <")
          (princ vdlb)    ;Vorschlagswert anzeigen
          (princ "> ")
          (setq dlb (getreal))                                    ;dlb
          (cond ((null dlb) (setq dlb vdlb))) ;Vorschlag bernehmen
 (setq vhnabb hnaba)          ;vhnabb
          (princ "\nLagernabe NS, Dicke (mm) ")
          (princ " = <")
          (princ vhnabb)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq hnabb (getreal))                                   ;hnabb
          (cond ((null hnabb) (setq hnabb vhnabb))) ;Vorschlag bernehmen
 (setq vbnabb bnaba)          ;vbnabb
          (princ "\nLagernabe NS, Breite (mm) ")
          (princ " = <")
          (princ vbnabb)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq bnabb (getreal))                                   ;bnabb
          (cond ((null bnabb) (setq bnabb vbnabb))) ;Vorschlag bernehmen
 (setq vllb (+ 30 blb))    ;vllb
          (princ "\nLnge Lagerstelle NS (mm) ")
          (princ " = <")
          (princ vllb)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq llb (getreal)) ;llb eingeben                       ;llb
          (cond ((null llb) (setq llb vllb))) ;Vorschlag bernehmen
 (setq vdwlu (- dwe 20))   ;vdwlu
          (princ "\nWellendurchm. beim Lfter (mm) ")
          (princ " = <")
          (princ vdwlu)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq dwlu (getreal))  ;dwlu eingeben                    ;dwlu
          (cond ((null dwlu) (setq dwlu vdwlu))) ;Vorschlag bernehmen
 (setq vllu 40)   ;vllu
          (princ "\nLnge Lftersitz (mm) ")
          (princ " = <")
          (princ vllu)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq llu (getreal))  ;llu eingeben                      ;llu
          (cond ((null luu) (setq llu vllu))) ;Vorschlag bernehmen
(setq hstab (getreal "\nRotor: Stabhhe (rad.) (mm)  "))           ;hstab
(setq vlstab (+ lfe 40))   ;vlstab
          (princ "\Stablnge zwischen Ringen (mm) ")
          (princ " = <")
          (princ vlstab)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq lstab (getreal))  ;lstab eingeben                  ;lstab
          (cond ((null lstab) (setq lstab vlstab))) ;Vorschlag bernehmen
(setq vhn2 (+ hstab 2.5))   ;vhn2
          (princ "\nRotornuttiefe (mm) ")
          (princ " = <")
          (princ vhn2)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq hn2 (getreal))  ;hnd eingeben                      ;hn2
          (cond ((null hn2) (setq hn2 vhn2))) ;Vorschlag bernehmen
(setq bring (getreal "\nRotor: KS-Ringbreite (ax.) (mm) = "))      ;bring
(setq vhring hstab)        ;vhring
          (princ "\nRotor: KS-Ringhhe (rad.) (mm) ")
          (princ " = <")
          (princ vhring)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq hring (getreal))  ;hring eingeben                  ;hring
          (cond ((null hring) (setq hring vhring))) ;Vorschlag bernehmen
(setq vs1 0.5)   ;vs1
          (princ "\nStatornut. Schlitzhhe (rad.) (mm) ")
          (princ " = <")
          (princ vs1)     ;Vorschlagswert anzeigen
          (princ "> ")
          (setq s1 (getreal))  ;s1 eingeben                        ;s1
          (cond ((null s1) (setq s1 vs1))) ;Vorschlag bernehmen
(setq hn1 (getreal "\nStator: Nuthhe (rad.) (mm) = "))            ;hn1 
(setq da (getreal "\nStator: Auendurchm. Blech (mm) = "))         ;da 
(setq dgeh (getreal "\nGehusedicke (rad.) (mm) = "))              ;dgeh 
(setq hripp (getreal "\nHhe der Khlrippen (rad.) (mm) = "))      ;hripp
;Ende des Eingabeteils
;
;Zeichnung des Wellenendes
(command "layer" "se" "kanten" "")                    ;layer Kanten setzen
(setq a (polar e (/ pi 2) (/ dwe 2))                  ;Eckpunkte zuweisen
      b (list (+ (car a) lwe) (+ (cadr e) (/ dwla 2)))
      bm (polar e 0 lwe)
      bl (polar bm (/ pi 2) (/ dwe 2))
      c (list (+ (car b) lla) (+ (cadr e) (/ dwi 2)))  
      cm (polar bm 0 lla)
      cl (polar cm (/ pi 2) (/ dwla 2))
      d (polar c 0 lxakt)
      dm (polar cm 0 lxakt)
      dl (polar dm (/ pi 2) (/ dwlb 2))
      eo (list (+ (car d) llb) (+ (cadr e) (/ dwlb 2)))  
      em (polar dm 0 llb)
      el (polar em (/ pi 2) (/ dwlu 2))
      f (list (+ (car eo) llu) (+ (cadr e) (/ dwlu 2)))  
      fm (polar em 0 llu)
      fuli (list (- (car e) 40) (- (cadr e) h))
      fure (list (+ (car fm) 50) (cadr fuli)) 
      mpk (polar fm 0 (+ h 150))
      fukli (list (- (car mpk) (+ h 40)) (- (cadr mpk) h))
      fukre (list (+ (car mpk) (+ h 20)) (cadr fukli))
)
(command "linie" e a bl b cl c d dl eo el f fm "")   ;Wellenkontur zeichnen
(command "linie" bm bl "")
(command "linie" cm cl "")
(command "linie" dm dl "")
(command "linie" em el "")
(command "linie" fuli fure "")                      ;Fuauflage zeichnen
(command "linie" fukli fukre "")                    ;Fuaufl. Kreuzri
;
;Mittellinie der Welle zeichnen (beide Risse)
(command "layer" "se" "mittel" "")                  ;layer mittel setzen 
(setq mwli (polar e pi 20)                          ;Endpkte d. Mittellin.
      mwre (polar fm 0 30)
      mwkli (polar mpk pi (+ h 60))
      mwkre (polar mpk 0 (+ h 40))
      mwku (polar mpk (- 0 (/ pi 2)) (+ h 20))
      mwko (polar mpk (/ pi 2) (+ h 120))
)
(command "linie" mwli mwre "")                      ;Mittell. Lngs zeichnen
(command "linie" mwkli mwkre "")                    ;Kreuzri hor.
(command "linie" mwku mwko "")                      ;Kreuzri vert.
;
;zeichnen der Lager
  (setq lla1 cl                                     ;Eckpunkte der Lagerkontur
        lla2 (polar cl pi bla)
        lla3 (list (car lla2) (+ (cadr e) (/ dla 2)))
        lla4 (list (car cl) (cadr lla3))
        llb1 dl                                      ;Lager B - Seite
        llb2 (polar dl 0 blb)
        llb3 (list (car llb2) (+ (cadr e) (/ dlb 2)))
        llb4 (list (car dl) (cadr lla3))
        deltanaba (/ (- bnaba bla) 2)
        deltanabb (/ (- bnabb blb) 2)
        na1 (list (+ (car cl) deltanaba) (cadr lla4)) ;Nabenecken A - Seite
        na2 (polar na1 pi bnaba)
        na3 (list (car na2) (+ (cadr na2) hnaba))
        na4 (list (car na1) (cadr na3))
        nb1 (list (- (car dl) deltanabb) (cadr llb4)) ;Nabenecken B - Seite
        nb2 (polar nb1 0 bnabb)
        nb3 (list (car nb2) (+ (cadr nb2) hnabb))
        nb4 (list (car nb1) (cadr nb3))
        mnablali (list (- (car na2) 15) (+ (cadr na1) (/ hnaba 2)))
        mnablare (polar mnablali 0 (+ bnaba 30))
        mnablbli (list (- (car nb1) 15) (+ (cadr nb1) (/ hnabb 2)))
        mnablbre (polar mnablbli 0 (+ bnabb 30))
  );setq zu
;Lager - und Nabenkonturen
  (command "layer" "se" "kanten" "")                                       
    (command "linie" na1 na2 na3 na4 "s")
    (command "linie" nb1 nb2 nb3 nb4 "s") 
    (command "linie" lla1 lla2 lla3 lla4 "s") 
    (command "linie" llb1 llb2 llb3 llb4 "s") 
  (command "layer" "se" "mittel" "")       ;Mittellinien Lagerverschrbg.
    (command "linie" mnablali mnablare "")
    (command "linie" mnablbli mnablbre "")
  (command "layer" "se" "schmal" "")       ;Lager auskreuzen
    (command "linie" lla1 lla3 "")
    (command "linie" lla2 lla4 "")
    (command "linie" llb1 llb3 "")
    (command "linie" llb2 llb4 "")
;  
;Zeichnen des Rotorpakets und der Rotorwicklung 
  (setq rlu (list (+ (car c) x 30) (cadr c)) ;Rotorkontur links unten
        rblh (- (/ (- db dwi) 2) lluft)      ;Rotorblechhhe (eins.)
        rlo (polar rlu (/ pi 2) rblh)
        rro (polar rlo 0 lfe)
        rru (polar rlu 0 lfe)
        stabvor (/ (- lstab lfe) 2)             ;Stabvorstand
        stabru (polar rro (- 0 (/ pi 2)) hn2) ;re. Stab unten (Blech)
        stabrendu (polar stabru 0 stabvor)    ;Stabende unten
        stabrendo (polar stabrendu (/ pi 2) hstab)
        stabro (polar stabru (/ pi 2) hstab)
        ringendu (polar stabrendu 0 bring)
        ringendo (polar ringendu (/ pi 2) hring)
        ringo (polar stabrendu (/ pi 2) hring) 
        stabkontli (polar stabru pi lfe)
  );setq zu
  (command "layer" "se" "kanten" "") 
    (command "linie" rlu rlo rro rru "")
    (command "linie" stabru stabrendu stabrendo stabro "")
    (command "linie" stabrendu ringendu ringendo ringo "")
;  
;Statorpaket, Nutgrund, Gehuse, Rippen
  (setq slu (polar rlu (/ pi 2) (/ (- db dwi) 2))
        slo (polar slu (/ pi 2) (/ (- da db) 2))
        sro (polar slo 0 lfe)
        sru (polar slu 0 lfe)
        nutkontli (polar slu (/ pi 2) hn1)
        nutkontre (polar nutkontli 0 lfe)
        gehli (polar slo pi 40)
        gehre (polar gehli 0 (+ lfe 80))
        gehkontli (polar gehli (/ pi 2) dgeh)
        gehkontre (polar gehkontli 0 (+ lfe 80))
        rippli (polar gehkontli (/ pi 2) hripp)
        rippre (polar rippli 0 (+ lfe 80))
        raus (polar sru (/ pi 2) s1)
        vorn (- x (* 0.75 hn1))
        sbog (polar raus 0 vorn)
        mbog (polar sbog (/ pi 2) (* 0.75 hn1))
        wbog 210
  );setq zu
    (command "linie" slu slo sro sru "s")
    (command "linie" rippli rippre "")
    (command "linie" raus sbog "")
    (command "linie" gehli gehre "")
    (command "bogen" sbog "m" mbog "wi" wbog)
  (command "layer" "se" "verdeckt" "")
    (command "linie" stabru stabkontli "")
    (command "linie" nutkontli nutkontre "")
    (command "linie" gehkontli gehkontre "")
;
;Kreuzri: Bohrung, Gehusekontur, Rippenkontur
  (setq stb (polar mpk (/ pi 2) (/ db 2))
        str (polar stb (* pi 1.5) lluft)
        stn2gr (polar str (* pi 1.5) hstab)
        stn1gr (polar stb (* pi 0.5) hn1)
        stwi (polar mpk (* pi 0.5) (/ dwi 2))
        stgehi (list (car mpk) (cadr gehli))
        stgeha (polar stgehi (/ pi 2) dgeh)
        dlufthaub (+ da (* 2 (+ dgeh hripp 1.5)))
        stlufthi (polar stgeha (/ pi 2) hripp)
        stwellend (polar mpk pi (/ dwe 2))
        st1abs (polar mpk pi (/ dwla 2)) 
        stgehans (polar mpk pi (+ (/ da 2) dgeh))
  );setq zu
  (command "bogen" stn2gr "m" mpk "wi" 90)
  (command "bogen" stn1gr "m" mpk "wi" 90) 
  (command "layer" "se" "kanten" "")
  (command "kreis" mpk "d" dlufthaub)
  (command "bogen" stb "m" mpk "wi" 90) 
  (command "bogen" str "m" mpk "wi" 90)   
  (command "bogen" stwi "m" mpk "wi" 90)   
  (command "bogen" stgehi "m" mpk "wi" 90)       
  (command "bogen" stgeha "m" mpk "wi" 90)   
  (command "bogen" stwellend "m" mpk "wi" 180)   
  (command "bogen" st1abs "m" mpk "wi" 180)   
  (command "bogen" stgehans "m" mpk "wi" 180)    
); Programmende

